/*
 * File......: ISREMOTE.C
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

// NOTE: This code has been written for and compiled with Borland C++
//       Version 3.1
//

#include <extend.h>
#include "internal.h"

/*  $DOC$
 *  $FUNCNAME$
 *      GT_REMOTE()
 *  $CATEGORY$
 *      Environment
 *  $ONELINER$
 *      Check if a drive as a remote drive.
 *  $SYNTAX$
 *      GT_Remote([<ncDrive>]) --> lIsRemote
 *  $ARGUMENTS$
 *      <ncDrive> is an optional parameter that is the id of the drive
 *      to be checked. This paramater can be either a character value who's
 *      first character is taken as the drive letter or a numeric value
 *      where 0 = Default, 1 = A:, 2 = B:, etc... If no parameter is
 *      passed the default drive is used.
 *  $RETURNS$
 *      A logical value, true (.T.) if the drive is a remote drive, false
 *      (.F.) if it is local.
 *  $DESCRIPTION$
 *      GT_Remote() can be used to check if a drive is a remote device.
 *  $EXAMPLES$
 *      // Each of the following check if drive D: is a remote drive.
 *
 *      ? GT_Remote("D:")
 *      ? GT_Remote("D")
 *      ? GT_Remote("Dark Knight")     // First letter is used only.
 *      ? GT_Remote(4)
 *
 *      // The next two check the current drive.
 *
 *      ? GT_Remote(0)
 *      ? GT_Remote()
 *  $END$
 */

CLIPPER GT_Remote()
{
        char Drive = _GT_Internal_GetDriveName(1);

        asm     Mov     AX,0x4409
        asm     Mov     BL,Drive
        asm     Int     0x21
        _retl((_DX & 0x800) == 0);
}
