/*
 * File......: ISBUSDAY.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_ISBUSDAY()
 *  $CATEGORY$
 *      Date
 *  $ONELINER$
 *      See if a date is a business day
 *  $SYNTAX$
 *      GT_IsBusDay( dDate , cCurrency )
 *  $ARGUMENTS$
 *      dDate     - Date to check
 *      cCurrency - Curreny code of country - not yet used
 *  $RETURNS$
 *      .T. if date is a business day
 *      .F. otherwise
 *  $DESCRIPTION$
 *      This implementation checks to see if a date is a week day.
 *      Future implementations will check for bank holidays.
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

*
FUNCTION GT_IsBusDay( dDate , cCurrency )

/*****************************************************************************
 Purpose - Check if given date is a business day in the given country
 Returns - True if date is a business day, False otherwise
 Author  - Martin Colloby
 Created - 21/12/90
******************************************************************************
 Parameters - dDate      - Date to check
              cCurrency  - Curreny code of country
 Privates   - None
 Locals     - lIsBusDay  - Set if dDate is a business day
 Externals  - None
*****************************************************************************/

LOCAL lIsBusDay := .F.

* First check if day is a week day
DO CASE
    CASE DOW( dDate ) == 7
        lIsBusDay := .F.
    CASE DOW( dDate ) == 1
        lIsBusDay := .F.
    OTHERWISE
        lIsBusDay := .T.
ENDCASE

** Now check the bank holiday file
*if not isfile("bankhols") then
*    GT_Warning("Cannot find bank holidays file !")
*    m_isbusday := .F.
*else
*    view "bankhols"
*    locate p_currency + p_date
*    if retval then
*        m_isbusday := .F.
*    endif
*endif

RETURN( lIsBusDay )
*
