/*
    File......: GT_Use.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 10/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 10/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_USE()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Use a DBF file shared or exclusive.
 *  $SYNTAX$
 *      GT_Use(<cFile>,[<lExclusive>],[<cAlias>]) -> cAlias
 *  $ARGUMENTS$
 *      <cFile> is the name of the file to open.
 *
 *      <lExclusive> use file shared or exclusive.
 *
 *      <cAlias> is the alias to use if successful.
 *  $RETURNS$
 *      cAlias
 *  $DESCRIPTION$
 *      Use a DBF file shared or exclusive.
 *  $EXAMPLES$
 *      // Open a DBF file exclusively
 *      IF EMPTY(GT_Use('INVS0293',.T.,'INVOICES'))
 *          ? 'Error'
 *      ENDIF
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

#define HEIGHT  06
#define WIDTH   16

FUNCTION GT_Use(cFile,lExclusive,cAlias)

LOCAL cScreen := ''
LOCAL lMessage := .F.
LOCAL lSuccess := .F.
LOCAL nBottom := INT((MAXROW() + HEIGHT)/2)
LOCAL nKey := 0
LOCAL nLeft := INT((MAXCOL() - WIDTH)/2)
LOCAL nPause := 0.5
LOCAL nRight := nLeft - WIDTH
LOCAL nSeconds := 120
LOCAL nTop := nBottom - HEIGHT

Default cFile to ''
Default lExclusive to .F.
Default cAlias to cFile

//  Trim dots
nKey := AT('.',cAlias) - 1
IF nKey > 0
    cAlias := SUBSTR(cAlias,1,nKey)
ENDIF

//  Trim '\'
nKey := RAT('\',cAlias) + 1
IF nKey > 1
    cAlias := SUBSTR(cAlias,nKey)
ENDIF

//  Trim ':'
nKey := RAT(':',cAlias) + 1
IF nKey > 1
    cAlias := SUBSTR(cAlias,nKey)
ENDIF

cAlias := UPPER(cAlias)

BEGIN SEQUENCE

    // Attempt the USE
    SELECT((cAlias)->(SELECT()))
    USE // Nothing

    DO WHILE nSeconds > 0 .AND. (.NOT. lSuccess) .AND. ;
        (nKey != K_ESC)

        // Attempt use
        IF lExclusive
            USE (cFile) EXCLUSIVE ALIAS (cAlias)
        ELSE
            USE (cFile) SHARED ALIAS (cAlias)
        ENDIF
        lSuccess := (ALIAS() == cAlias)

        IF .NOT. lSuccess

            // Message ?
            IF .NOT. lMessage

                // Save
                cScreen := SAVESCREEN(nTop,nLeft,nBottom,nRight)

                // Display
                GT_Window(nTop,nLeft,nBottom,nRight,BOX_SS, ;
                    NIL,'Opening ....',.T.)

                // Position for message
                @ nTop+02, nLeft+02 SAY 'Timeout:'
                @ nTop+04, nLeft+02 SAY PADC('EscExit',WIDTH-03)

                lMessage := .T.

            ENDIF

            @ nTop+02, nLeft+09 SAY PADR(INT(nSeconds),3)

            // Wait
            nKey := INKEY(nPause)
            nSeconds -= nPause

        ENDIF

    ENDDO

ENDSEQUENCE

IF lMessage
    RESTSCREEN(nTop,nLeft,nBottom,nRight,cScreen)
ENDIF

/*
    End of GT_Use()
*/
RETURN(IF(lSuccess,UPPER(ALIAS()),'')) // 

