/*
 * File......: GT_S2Arr.prg
 * Author....: Niall Scott
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Niall Scott
 * Date......: 29/6/93
 * Revision..: 1.0
 * Log file..: $Logfile$
 *
 * This is an original work by Niall R Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * Rev 1.0  29/6/93
 * Initial Revision
 */

/*  $DOC$
 *  $FUNCNAME$
 *      GT_S2ARR()
 *  $CATEGORY$
 *      Array
 *  $ONELINER$
 *      Function to convert a Delimited String to an array
 *  $SYNTAX$
 *      aArray := GT_S2Arr( cString, cDelim)
 *  $ARGUMENTS$
 *      cString - String to be parsed
 *	    aDelim  - Delimiting Character
 *  $RETURNS$
 *      Array of Strings
 *  $DESCRIPTION$
 *      Simple function to convert a delimited string to an
 *		array.
 *  $EXAMPLES$
 *      aArr := GT_S2Arr('One,Two,Three', ',')
 *	    returns {'One','Two','Three'}
 *  $SEEALSO$
 *      GT_A2STR()
 *  $INCLUDE$
 *
 *  $END$
 */

#include "gt_lib.ch"

FUNCTION GT_S2Arr( cStr, cDelim )
	LOCAL nPos
	LOCAL aList := {}

	DEFAULT cDelim TO ','

	DO WHILE (nPos := AT(cDelim, cStr)) != 0
		AADD(aList, AllTrim(SUBSTR(cStr, 1, npos - 1)))
		cStr := SUBSTR(cStr, nPos + 1)
	ENDDO
	AADD(aList, AllTrim(cStr))
RETURN aList
