/*
    File......: GT_NewScreen.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 04/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 04/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_NEWSCREEN()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *      Completely redraw the screen with a header.
 *  $SYNTAX$
 *      GT_NewScreen([<cTitle>],[<cCopyRight>],<cVersion>],
 *                   [<cMainColour>],[<cTopColour>])
 *  $ARGUMENTS$
 *      <cTitle> is the title tobe displayed centered.
 *
 *      <cCopyRight> is the message to be displayed top
 *      left.
 *
 *      <cVersion> is the version number to be displayed
 *      under <cCopyRight>.
 *
 *      <cMainColour> is the colour pair for the main
 *      screen. A normal colour string may be used and the
 *      first pair will be extracted.
 *
 *      <cTopColour> is the colour pair for the header of
 *      the screen. A normal colour string may be used and
 *      the first pair will be extracted.
 *  $RETURNS$
 *      .T. / .F. based on success.
 *  $DESCRIPTION$
 *      Completely redraw the screen with a header.
 *  $EXAMPLES$
 *      // Blank header
 *      GT_NewScreen()
 *
 *      // Header with info using standard colours
 *      GT_NewScreen( Stock Control',  ;
 *                    '(C) ComputAssist 1989/93', ;
 *                    'Rev 1.01a')
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_NewScreen(cTitle,cCopyRight,cVersion, ;
    cMainColour,cTopColour)

LOCAL cColour := SETCOLOR()
LOCAL cDate := GT_TextDate(DATE())

Default cTitle to ''
Default cCopyRight to ''
Default cVersion to ''
Default cMainColour to SETCOLOR()
Default cTopColour to SETCOLOR()

//  Set colour to standard & clear screen
SETCOLOR(cMainColour)
DISPBOX(00,00,MAXROW(),MAXCOL(),'')

//  Set header
SETCOLOR(cTopColour)
SCROLL(00,00,01,MAXCOL(),0)

@ 00, 01 SAY cCopyRight
@ 00, MAXCOL() - LEN(cDate) SAY cDate

@ 01, ((MAXCOL() - LEN(cTitle)) / 2) SAY cTitle
@ 01, 01 SAY cVersion

//  Set colour back to standard
SETCOLOR(cColour)

/*
    End of GT_NewScreen()
*/
RETURN(.T.) // 
