* Originally setup by the GT_GANG at the GT Clipper day.
* modifications by Martin Bryant

#ifndef __GT_LIB_CH   // Don't include it more than once


#define __GT_LIB_CH

// Include any other .ch files

#INCLUDE "setcurs.ch"
#INCLUDE "directry.ch"
#INCLUDE "box.ch"
#INCLUDE "inkey.ch"
#INCLUDE "fileio.ch"
#INCLUDE "colors.ch"
#INCLUDE "Set.ch"
#INCLUDE "Getexit.ch"
#INCLUDE "array.ch"

#define   CRLF          (CHR(13)+CHR(10))
#define   CR_LF         (CHR(13)+CHR(10))
#define   K_CRLF        (CHR(13)+CHR(10))
*#define   K_LF          CHR(10))
#define   FORMFEED      CHR(12)
#define   BACKSLASH     CHR(92)
#define   EMPTYDATE     CTOD(SPACE(8))
#define   NULL          ''
#define   TRUE          .T.
#define   FALSE         .F.
*#define   K_SPACE       32
#DEFINE   K_UNDO      K_CTRL_U

#define BOX_DD      'ͻȺ '
#define BOX_DS      '͸Գ '
#define BOX_SD      'ķӺ '
#define BOX_SS      'Ŀ '

#translate Undefined(<var>)     => (<var> == NIL)
#translate Defined(<var>)       => (<var> != NIL)

#command DEFAULT <p> TO <val> [,<pn> TO <valn>];
			=>;
            <p> := iif(<p> == NIL,<val>,<p>);
            [;<pn> := iif(<pn> == NIL, <valn>,<pn>)]

// define for number of seconds to wait before timeout on record locks and
// file opens
#define LOCKWAITTIME    5

// Define AUDIT types - System reserved values are "90" and above
#define A_LOGON         "90"
#define A_LOGOFF        "91"
#define A_LOGFAIL       "92"
#define A_DELETE        "93"
#define A_TRASHCAN      "94"    // Audit record created when record is trashcanned
#define A_ADDRECORD     "95"
#define A_EDITRECORD    "96"

* Define video rows
#define V_EGA       43
#define V_VGA       50
#define V_NORMAL    25

* Define video columns
#define V_SINGLE    80
#define V_DOUBLE    40
#define V_NOCHANGE  0

// Valtype types
#define TYPE_ARRAY "A"
#define TYPE_BLOCK "B"
#define TYPE_STRING "C"
#define TYPE_CHAR "C"
#define TYPE_DATE "D"
#define TYPE_LOGICAL "L"
#define TYPE_MEMO "M"
#define TYPE_NUMERIC "N"
#define TYPE_NUMBER "N"
#define TYPE_OBJECT "O"
#define TYPE_NIL "U"
#define TYPE_UNDEFINED "U"

// AShrink()
#xtranslate aShrink(<aArray>,<nAmt>) =>;
          asize(<aArray>,len(<aArray>)-<nAmt>)

//  Index key as a block
#translate GT_IndexBlock(<n>)   =>  ;
    &('{ || ' + ;
        If(Empty(Indexkey(<n>)),'NIL',Indexkey(<n>)) + ;
        ' }')

//  Turn the cursor on
#translate GT_ShowCursor()      => ;
    SetCursor(If(ReadInsert(),SC_INSERT,SC_NORMAL))

//  Turn the cursor off
#translate GT_NoCursor()        => ;
    SetCursor(SC_NONE)

#translate GT_Read(<a>)         => ;
    AEVAL({ { | |  SETCURSOR(IF(READINSERT(), ;
    SC_INSERT,SC_NORMAL)) }, ;
    { | | READMODAL(<a>) }, ;
    { | | SETCURSOR(SC_NONE) } }, ;
    { | bData, nElem | EVAL(bData) })

// List of all PUBLIC And PRIVATE variables used to pass info
// to Library functions
MEMVAR cDefaultPath  , ;
       cSystemName   , ;
       cUserName     , ;
       nPageLen      , ;
       nUserLevel

#endif
