/*
    File......: GT_Hilite.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 10/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 10/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_HILITE()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *      Change the flash brightnes etc of a colour string.
 *  $SYNTAX$
 *      GT_Hilite([<cColour>]) -> cNewColour
 *  $ARGUMENTS$
 *      <cColour> is the colour to use. If not specified
 *      the default colour will be used.
 *  $RETURNS$
 *      cNewColour
 *  $DESCRIPTION$
 *      Change the flash brightnes etc of a colour string.
 *  $EXAMPLES$
 *      // Hilite
 *      cFlash := GT_Hilite(cMessageColour,'*')
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

Function GT_Hilite(cColour,cCode)

LOCAL cReturn := ''
LOCAL cTemp := ''
LOCAL nCount := 0
LOCAL nParts := 05
LOCAL nFound := 0

Default cColour to SETCOLOR()
Default cCode to '*'

//  Extract colors
FOR nCount := 1 TO nParts

    // Found a Comma ?
    nFound := AT(',',cColour)
    IF nFound > 0
        cTemp := SUBSTR(cColour,1,nFound-1)
    ELSE
        cTemp := cColour
    ENDIF

    // Extract
    cColour := SUBSTR(cColour,AT(',',cColour)+1)

    // Convert
    IF nCount != 3 .AND. nCount != 4

        // Not background etc
        cTemp := IF(cCode$cTemp,STRTRAN(cTemp,cCode),cCode + cTemp)

    ENDIF

    // Add value
    cReturn += ',' + cTemp

NEXT

//  Remove First comma
cReturn := SUBSTR(cReturn,2)

/*
    End of GT_Hilite()
*/
RETURN(cReturn)

