/*
 * File......: GT_CURDR.PRG
 * Author....: Allen Bullen
 * BBS.......: The Dark Knight Returns
 * Net/Node..: WTF Is This ?
 * User Name.: Allen Bullen
 * Date......: 21/09/93
 * Revision..: 1.0
 *
 * This is an original work by Allen Bullen and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *      GT_CURDRIVE()
 *  $CATEGORY$
 *      Disk Drive
 *  $ONELINER$
 *      Retreive The Current Drive Letter
 *  $SYNTAX$
 *      GT_CURDRIVE()
 *  $ARGUMENTS$
 *      None
 *  $RETURNS$
 *      The Driver Letter Of The Current Drive
 *  $DESCRIPTION$
 *      Calls function 19h (25) of interupt 21h (33) using GT_INT86()
 *  $EXAMPLES$
 *      cDrive := GT_CURDRIVE()
 *  $END$
 */


#translate makehi( <x> ) => (<x> * (256))
#translate lowbyte( <x> ) => int( <x> % 256 )

Function GT_CURDRIVE()
   Local AX:=0,BX:=0,CX:=0,DX:=0,SI:=0,DI:=0,BP:=0,DS:=0,ES:=0
   AX := MakeHi( 25 )
   GT_INT86( 33, @AX,@BX,@CX,@DX,@SI,@DI,@BP,@DS,@ES )
Return CHR( 65+LowByte( AX ) )
