/*
 File......: GT_BLANK.prg
 Author....: Phillip Hamlyn
 BBS.......: The Dark Knight Returns
 Net/Node..: 050/069
 User Name.: Phillip Hamlyn
 Date......: 03/03/93
 Revision..: 1.0

 This is an original work by Phillip Hamlyn and is placed in the
 public domain.

 Modification history:
 ---------------------

 Rev 1.0 03/03/93
 Initial revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_BLANK()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Return a blank value for the type of parameter passed.
 *  $SYNTAX$
 *      GT_Blank( <xVar> ) --> <xBlankVar>
 *  $ARGUMENTS$
 *      <cVar>        Any Clipper variable type.
 *  $RETURNS$
 *      <xBlankVar>   A blank copy of the variable type of length of the
 *                    parameter.
 *  $DESCRIPTION$
 *      Return a blank value for the type of parameter passed.
 *  $EXAMPLES$
 *      GT_Blank(space(8)) --> space(8)
 *      GT_Blank("Phillip Hamlyn") --> space(14)
 *      GT_Blank( {|| "PCH" } ) --> space(3)
 *      GT_Blank( 123123 ) --> 0
 *      GT_Blank( ctod("31/08/69") ) --> ctod("")
 *      GT_Blank( {1,2,3} ) --> {}
 *      GT_Blank( TbrowseNew() ) --> NIL
 *      GT_Blank( TRUE ) --> FALSE
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "gt_lib.ch"

* * * * * * * * *
function GT_Blank (xVar)
* * * * * * * * *
// return a blank memory variable for GETS
do case
    case valtype(xVar) == TYPE_STRING
        return space(len(xVar))
    case valtype(xVar) == TYPE_NUMERIC
        return 0
    case valtype(xVar) == TYPE_DATE
        return ctod("")
    case valtype(xVar) == TYPE_ARRAY
        return {}
    case valtype(xVar) == TYPE_BLOCK
        return GT_Blank(eval(xVar))
    case valtype(xVar) == TYPE_LOGICAL
        return FALSE
    case valtype(xVar) == TYPE_MEMO
        return ""
    case valtype(xVar) == TYPE_OBJECT
        return NIL
    case valtype(xVar) == TYPE_NIL
        return NIL
endcase
return NIL
