/*
 File......: GT_ALT.prg
 Author....: Phillip Hamlyn
 BBS.......: The Dark Knight Returns
 Net/Node..: 050/069
 User Name.: Phillip Hamlyn
 Date......: 03/03/93
 Revision..: 1.0

 This is an original work by Phillip Hamlyn and is placed in the
 public domain.

 Modification history:
 ---------------------

 Rev 1.0 03/03/93
 Initial revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_ALT()
 *  $CATEGORY$
 *      Keyboard
 *  $ONELINER$
 *      Find the real value of an ALT key combination
 *  $SYNTAX$
 *      GT_Alt( <cNormLetter> | <nAltInkey> ) --> <nAltInkey> | <cNormLetter>
 *  $ARGUMENTS$
 *      <cNormLetter> is a character that can have an ALT combination.
 *      <nAltInkey>   is a key press that could be an ALT combination.
 *  $RETURNS$
 *      <cNormLetter> is the upper case character that relates to the
 *                    passed <nAltInkey> value. Default ""
 *      <nAltInkey>   is the inkey() value of the key that relates to
 *                    and ALT'ified character. Perhaps the example will
 *                    explain better :-). Default 0
 *  $DESCRIPTION$
 *      Function used to find out the real value of an ALT combination key.
 *      The problem with the Inkey() function is the ALT keys are not just
 *      a table offset from the 'real' keys ( like upper case and lower case
 *      keys are).
 *
 *      This simple function will return either the character value of an
 *      ALT key inkey() value, or the ALT key inkey() value of a passed
 *      character.
 *  $EXAMPLES$
 *      GT_Alt( K_ALT_A ) --> "A"
 *      GT_Alt( "A" ) --> K_ALT_A
 *
 *      GT_Alt( 0 ) --> ""
 *      GT_Alt( "" ) --> 0
 *
 *      GT_Alt( K_ALT_Z ) --> "Z"
 *      GT_Alt( K_ALT_C ) --> "C"
 *
 *      GT_Alt( "z" ) --> K_ALT_Z
 *      GT_Alt( "c" ) --> K_ALT_C
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

*/
#INCLUDE "gt_lib.ch"

* * * * * * * *
function GT_alt (xKey)
* * * * * * * *
local nIdx
static aCompare
if aCompare == NIL
   aCompare  := { ;
                    {"A",K_ALT_A} ,;
                    {"B",K_ALT_B} ,;
                    {"C",K_ALT_C} ,;
                    {"D",K_ALT_D} ,;
                    {"E",K_ALT_E} ,;
                    {"F",K_ALT_F} ,;
                    {"G",K_ALT_G} ,;
                    {"H",K_ALT_H} ,;
                    {"I",K_ALT_I} ,;
                    {"J",K_ALT_J} ,;
                    {"K",K_ALT_K} ,;
                    {"L",K_ALT_L} ,;
                    {"M",K_ALT_M} ,;
                    {"N",K_ALT_N} ,;
                    {"O",K_ALT_O} ,;
                    {"P",K_ALT_P} ,;
                    {"Q",K_ALT_Q} ,;
                    {"R",K_ALT_R} ,;
                    {"S",K_ALT_S} ,;
                    {"T",K_ALT_T} ,;
                    {"U",K_ALT_U} ,;
                    {"V",K_ALT_V} ,;
                    {"W",K_ALT_W} ,;
                    {"X",K_ALT_X} ,;
                    {"Y",K_ALT_Y} ,;
                    {"Z",K_ALT_Z} }
endif
if valtype(xKey) == "N"
   // weve been supplied with an ascii code of a key
   if (nIdx := ascan(aCompare,{|aElem| aElem[2] == xKey} ) ) == 0
      return ""
   endif
   // return the normal value of the key
   return aCompare[nIdx,1]
else
   // weve been supplied with a real  key and want to know the ascii value of the Alt combination
   if (nIdx := ascan(aCompare,{|aElem| aElem[1] == upper(xKey)} ) ) == 0
      return 0
   endif
   return aCompare[nIdx,2]
endif
return NIL
