/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: environ.c
 * Author....: Andy M Leighton
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Andy Leighton
 * Date......: $Date$
 * Revision..: $Revision$
 *
 * This is an original work by Andy Leighton and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*
 *  $DOC$
 *  $FUNCNAME$
 *      GT_ENVIRON()
 *  $CATEGORY$
 *      Environment
 *  $ONELINER$
 *      Returns a command line parameter
 *  $SYNTAX$
 *      GT_environ(<nPos>) --> cVar
 *  $ARGUMENTS$
 *      <nPos>  -   The position in the environment list
 *  $RETURNS$
 *      cVar    -   The environment variable
 *  $DESCRIPTION$
 *     Get an environment variable specified by it's position in the
 *     environ table by reading the C startup variables
 *  $EXAMPLES$
 *      local i
 *
 *      for i := 0 to GT_EnvCount()
 *          ? GT_Environ(i)
 *      next
 *  $CAVEATS$
 *      Does not check <nPos> is a valid position in the list.
 *  $END$
 */

#include "extend.h"

extern char **environ;

CLIPPER
GT_environ()
{
  _retc(environ[_parni(1)]);
}
