/*
 * File......: ENCRYPT.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_ENCODE()
 *  $CATEGORY$
 *      Security
 *  $ONELINER$
 *      Encode a string
 *  $SYNTAX$
 *      GT_Encode( cString )
 *  $ARGUMENTS$
 *      cString - String to be encoded
 *  $RETURNS$
 *      The encoded representation of cString.
 *  $DESCRIPTION$
 *      Uses an encryption algorithm to encode a string that can later be
 *      decoded using GT_Decode()
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_lib.ch"

FUNCTION GT_Encode( cString )

/*****************************************************************************
 Purpose - Encode a string
 Returns - Encoded string
 Author  - Martin Colloby
 Created - 3/3/92
 Edited  - 25/4/92 by Martin Colloby - Tidied up
******************************************************************************
 Parameters - cString - String to encode
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

RETURN( GT_Encrypt( ALLTRIM( cString ) ) )
*
STATIC FUNCTION GT_Encrypt( cString )

/*****************************************************************************
 Purpose - Encrypt a string
 Returns - Encrypted string
 Author  - Martin Colloby
 Created - 3/3/92
 Edited  - 25/4/92 by Martin Colloby - Tidied up
******************************************************************************
 Parameters - cString - String to encrypt
 Privates   - None
 Locals     - cChar   - Current character
              cRetStr - String to return
              nCount  - Count of characters processed
              nInt    - Integer part of character code
              nLength - Length of cString
              nRem    - Remainder of character code
 Externals  - None
*****************************************************************************/

LOCAL cChar   := ""
LOCAL cRetStr := ""
LOCAL nCount  := 1
LOCAL nInt    := 0
LOCAL nLength := LEN( cString ) * 2
LOCAL nRem    := 0

DO WHILE nCount <= nLength
    cChar := SUBSTR( cString , nCount , 1 )
    nInt := INT( ASC( cChar ) / 17 )
    nRem := ASC( cChar ) % 17               // Modulus 17
    cRetStr += ( CHR( nInt ) + CHR( nRem ) )
    nCount++
ENDDO

RETURN( cRetStr )
*
