/*
 * File......: DOSPATH.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_ISPATH()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Check to see if the given path is valid
 *  $SYNTAX$
 *      GT_IsPath( cPath )
 *  $ARGUMENTS$
 *      cPath - Path to consider
 *  $RETURNS$
 *      .T. if path is valid
 *      .F. otherwise
 *  $DESCRIPTION$
 *       Checks that all of the characters appearing in the string are valid
 *       for a DOS path
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

*
FUNCTION GT_IsPath( cPath )

/*****************************************************************************
 Purpose - Check that cPath is a valid DOS path
 Returns - .T. if cPath is valid
 Author  - Log
 Created - 06/11/92
******************************************************************************
 Parameters - cFile - Filename to test
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

LOCAL lCount   := 0
LOCAL lInValid := "/[]|<>+=;*.\? "  // :,
LOCAL nCount   := 0

cPath := ALLTRIM( cPath )

FOR nCount := 1 TO LEN( lInValid )
    IF AT( SUBSTR( lInValid , nCount , 1 ) , cPath ) > 0
        RETURN( .F. )
    ENDIF
NEXT nCount

RETURN( .T. )
*
