/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: chkkey.prg
 * Author....: Andy M Leighton
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Andy Leighton
 * Date......: $Date$
 * Revision..: $Revision$
 *
 * This is an original work by Andy Leighton and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *       GT_CHECKKEY()
 *  $CATEGORY$
 *       Keyboard
 *  $ONELINER$
 *       Check Key for Upper/Lower case, Control or Alt Letter
 *  $SYNTAX$
 *       GT_checkKey(<nKVal>, <cChkLetter>) --> lRet
 *  $ARGUMENTS$
 *       <nKVal>       - the inkey() value
 *       <cChkLetter>  - the letter to check for
 *  $RETURNS$
 *       lRet          - .T. if cChkLetter is pressed
 *  $DESCRIPTION$
 *       This function checks an inkey value against a letter to see
 *       if that letter has been pressed.
 *       Detects lower and uppercase, CTRL letter and ALT letter.
 *  $EXAMPLES$
 *  $END$
 */

#include "gt_LIB.ch"

function GT_checkKey(nKVal, cChkLetter)

   static altTab := { K_ALT_A, K_ALT_B, K_ALT_C, K_ALT_D, K_ALT_E,      ;
                      K_ALT_F, K_ALT_G, K_ALT_H, K_ALT_I, K_ALT_J,      ;
                      K_ALT_K, K_ALT_L, K_ALT_M, K_ALT_N, K_ALT_O,      ;
                      K_ALT_P, K_ALT_Q, K_ALT_R, K_ALT_S, K_ALT_T,      ;
                      K_ALT_U, K_ALT_V, K_ALT_W, K_ALT_X, K_ALT_Y,      ;
                      K_ALT_Z }

   local lRet := FALSE

   do case
      case lower(chr(nKVal)) == lower(cChkLetter)
         lRet := TRUE
      case upper(chr(nKVal)) == upper(cChkLetter)
         lRet := TRUE
      case altTab[asc(upper(cChkLetter)) - 64] == nKVal
         lRet := TRUE
      case asc(upper(cChkLetter)) - 64 == nKVal
         lRet := TRUE
   endcase

return lRet
