/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: bitstrip.c
 * Author....: Andy M Leighton
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Andy Leighton
 * Date......: 23/05/93
 * Revision..: 1.00
 *
 * This is an original work by Andy Leighton and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*
 *  $DOC$
 *  $FUNCNAME$
 *      GT_BITSTRIP()
 *  $CATEGORY$
 *      String
 *  $ONELINER$
 *      Clear the high bit for every character in a string
 *  $SYNTAX$
 *      GT_BitStrip(<cStr>) --> cOut
 *  $ARGUMENTS$
 *      <cStr>  - The string to strip
 *  $RETURNS$
 *      <cOut>  - The stripped string
 *  $DESCRIPTION$
 *      Return the supplied string with all high bits turned off.
 *      Useful for clearing the high bits ready for transfer to a
 *      system that only understands true ASCII and not IBM's
 *      bastardized version.
 *
 *      NOTE:
 *         invalid parameters will return ""
 *  $EXAMPLES$
 *
 *      local cStr := ""
 *      local i
 *
 *      for i := asc("A") to asc("Z")
 *         cStr := cStr + chr(i + 128)
 *      next
 *
 *      ? GT_BitStrip(cStr)         // prints ABCDEFGHIJKLMNOPQRSTUVWXYZ
 *  $END$
 */

#include "extend.h"

CLIPPER
gt_bitstri()
{
  char *s1, *s2;
  int len, i;

  if (ISCHAR(1)) {
    s1  = _parc(1);
    len = _parclen(1);

    s2  = _xgrab(len);              // grab us some mem to work with

    for (i = 0; i <= len; i++)
      s2[i] = s1[i] & 0x7f;         // strip off high bit

    _retc(s2);
    _xfree(s2);                     // free alloc'ed mem
  } else {
    _retc((char *) NULL);           // parameter mismatch - error NullStr
  }
}
