/*
 * File......: BARUPDATE.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_BARUPDATE()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *      Update a bar on screen
 *  $SYNTAX$
 *      GT_BarUpdate( nCurrent , nTotal , nTop , nLeft )
 *  $ARGUMENTS$
 *      nCurrent - Current value to be displayed
 *      nTotal   - Maximum value that can be displayed
 *      nTop     - Bar row
 *      nLeft    - Left column of bar
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      Updates a bar at the given coordinates.  The length of the bar is
 *      given by :
 *
 *          nCurrent / nTotal * 40
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_lib.ch"

FUNCTION GT_BarUpdate( nCurrent , nTotal , nTop , nLeft )

/*****************************************************************************
 Purpose - Update a moving bar chart
 Returns - None
 Author  - Martin Colloby
 Created - 05/08/91
******************************************************************************
 Purpose    - Update the current bar chart - created by BarInit()
 Parameters - nCurrent - Current value
              nTotal   - Maximum value
 Parameters - None
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

DEFAULT nTop  TO MAXROW() - 5
DEFAULT nLeft TO 20

* Output the bar
@ nTop + 1 , nLeft + 2 SAY REPLICATE( "" , INT( ( nCurrent / nTotal ) * 40 ) )

RETURN NIL
*
