/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: amsg.prg
 * Author....: Andy M Leighton
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Andy Leighton
 * Date......: $Date$
 * Revision..: $Revision$
 *
 * This is an original work by Andy Leighton and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *       GT_AMSG()
 *  $CATEGORY$
 *       Video
 *  $ONELINER$
 *       Boxed multi line message
 *  $SYNTAX$
 *       GT_aMsg([<aMss>], [<lWait>], [<cColour>]) --> NIL
 *  $ARGUMENTS$
 *       <nKVal>       - the inkey() value
 *       <cChkLetter>  - the letter to check for
 *  $RETURNS$
 *       NIL
 *  $DESCRIPTION$
 *       This function has 3 modes of operation
 *          1.  if <lWait> is TRUE display the message in a box
 *              and wait for a keypress.  Restire the screen when
 *              complete.
 *          2.  if <lWait> is FALSE or undefined, save the screen
 *              to a stack, display the message and return
 *          3.  if both <lWait> and <aMss> are undefined, restore
 *              the screen from the saved stack.
 *              The positioning information is optional and if it is left
 *              out the screen will restore to the postion it was saved.
 *              If coordinates are passed, they must represent an area
 *              exactly equal to that of the saved screen and in the same
 *              proportion otherwise the function will return .F.
 *  $EXAMPLES$
 *       aMsg( { "Line 1 of Message",              ;
 *               "Line 2 of Message",              ;
 *               "Last Line of Message" }, TRUE)
 *  $CAVEATS$
 *       Assumes every element of the array is a character.
 *       Gets in trouble if the length of an array element is
 *       longer than maxcol() - 3
 *  $END$
 */

#include "gt_LIB.ch"

// translate for aMaxStrLen()
// works a bit like the one in FuncKy

#translate amaxstrlen(<a>)      =>     len(GT_AComp(<a>, AC_MAXLEN))

function GT_aMsg(aMss, lWait, cColour)

   static aScrs := {}               // inbuilt stack - faster than general
                                    // purpose stack functions

   local nLines
   local nWidth
	local i
   local nLeft
   local nTop
   local nRight
   local nBottom

   if aMss == NIL .and. lWait == NIL
      if len(aScrs) > 0             // pop last screen from stack
         i := len(aScrs)
         restscreen(aScrs[i][1], aScrs[i][2], aScrs[i][3], aScrs[i][4], ;
                     aScrs[i][5])
         aScrs := aSize(aScrs, i - 1)
      endif
   else
      default lWait   to .F.
      default cColour to 'W+/R'

      nLines  := len(aMss) + 3
      nWidth  := aMaxStrLen(aMss) + 3
      nLeft   := (maxcol() - nWidth) / 2
      nTop    := (maxrow() - nLines) / 2
      nRight  := (maxcol() + nWidth) / 2
      nBottom := (maxrow() + nLines) / 2

      dispbegin()
      aAdd(aScrs, { nTop, nLeft, nBottom, nRight, ;
                     savescreen(nTop, nLeft, nBottom, nRight) })

      @ nTop, nLeft, nBottom, nRight box B_DOUBLE + " " color cColour

      for i := 1 to nLines - 3
         @ nTop + i + 1, nLeft + 2 say ;
                      strcenter(aMss[i], nWidth - 3) color cColour
      next

      dispend()

      if lWait
         waitkey(0)
         i := len(aScrs)
         restscreen(aScrs[i][1], aScrs[i][2], aScrs[i][3], aScrs[i][4], ;
                     aScrs[i][5])
         aScrs := aSize(aScrs, i - 1)
      endif
   endif

return NIL
