/*
 * File......: ADDREC.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_ADDREC()
 *  $CATEGORY$
 *      Network
 *  $ONELINER$
 *      Attempt to APPEND BLANK with optional retry
 *  $SYNTAX$
 *      GT_AddRec( nSeconds )
 *  $ARGUMENTS$
 *      nSeconds - Number of retry attempts (one per second)
 *  $RETURNS$
 *      .T. is successful, .F. otherwise
 *  $DESCRIPTION$
 *      Attempts to perform an APPEND BLANK to a network table.  If successful,
 *      returns .F., with the blank record selected.  If unsuccessful, waits
 *      for one second and tries again until nSeconds attempts have been made.
 *
 *      If nSeconds is 0, the routine will loop indefinately.
 *
 *      The table to be added to should be SELECTed before calling.
 *  $EXAMPLES$
 *      Add a record, aborting if not successful at the first attempt :
 *
 *          GT_AddRec( 1 )
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

FUNCTION GT_AddRec( nSeconds )

/*****************************************************************************
 Purpose - Attempt to APPEND BLANK with optional retry
 Returns - .T. if successful
 Author  - Martin Colloby
 Created - 20/05/92
******************************************************************************
 Parameters - nSeconds - Number of retries
 Privates   - None
 Locals     - lForever - If .T., loop forever
 Externals  - None
*****************************************************************************/

LOCAL lForever := (nSeconds == 0)

APPEND BLANK

IF .NOT. NETERR()
    RETURN (.T.)
ENDIF

DO WHILE (lForever .OR. nSeconds > 0)
    APPEND BLANK
    IF .NOT. NETERR()
        RETURN .T.
    ENDIF

    * Wait 1/2 second
    INKEY(.5)
    nSeconds := nSeconds - .5

ENDDO

* Not locked
RETURN (.F.)
*
