/*****************************************************************************/
/*                                                                           */
/* SCALAR.CMD                                                                */
/*                                                                           */
/* Simple functions to calculate the number of days from the given figures;  */
/* years, months, days or a date. See the comments before each function to   */
/* get an idea of what it does.                                              */
/*                                                                           */
/* Craig Morrison, 10 July 1994                                              */
/*                                                                           */
/* Use, abuse, fold, spindle, mutate or mutilate freely.                     */
/*                                                                           */
/* Those of you familiar with SNIPPETs from the C_ECHO should recognize the  */
/* alogrithm implemented below.                                              */
/*                                                                           */
/*****************************************************************************/

 dStr = DATE('S')               /* returns 19940710 */
 Year  = SubStr(dStr, 1, 4)     /*     get ^^^^     */
 Month = SubStr(dStr, 5, 2)     /*     get     ^^   */
 Day   = SubStr(dStr, 7, 2)     /*     get       ^^ */

 /* This will print the number of days since 01 January 1900 */
 say Date('B') + 1

 /* This will do the same with our functions */
 say YMDToScalar(Year, Month, Day)

 exit

/*****************************************************************************/
/*                                                                           */
/* IsLeapYear(Year)                                                          */
/*                                                                           */
/* Returns 1 for leap year, 0 otherwise                                      */
/*                                                                           */
/*****************************************************************************/
IsLeapYear:
     Procedure

     Parse Arg yr

     lpyear = 0;

     If yr // 400 = 0 Then
         lpyear = 1
     Else If yr // 4 = 0 Then
         If yr // 100 \= 0 Then lpyear = 1

 return lpyear

/*****************************************************************************/
/*                                                                           */
/* MonthsToDays(Months)                                                      */
/*                                                                           */
/* calculates days from a given number of months                             */
/*                                                                           */
/*****************************************************************************/
MonthsToDays:
     Procedure

     Parse Arg m

     d = trunc((m * 3057 - 3007) / 100)

 return d

/*****************************************************************************/
/*                                                                           */
/* YearsToDays(Years)                                                        */
/*                                                                           */
/* calculates days from the given years                                      */
/*                                                                           */
/*****************************************************************************/
YearsToDays:
     Procedure

     Parse Arg yr

     d = yr * 365 + trunc(yr / 4) - trunc(yr / 100) + trunc(yr / 400)

 return d

/*****************************************************************************/
/*                                                                           */
/* YMDToScalar(Year, Month, Day)                                             */
/*                                                                           */
/* calculates a scalar number from a date                                    */
/*                                                                           */
/*****************************************************************************/
YMDToScalar:
     Procedure

     Parse Arg yr, mo, day

     scalar = day + MonthsToDays(mo)
     If mo > 2 Then Do
         If IsLeapYear(yr) Then
             scalar = scalar - 1
         Else
             scalar = scalar - 2
     End

     scalar = scalar + YearsToDays(yr - 1)

 return scalar
