/*                                                                           */
/* FMTDESC.CMD                                                               */
/*                                                                           */
/* Craig Morrison, 10 July 1994, inspired and requested by Elliott Goodman,  */
/* who can be credited for quite a few things in MaxFile/PM.                 */
/*                                                                           */
/* An example REXX script that will take a given string and perform simple   */
/* word wrapping to 'format' a line of text. This roughly approximates the   */
/* 'Format Description' option included in MaxFile/PM.                       */
/*                                                                           */
/* Use, abuse, fold, spindle or mutilate freely.                             */
/*                                                                           */

text = ' This is a long 'x2c('0d')' 'x2c('0a')' string > that is going to get '
text = text||'formatted for Elliott. '
text = text||Copies('01234567890123456', 4)||text

lmargin = 16         /* how far from the left margin the ED Marker should be */
llength = 45                 /* this is how long each line segment should be */
EDMarker = '>'        /* Set EDMarker to your extended description character */

spaces = SubStr(Copies(' ', 80), 1, lmargin)||EDMarker||' '

/* Translate all CRs, LFs and Extended Description Markers into spaces       */
ntext = Translate(text, '   ', x2c('0d')||x2c('0a')||EDMarker)

ntext = Space(ntext, 1)                       /* remove all the extra spaces */

Say 'Before:'
Say
Say Text

text = GetOneLine(llength, ntext)
ntext = Space(DelWord(ntext, 1, Words(text)), 1)
Do While Length(ntext) \= 0
    wText = GetOneLine(llength, ntext)
    text = text||x2c('0d')||x2c('0a')||spaces||wText
    ntext = Space(DelWord(ntext, 1, Words(wText)), 1)
End

Say
Say 'After:'
Say
Say text

Exit

/*
    GetOneLine takes a variable length string and returns a blank delimited
    string that is a substring of inText and is no longer than llen
    characters.

    A single word that is longer than llen is simply truncated at llen when it
    would be the only word in a line segment and not wrappable. Its cheesy and
    cheap, but hey, it works.. ;-)
*/
GetOneLine:

    Parse Arg llen, inText

    cText = ''
    Do While Length(cText' 'Word(inText, 1)) < llen
        cText = cText' 'Word(inText, 1)
        inText = DelWord(inText, 1, 1)
        If inText = '' Then Leave
    End

    if cText = '' Then Do
        cText = Left(inText, llen)
    End

Return Space(cText, 1)
