DECLARE SUB PcbPrint (StringInput$)
DEFINT A-Z
DECLARE FUNCTION PCBFilter$ (TextInput$)
'AnsiGraph Toolkit....              
'                Ŀ Ŀ     Ŀ  Ŀ Ŀ Ŀ Ŀ
'                 ô      ô   Ĵ  ô  
'                                 
'
'                                
'                                 
'                                          
'
'                         
'                                   
'                                      Version
'                                           1.2
'
'      Ŀ Ŀ  Ŀ Ŀ Ŀ       Ŀ  Ŀ Ŀ
'                                 
'                                
'
'
'         Ŀ ķ                                        
'                         
'                                
' 
'
'        Robert L. Spier                Internet: robert.spier@hardgood.com
'        One Lookout Circle             Rime: Robert Spier -> APPLEWIZ or -> ACC
'        Larchmont, NY 10538            Intelec: Robert Spier in Netchat, Programming.
'
'  See AnsiG.txt for more info.  Registration $20.
'
' PCBPrint will print a string (Starting at the current cursor location)
'and will use all of the applicable PCBANSI formatting codes.  @X.. It will NOT
'strip @..@ codes from the text, so please don't include them.  If that is
'needed,  it will be implemented in a future verison.
' PCBFilter, filters out all of the @X.. codes from a string and returns, the
' plain string.
'
'Demo
'     b$ = "@X24Hello!    @X12Goodbye!@X31Its Time to say hello!@XCR"
'     PcbPrint b$
'     b$ = "Hello!@X02Goodbye!" + CHR$(13)
'     PcbPrint b$
'     COLOR 15, 0
'     PRINT PCBFilter$(b$)

FUNCTION PCBFilter$ (TextInput$)
b$ = TextInput$
DO
        NextIn = INSTR(b$, "@X")
        it = 1
                IF NextIn THEN
                        IF it = 1 AND NextIn <> 1 THEN
                            a$ = LEFT$(b$, NextIn - 1)
                            b$ = RIGHT$(b$, LEN(b$) - NextIn + 1)
                        END IF
                        Form$ = LEFT$(b$, 4)
                        b$ = RIGHT$(b$, LEN(b$) - 4)
                        
                        Another = INSTR(b$, "@X")
                        IF Another THEN
                                a$ = a$ + LEFT$(b$, Another - 1)
                                b$ = RIGHT$(b$, LEN(b$) - Another + 1)
                        END IF
                ELSE
                        a$ = a$ + b$
                        EXIT DO
                END IF
                it = 2
LOOP

PCBFilter$ = a$

END FUNCTION

SUB PcbPrint (StringInput$) STATIC
b$ = StringInput$
DO
        NextIn = INSTR(b$, "@X")
        it = 1
                IF NextIn THEN
                        IF it = 1 AND NextIn <> 1 THEN
                            PRINT LEFT$(b$, NextIn - 1);
                            b$ = RIGHT$(b$, LEN(b$) - NextIn + 1)
                        END IF
                        Form$ = LEFT$(b$, 4)
                        b$ = RIGHT$(b$, LEN(b$) - 4)
                        GOSUB FormatCheck:
                        Another = INSTR(b$, "@X")
                        IF Another THEN
                                PRINT LEFT$(b$, Another - 1);
                                b$ = RIGHT$(b$, LEN(b$) - Another + 1)
                        END IF
                ELSE
                        EXIT DO
                END IF
                it = 2
LOOP
    PRINT b$;
    EXIT SUB
FormatCheck:
        IF LEN(Form$) <> 4 THEN RETURN
        Code$ = RIGHT$(Form$, 2)
        IF Code$ = "CR" THEN
        'If RIGHT$(Form$, 2) = "CR" THEN
        PRINT
        ELSEIF Code$ = "00" THEN           'Save current colors
                CBSaved = CBColor         '(No Black on Black)
                CFSaved = CFColor
        ELSEIF Code$ = "FF" THEN           'Restore Saved Colors
                CBColor = CBSaved         ' (No blink on bright)
                CFColor = CFSaved
                COLOR CFColor, CBColor


        ELSE
        fg$ = MID$(Form$, 4, 1)      'Last one is FG     ----\
        bg$ = MID$(Form$, 3, 1)      'First one is BG    ---\|
        IF fg$ = "," THEN                                  '||
                CBColor = VAL("&h" + bg$)                  '||
                COLOR , CBColor                   '       @X12
        ELSEIF bg$ = "," THEN
                CFColor = VAL("&h" + fg$)
                COLOR CFColor
        ELSE
                CBColor = VAL("&h" + bg$)
                CFColor = VAL("&h" + fg$)
                COLOR CFColor, CBColor
        END IF
        END IF
        RETURN
        
    END SUB

