/*
 
                                                                           
  doit.c                                                                   
                                                                           
  Submit a "job" to the job server.  A job is a DOS command line.          
                                                                           
 
*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <mem.h>
#include <conio.h>
#include <io.h>
#include <string.h>
#include "..\doit.h"
#include <nwcalls.h>

#define NWDOS

NWCCODE			cCode;
char			response;
DWORD			queueID,
			serverID;
NWFILE_HANDLE		fileHandle;
char			inBuf[255];
size_t			buflen;
NWCONN_HANDLE		connID;
NWQueueJobStruct	jobStructure;

void main()
{
   cCode = NWCallsInit(NULL, NULL);
   if (cCode == 0)
		printf("Call to NWCallsInit successful\n");
   else {
		printf("Call to NWCallsInit failed\n");
		exit(-1);
   }

	/* Get the connection ID of the file server that has the job server's queue */
   cCode = NWGetDefaultConnectionID(&connID);
   if (cCode == 0)
		printf("Call to NWGetDefaultConnectionID successful\n");
   else {
		printf("Call to NWGetDefaultConnectionID failed\n");
		exit(-1);
   }

	/* get the bindery object ID of the job server */
   cCode = NWGetObjectID(connID, JOBSERV_NAME, OT_DOIT, &serverID);
   if (cCode == 0)
		printf("Call to NWGetObjectID successful\n");
   else
		printf("Call to NWGetObjectID failed, cCode = %X\n", cCode);

	/* get the bindery object ID of the queue */
   cCode = NWGetObjectID(connID, JOBSERV_NAME, OT_DOIT_Q, &queueID);
   if (cCode == 0)
		printf("Call to NWGetObjectID successful\n");
   else
		printf("Call to NWGetObjectID failed, cCode = %X\n", cCode);

	/* fill in the job entry structure */

	/* set the target server to that of the job server.*/
   jobStructure.targetServerID = serverID;

	/* set the target execution time to immediate */
   memset(jobStructure.targetExecutionTime, 0xFF, 6);

	/* set the target jobType according to job priority */
	printf("High priority job?\n");
	do {
		printf("Y/N >");
		response = toupper(getche());
		printf("\n");
	} while ((response != 'Y') && (response != 'N'));
	if (response == 'Y')
	   jobStructure.jobType = DOIT_JOB_PRIORITY_1;
	else
	   jobStructure.jobType = DOIT_JOB_PRIORITY_2;

	/* set the job for auto start */
   jobStructure.jobControlFlags = 0x08;

	/* ceate a queue file so you can get back a file handle to write to */
   cCode = NWCreateQueueFile2(connID, queueID, &jobStructure, &fileHandle);
   if (cCode == 0)
		printf("Call to NWCreateQueueFile2 successful\n");
   else
		printf("Call to NWCreateQueueFile2 failed, cCode = %X\n", cCode);

	/* get a command to send to the job server for execution */
	printf("Please input a DOS command:");
	gets(inBuf);
	buflen = strlen(inBuf);

	/* write the command to the job file */
	write(fileHandle,inBuf,buflen) ;

	/* close the file */
   cCode = NWCloseFileAndStartQueueJob2(connID, queueID, jobStructure.jobNumber, fileHandle);
   if (cCode == 0)
		printf("Call to NWCloseFileAndStartQueueJob2 successful\n");
   else
		printf("Call to NWCloseFileAndStartQueueJob2 failed, cCode = %X\n", cCode);
}
