/*
 
                                                                           
  uninstal.c                                                               
                                                                           
  Uninstall job server and job queue created by install.exe                
                                                                           
 
*/

#include <stdio.h>
#include <stdlib.h>
#include <nwcalls.h>
#include <nwerror.h>
#include "..\doit.h"

#define NWDOS

DWORD           queueID;
NWCCODE         cCode;
NWCONN_HANDLE   connID;

void main()
{
	cCode = NWCallsInit(NULL, NULL);
	if (cCode != 0) {
		printf("Unable to initialize NetWare interface\n");
		exit(-1);
	}

	/* get the connection ID of the server that we're uninstalling from */
	cCode = NWGetDefaultConnectionID(&connID);
	if (cCode != 0) {
		printf("Unable to get connection ID of default server\n");
		exit(-1);
	}

	/* delete the job server object */
	cCode = NWDeleteObject(connID, JOBSERV_NAME, OT_DOIT);
	if (cCode == 0)
		printf("Deleted job server object\n");
	else
		printf("Call to NWDeleteObject failed, cCode = %X\n", cCode);


	/* get the object ID of the queue */
	cCode = NWGetObjectID(connID, JOBSERV_NAME, OT_DOIT_Q, &queueID);
	if (cCode != 0) {
		printf("Call to NWGetObjectID failed, cCode = %X\n", cCode);
		exit(-1);
	}

	/* delete the queue */
	cCode = NWDeleteObject(connID, JOBSERV_NAME, OT_DOIT_Q);
	if (cCode == 0)
		printf("Deleted job server object\n");
	else
		printf("Call to NWDeleteObject failed, cCode = %X\n", cCode);

	printf("Job server uninstalled\n");
}
