/* bjfilt.c
 *
 *Canon BJ200 filter to remove extra "ab" from printouts
 * Author: W.G. Unruh <unruh@physics.ubc.ca> 
 * Based on printmon.c by  Kai Uwe Rommel <rommel@jonas>
 * Created:Jan 1994
 *
  */
 
static char *rcsid =
"$Id: bjfilt.c,v 1.0 1994/1/29   Exp $";
static char *rcsrev = "$Revision: 1.0 $";

 
#define   INCL_DOSFILEMGR
#define   INCL_DOSMONITORS
#define   INCL_DOSPROCESS
#include <os2.h>
#ifdef __EMX__
#include <mon16.h>
#endif

#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <fcntl.h>
#include <process.h>
#include <malloc.h>

#ifdef M_I86
#define popen _popen
#define pclose _pclose
#endif

#ifdef DEBUG
#define dprintf(f, p) printf(f, p)
#else
#define dprintf(f, p)    
#endif

#ifdef ERROR                               /* To print out error messages */
#define eprintf(f, p) printf(f, p)
#else
#define eprintf(f, p)    
#endif

#pragma pack(1)     /* To line stuff up on byte rather than dword boundaries */
 
struct buffer
{
  short length;
  char data[158];
};

struct packet
{
  unsigned char mflag;
  unsigned char dflag;
  short label;
  char wdata[138];
};
int packetprolog=4;

#pragma pack()

/* Prototype of Routine to find filter string in received data
  *  Cannot use the string fuctions as they interpret a Null as the end of the string
*/
 int findstr( char *string1,int n1,char *string2, int n2);

/* Filter string and length Note that this is the set of escape sequences that the
 * BJ200 interprets as ab which is tacked on to the end of most print jobs
*  Esc ( a 0x01 Null Null Esc ( b 0x01 Null Null Esc @
*/
char *filtstr= "\x1b(a\x01\x00\x00\x1b(b\x01\x00\x00\x1b@";
char *outstr="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1b@";
int filtlen=14;

void main(int argc, char **argv)
{
  USHORT usRC, cbData;
  ULONG cbWritten;
  HMONITOR mon;
  struct buffer ibuffer, obuffer;
  struct packet wbuffer;
  char port[16] ;
  int monitor=0;                                               /* print out all data bytes */
  int verbose=1;                                                /* Print out statistics? */
  int replace=1;                                                 /*replace filter string? */
  int numberReplaced=0;                                /* Number of times filter string replaced */
  int overlay;                                                   /* excess string length*/
  char woverlay[20];                                      /* excess string buffer */
  
  if (argc < 2)
  {
    printf("\nUsage:\tBJFILT <port>  [monitor] [quiet] [noreplace]\n\n"
                              "\t<port>  = port with BJ200 driver attached.\n" 
                              "\tmonitor   = if present dumps filtered troughput out stdout as well\n"
                                "\tquiet        = if present, do not give statistics of run\n"
                               "\tnoreplace = Do not replace the filter string.\n"
                                                       "\t\t\t Makes no sense without the  monitor flag \n"
                                                    " \t [flag] means that flag is optional\n\n");
    exit(1);
  }

    strcpy(port, argv[1]);
   {
      int i;
      for  (i=2;i<argc;i++)
      {
         if (!(strcmp("monitor",argv[i]))) { monitor=1; continue;}
         if (!(strcmp("quiet",argv[i]))) {verbose=0; continue;}
         if (!(strcmp("noreplace",argv[i]))){replace=0; continue;}
       }
    }

  if (verbose == 1)  printf("\nBJFILT: Canon BJ200 'ab' filter monitor\n");

  
  usRC = DosMonOpen(port, &mon);

  if (usRC != 0)
  {
     printf("DosMonOpen error code: %u\n", usRC);
     if (usRC=380) printf ("Invalid port %s\n",port);
     exit(usRC);
  }
 
  ibuffer.length = obuffer.length = sizeof(struct buffer);

 
  usRC = DosMonReg(mon, (PBYTE) &ibuffer, (PBYTE) &obuffer, MONITOR_END, 1);
   if (usRC)
  {
     eprintf("DosMonReg error code: %u\n", usRC);
     exit(usRC);
  }


 /* Main Loop */
  while (usRC == 0)
  {
    cbData = sizeof(struct packet);
    usRC = DosMonRead((PBYTE) &ibuffer, 0, (PBYTE) &wbuffer, &cbData);

    if (usRC)
    {
      eprintf("DosMonRead error code: %u\n", usRC);
      break;
    }


   if(verbose == 1)
   {
       if (wbuffer.mflag & 1)
      {
        dprintf("monitor: open\n", 0);
        cbWritten = 0;
       }

       if (wbuffer.mflag & 2)
      {
         dprintf("\nmonitor: close\n", 0);
         printf("bjfilt:Number bytes written=%ld  Number of filter strings replaced=%d\n", 
                                              cbWritten, numberReplaced);
      }

       if (wbuffer.mflag & 4)
      {
         dprintf("monitor: flush\n", 0);  
      }

      if (wbuffer.dflag == 32)
      {
          printf("bjfilt:Job Name= %s\n", wbuffer.wdata + sizeof(short));
       }
       if (wbuffer.dflag == 0)
       {
          cbWritten += cbData - packetprolog;
          dprintf("\rmonitor: %lu data bytes", cbWritten);
       }
  }   /* end if verbose */

    if((wbuffer.dflag&&63)==0 &&(wbuffer.mflag&7)==0)       /*data packet-- Upper parts 
                                                                                                         of bytes reserved */
     {
        int i;
        int loc=-1;
        if(overlay>0)      /* shift the input over*/
              {
#ifdef DEBUG
                printf("\n Before the move=");
                for (i=0;i<cbData;i++) putchar(wbuffer.wdata[i]);
#endif
                 for(i=0;i<cbData-packetprolog;i++)
                           {  wbuffer.wdata[cbData-packetprolog-1+overlay-i]
                                                      =wbuffer.wdata[cbData-packetprolog-1-i];
                            }
                    cbData+=overlay;
#ifdef DEBUG
                printf("\n After the move="); 
                for (i=0;i<cbData;i++) putchar(wbuffer.wdata[i]);putchar('\n');
#endif
                   for(i=0;i<overlay;i++)  wbuffer.wdata[i]=woverlay[i];     /* Inset the saved string*/
#ifdef DEBUG
                printf("\n After the replace=");
                for (i=0;i<cbData;i++) putchar(wbuffer.wdata[i]);putchar('\n');
#endif
                 }
        /*Search the data for the desired string */
        if (replace)
          {
             while ((loc =findstr(filtstr, filtlen,wbuffer.wdata,cbData-packetprolog))>=0 
                                          &&loc<=cbData-filtlen-packetprolog)
                { 
                   for(i=0;i<filtlen;i++) wbuffer.wdata[loc+i]=outstr[i] ;     /* replace the found string*/
                    numberReplaced++;
#ifdef DEBUG
                   printf( "\nString Found  loc=%d, cbData=%d\n", loc,cbData);
#endif 
                }
            }
         if(loc>=0&&loc<cbData-packetprolog)              /* Tail has partial match */
               { 
                 overlay= cbData-loc-packetprolog;          /* match length*/
                 cbData=loc+packetprolog;                        /* Data to be sent this time */
                 for (i=0;i<overlay;i++) woverlay[i]=wbuffer.wdata[i+loc];           /*save rest*/
#ifdef DEBUG
                 printf("\noverlay length=%d,cbData=,%d,loc=%d overlay=",overlay,cbData,loc);
                 for (i=0;i<overlay;i++) putchar(woverlay[i]); putchar('\n');
#endif
                }
        else overlay=0;
       if(monitor!=0)                               /* Print out output if monitoring */
               {
                  char* j ;
                  j= wbuffer.wdata;
                  dprintf("\nData length %d\n" , cbData-packetprolog);
                 for (i=packetprolog;i<cbData;i++)  putchar( *(j++));
               }
     }              /*end of  if data packet*/

      /*send back all packets received */
       if ( cbData >128+packetprolog)                         /*Is packet too long?*/
         { 
            int i, tail;                                                       /*send first 128 bytes*/
            tail = cbData-128-packetprolog;
            cbData=128+packetprolog;
#ifdef DEBUG
      {int ii;
      printf("\nActual Output, file id=%d\n",(int)wbuffer.label);
     for (ii=0;ii<cbData-packetprolog;ii++) putchar(wbuffer.wdata[ii]); putchar('\n');
      }
#endif 
            usRC=DosMonWrite((PBYTE)&obuffer,(PBYTE)&wbuffer, cbData);
            if(usRC!=0)
               { eprintf("DosMonWrite error return %d",usRC);
                 break;
               }
            for(i=0;i<tail;i++)
              {wbuffer.wdata[i]=wbuffer.wdata[128+i];}       /* move back rest of packet*/
            cbData=tail+packetprolog;
          }

                                                                                      /* Send remainder of packet*/ 
      usRC=DosMonWrite((PBYTE)&obuffer,(PBYTE)&wbuffer, cbData);   
#ifdef DEBUG
     {int ii;
     printf("\nActual Output, file id=%d\n", (int) wbuffer.label);
     for (ii=0;ii<cbData-packetprolog;ii++) putchar(wbuffer.wdata[ii]);  putchar('\n');
     }
#endif
      if(usRC!=0)
           { eprintf("DosMonWrite error return %d",usRC);
             break;
           }
  }
 
  dprintf("monitor: closing\n", 0);

  DosMonClose(mon);
 
  exit(usRC);
}

/* end of bjfilt.c */
