// A program to test the textwindow library.

// This program will display the current contents of the TextWindow screen
// using ANSI escape sequences

#include <stdio.h>
#include "textwin.h"

#define BLACK 0
#define RED 1
#define GREEN 2
#define YELLOW 3
#define BLUE 4
#define MAGENTA 5
#define CYAN 6
#define WHITE 7
#define COLOR(fg, bg) (((fg) & 7) | (((bg) & 7) << 4))
#define BRIGHT 8
#define BLINK 0x80

#define ANSI_RESET() printf ("\e[0m\e[37m\e[40m")

class Test: public TextWindow
{
public:
  Test ();
  void repaint ();
  void tester ();
  void raw_puts (const char *s);
  void tty_puts (const char *s);
  void std_puts (const char *s);
};


Test::Test ()
{
  set_attr (COLOR (WHITE, CYAN) | BRIGHT);
  set_screen_size (40, 10);
}

void Test::repaint ()
{
  int x, y;
  for (y = 0; y < get_screen_height (); y++)
    {
      for (x = 0; x < get_screen_width (); x++)
	{
	  char c = *get_text (x, y);
	  unsigned char a = *get_attr (x, y);
	  printf ("\e[0m"   // Normal characters
		  "\e[3%dm" // Foreground
		  "%s"  // Foreground Intensity
		  "\e[4%dm" // Background
		  "%s"      // Background blink
		  "%c",     // Character
		  a & 7,    // Foreground
		  (a & 8) ? "\e[1m" : "", // Foreground intensity
		  (a >> 4) & 7, // Background
		  (a & 0x80) ? "\e[5m" : "", // Blink
		  c);       // Character
	}
      ANSI_RESET ();
      printf ("\n");
    }
}

void tell_test (const char *test)
{
  int c;
  ANSI_RESET ();
  printf ("Next command: ``%s''\n", test);
  printf ("Press any key to execute...");
  fflush (stdout);
  do {
    c = getchar ();
  } while (c != 0 && c != '\n');
}

void Test::raw_puts (const char *s)
{
  put_raw (strlen (s), s);
}

void Test::tty_puts (const char *s)
{
  put_tty (strlen (s), s);
}

void Test::std_puts (const char *s)
{
  put_std (strlen (s), s);
}

void Test::tester ()
{
  const char *teststr =
    "\none\ntwo\nthree\nfour\nfive\nsix\nseven\neight\nnine\nten";
    
  repaint ();
#define TEST(t) do { tell_test (#t); t; repaint (); } while (0)
  TEST( raw_puts ("Hello, world!") );
  TEST( gotoxy(0,0); raw_puts ("Hello, world!") );
  TEST( gotoxy(0,0); tty_puts ("Foo\nFi\rFo\r\nFum") );
  TEST( std_puts ("Hello\nagain!\n") );
  TEST( raw_puts ("123456789012345678901234567890123456789") );
  TEST( raw_puts ("0") );
  TEST( raw_puts ("1") );
  TEST( gotoxy(0,9); std_puts ("Hello") );
  TEST( std_puts ("\nworld!") );
  TEST( std_puts ("\n123456789012345678901234567890123456789") );
  TEST( raw_puts ("0") );
  TEST( raw_puts ("1") );
  TEST( std_puts (teststr));
  TEST( scroll_window (1) );
  TEST( std_puts (teststr));
  TEST( scroll_window (2) );
  TEST( std_puts (teststr));
  TEST( scroll_window (9) );
  TEST( std_puts (teststr));
  TEST( scroll_window (10) );
  TEST( std_puts (teststr));
  TEST( scroll_window (11) );
  TEST( std_puts (teststr));
  TEST( scroll_window (0) );
  TEST( std_puts (teststr));
  TEST( scroll_window (-1) );
  TEST( std_puts (teststr));
  TEST( scroll_window (-2) );
  TEST( std_puts (teststr));
  TEST( scroll_window (-9) );
  TEST( std_puts (teststr));
  TEST( scroll_window (-10) );
  TEST( std_puts (teststr));
  TEST( scroll_window (-11) );
}

main ()
{
  char buf[2048];
  setvbuf (stdout, buf, _IOFBF, sizeof buf);
  Test test;
  test.tester ();
  ANSI_RESET ();
  fflush (stdout);
  return 0;
}
