#include "msgs.h"


typedef enum {
  msg_batch_on,
  msg_batch_off,
  msg_set_screen_size,
  msg_set_width,
  msg_set_height,
  msg_get_screen_width,
  msg_get_screen_height,
  msg_set_attr,
  msg_set_fg,
  msg_set_bg,
  msg_getx,
  msg_gety,
  msg_gotoxy,
  msg_put_raw,
  msg_put_tty,
  msg_put_std,
  msg_set_cells,
  msg_clrscr,
  msg_clreol,
  msg_scroll_window,
  msg_set_window,
  msg_unset_window,
  msg_hide_cursor,
  msg_set_cursor,
  msg_set_cursor_color,
  msg_get_cursor_color,
  msg_save_screen_content,
  msg_restore_screen_content,
} MessageKind;

typedef struct {
  MessageKind kind;
  union {
    struct { int width; int height; } data_set_screen_size;
    /* data_batch_on */
    /* data_batch_off */
    int data_set_width;
    int data_set_height;
    int data_get_screen_width;
    int data_get_screen_height;
    unsigned char data_set_attr;
    unsigned char data_set_fg;
    unsigned char data_set_bg;
    int data_getx;
    int data_gety;
    struct { int x; int y; } data_gotoxy;
    struct { int len; const char *text; } data_put_raw;
    struct { int len; const char *text; } data_put_tty;
    struct { int len; const char *text; } data_put_std;
    struct { int len; const char *text; } data_set_cells;
    /* data_clrscr; */
    /* data_clreol; */
    int data_scroll_window;
    struct { int x1; int y1; int x2; int y2; } data_set_window;
    /* data_unset_window; */
    /* data_hide_cursor; */
    struct { int start_line; int stop_line; } data_set_cursor;
    int data_set_cursor_color;
    int data_get_cursor_color;
    void *data_save_screen_content;
    void *data_restore_screen_content;
  } data;
} Message;


virtual MRESULT MessageWindow::msg_user1 (MPARAM mp1, MPARAM)
{
  Message *msg = (Message *) mp1;
  switch (msg->kind)
    {
    case msg_batch_on:
      batch_count++;
      break;
    case msg_batch_off:
      batch_count--;
      break;
    case msg_set_screen_size:
      inherited::set_screen_size (msg->data.data_set_screen_size.width,
				  msg->data.data_set_screen_size.height);
      break;
    case msg_set_width:
      inherited::set_width (msg->data.data_set_width);
      break;
    case msg_set_height:
      inherited::set_height (msg->data.data_set_height);
      break;
    case msg_get_screen_width:
      msg->data.data_get_screen_width = inherited::get_screen_width ();
      break;
    case msg_get_screen_height:
      msg->data.data_get_screen_height = inherited::get_screen_height ();
      break;
    case msg_set_attr:
      inherited::set_attr (msg->data.data_set_attr);
      break;
    case msg_set_fg:
      inherited::set_fg (msg->data.data_set_fg);
      break;
    case msg_set_bg:
      inherited::set_bg (msg->data.data_set_bg);
      break;
    case msg_getx:
      msg->data.data_getx = inherited::getx ();
      break;
    case msg_gety:
      msg->data.data_gety = inherited::gety ();
      break;
    case msg_gotoxy:
      inherited::gotoxy (msg->data.data_gotoxy.x,
			 msg->data.data_gotoxy.y);
      break;
    case msg_put_raw:
      inherited::put_raw (msg->data.data_put_raw.len,
			  msg->data.data_put_raw.text);
      break;
    case msg_put_tty:
      inherited::put_tty (msg->data.data_put_tty.len,
			  msg->data.data_put_tty.text);
      break;
    case msg_put_std:
      inherited::put_std (msg->data.data_put_std.len,
			  msg->data.data_put_std.text);
      break;
    case msg_set_cells:
      inherited::set_cells (msg->data.data_set_cells.len,
			    msg->data.data_set_cells.text);
      break;
    case msg_clrscr:
      inherited::clrscr ();
      break;
    case msg_clreol:
      inherited::clreol ();
      break;
    case msg_scroll_window:
      inherited::scroll_window (msg->data.data_scroll_window);
      break;
    case msg_set_window:
      inherited::set_window (msg->data.data_set_window.x1,
			     msg->data.data_set_window.y1,
			     msg->data.data_set_window.x2,
			     msg->data.data_set_window.y2);
      break;
    case msg_unset_window:
      inherited::unset_window ();
      break;
    case msg_hide_cursor:
      inherited::hide_cursor ();
      break;
    case msg_set_cursor:
      inherited::set_cursor (msg->data.data_set_cursor.start_line,
			     msg->data.data_set_cursor.stop_line);
      break;
    case msg_set_cursor_color:
      inherited::set_cursor_color (msg->data.data_set_cursor_color);
      break;
    case msg_get_cursor_color:
      msg->data.data_get_cursor_color = inherited::get_cursor_color ();
      break;
    case msg_save_screen_content:
      msg->data.data_save_screen_content = inherited::save_screen_content ();
      break;
    case msg_restore_screen_content:
      inherited::restore_screen_content(msg->data.data_restore_screen_content);
      break;
    }
  if (batch_count == 0)
    refresh_window ();
  return 0;
}

void MessageWindow::send_message (void *msg)
{
  send_user1 ((MPARAM) msg, 0);
}

MessageWindow::MessageWindow (const char *fontspec,
			      int init_width, int init_height)
: PMTextWindow (fontspec, init_width, init_height),
  batch_count (0)
{
}

MessageWindow::~MessageWindow ()
{
}

void MessageWindow::batch_on ()
{
  Message msg;
  msg.kind = msg_batch_on;
  send_message (&msg);
}

void MessageWindow::batch_off ()
{
  Message msg;
  msg.kind = msg_batch_off;
  send_message (&msg);
}

void MessageWindow::set_screen_size (int width, int height)
{
  Message msg;
  msg.kind = msg_set_screen_size;
  msg.data.data_set_screen_size.width = width;
  msg.data.data_set_screen_size.height = height;
  send_message (&msg);
}

void MessageWindow::set_width (int width)
{
  Message msg;
  msg.kind = msg_set_width;
  msg.data.data_set_width = width;
  send_message (&msg);
}

void MessageWindow::set_height (int height)
{
  Message msg;
  msg.kind = msg_set_height;
  msg.data.data_set_height = height;
  send_message (&msg);
}

int MessageWindow::get_screen_width ()
{
  Message msg;
  msg.kind = msg_get_screen_width;
  send_message (&msg);
  return msg.data.data_get_screen_width;
}

int MessageWindow::get_screen_height ()
{
  Message msg;
  msg.kind = msg_get_screen_height;
  send_message (&msg);
  return msg.data.data_get_screen_height;
}

void MessageWindow::set_attr (unsigned char attr)
{
  Message msg;
  msg.kind = msg_set_attr;
  msg.data.data_set_attr = attr;
  send_message (&msg);
}

void MessageWindow::set_fg (unsigned char fg_color)
{
  Message msg;
  msg.kind = msg_set_fg;
  msg.data.data_set_fg = fg_color;
  send_message (&msg);
}

void MessageWindow::set_bg (unsigned char bg_color)
{
  Message msg;
  msg.kind = msg_set_bg;
  msg.data.data_set_bg = bg_color;
  send_message (&msg);
}

int MessageWindow::getx ()
{
  Message msg;
  msg.kind = msg_getx;
  send_message (&msg);
  return msg.data.data_getx;
}

int MessageWindow::gety ()
{
  Message msg;
  msg.kind = msg_gety;
  send_message (&msg);
  return msg.data.data_gety;
}

void MessageWindow::gotoxy (int x, int y)
{
  Message msg;
  msg.kind = msg_gotoxy;
  msg.data.data_gotoxy.x = x;
  msg.data.data_gotoxy.y = y;
  send_message (&msg);
}

void MessageWindow::put_raw (int len, const char *text)
{
  Message msg;
  msg.kind = msg_put_raw;
  msg.data.data_put_raw.len = len;
  msg.data.data_put_raw.text = text;
  send_message (&msg);
}

void MessageWindow::put_tty (int len, const char *text)
{
  Message msg;
  msg.kind = msg_put_tty;
  msg.data.data_put_tty.len = len;
  msg.data.data_put_tty.text = text;
  send_message (&msg);
}

void MessageWindow::put_std (int len, const char *text)
{
  Message msg;
  msg.kind = msg_put_std;
  msg.data.data_put_std.len = len;
  msg.data.data_put_std.text = text;
  send_message (&msg);
}

void MessageWindow::set_cells (int len, const char *text)
{
  Message msg;
  msg.kind = msg_set_cells;
  msg.data.data_set_cells.len = len;
  msg.data.data_set_cells.text = text;
  send_message (&msg);
}

void MessageWindow::clrscr ()
{
  Message msg;
  msg.kind = msg_clrscr;
  send_message (&msg);
}

void MessageWindow::clreol ()
{
  Message msg;
  msg.kind = msg_clreol;
  send_message (&msg);
}

void MessageWindow::scroll_window (int scroll_distance)
{
  Message msg;
  msg.kind = msg_scroll_window;
  msg.data.data_scroll_window = scroll_distance;
  send_message (&msg);
}

void MessageWindow::set_window (int x1, int y1, int x2, int y2)
{
  Message msg;
  msg.kind = msg_set_window;
  msg.data.data_set_window.x1 = x1;
  msg.data.data_set_window.y1 = y1;
  msg.data.data_set_window.x2 = x2;
  msg.data.data_set_window.y2 = y2;
  send_message (&msg);
}

void MessageWindow::unset_window ()
{
  Message msg;
  msg.kind = msg_unset_window;
  send_message (&msg);
}

void MessageWindow::hide_cursor ()
{
  Message msg;
  msg.kind = msg_hide_cursor;
  send_message (&msg);
}

void MessageWindow::set_cursor (int start_line, int stop_line)
{
  Message msg;
  msg.kind = msg_set_cursor;
  msg.data.data_set_cursor.start_line = start_line;
  msg.data.data_set_cursor.stop_line = stop_line;
  send_message (&msg);
}

void MessageWindow::set_cursor_color (int cursor_color)
{
  Message msg;
  msg.kind = msg_set_cursor_color;
  msg.data.data_set_cursor_color = cursor_color;
  send_message (&msg);
}

int MessageWindow::get_cursor_color ()
{
  Message msg;
  msg.kind = msg_get_cursor_color;
  send_message (&msg);
  return msg.data.data_get_cursor_color;
}

void *MessageWindow::save_screen_content ()
{
  Message msg;
  msg.kind = msg_save_screen_content;
  send_message (&msg);
  return msg.data.data_save_screen_content;
}

void MessageWindow::restore_screen_content (void *p)
{
  Message msg;
  msg.kind = msg_restore_screen_content;
  msg.data.data_restore_screen_content = p;
  send_message (&msg);
}
