/*
 * This program demonstrates the use of pmio facilities as a debugging
 * aid for Presentation Manager programs.
 */


#include <stdio.h>
#include <stdwin.h>
#include <pmio.h>

class Test: public StdWin
{
  typedef StdWin inherited;
private:
  virtual MRESULT msg_create ();
  virtual MRESULT msg_paint ();
  virtual MRESULT msg_size (short old_width, short old_height,
			    short new_width, short new_heigth);
public:
  Test ();
};

Test::Test ()
{
}

MRESULT Test::msg_create ()
{
  printf ("msg_create received\n");
  MRESULT ret = inherited::msg_create ();
  printf ("msg_create is returning %u\n", (unsigned int) ret);
  return ret;
}

MRESULT Test::msg_paint ()
{
  // Just do a blank client window
  RECTL rectl;
  HPS hps = WinBeginPaint (window, 0, &rectl);
  printf ("Repainting (%ld,%ld) through (%ld,%ld)\n",
	  rectl.xLeft, rectl.yBottom,
	  rectl.xRight, rectl.yTop);
  GpiErase (hps);
  WinEndPaint (hps);
  return 0;
}

MRESULT Test::msg_size (short old_width, short old_height,
			short new_width, short new_height)
{
  printf ("Window size changed from %dx%d to %dx%d\n",
	  old_width, old_height,
	  new_width, new_height);
  return inherited::msg_size (old_width, old_height, new_width, new_height);
}

int main ()
{
  start_pmio ();
  set_fg (WHITE);
  set_bg (CYAN);
  clrscr ();
  Test test;
  test.activate_window ();
  StdWin::StdMessageLoop ();
  return 0;
}
