#define INCL_PM
#include <os2.h>
#include <string.h>
#include <stdlib.h>
#include "stddia.h"
#include "bugme.h"

MRESULT DialogBase::message (int msg, MPARAM mp1, MPARAM mp2)
{
//  ENTRY (DialogBase::message);
  DialogShim *list;
  int accept = 0;
  MRESULT code;
  for (list = parts; list != 0; list = list->next)
    {
      code = list->message (&accept, msg, mp1, mp2);
      if (accept)
	return code;
    }
  return WinDefDlgProc (window, msg, mp1, mp2);
}

void DialogBase::Register (DialogShim *shim)
{
  ENTRY (DialogBase::Register);
  shim->next = parts;
  parts = shim;
}

void DialogBase::dialog_init ()
{
}

void DialogBase::cmd_ok ()
{
}

void DialogBase::cmd_cancel()
{
}

MRESULT DialogBase::sendmsg_to (int id, int msg, MPARAM mp1, MPARAM mp2)
{
  return WinSendDlgItemMsg (window, id, msg, mp1, mp2);
}

DialogBase::DialogBase ()
: parts (0)
{
  ENTRY (DialogBase::DialogBase);
}

#pragma pack(1)
typedef struct
{
  unsigned short size;
  DialogBase *this_ptr;
} message_data;
#pragma pack()

MRESULT DialogBase::message_handler (HWND window, unsigned long msg,
				     MPARAM mp1, MPARAM mp2)
{
  message_data *msg_data;
switch (msg)
  {
  case WM_INITDLG:
    BUGME (("message is WM_INITDLG"));
    msg_data = (message_data *) PVOIDFROMMP (mp2);
    WinSetWindowPtr (window, 0, msg_data);
    msg_data->this_ptr->window = window;
    msg_data->this_ptr->dialog_init ();
    break;

  default:
      msg_data = (message_data *) WinQueryWindowPtr (window, 0);
  }
  if (msg_data == 0)
    {
      BUGME (("WARNING: Msg data not availible, using Default Procedure"));
      return WinDefDlgProc (window, msg, mp1, mp2);
    }
//  BUGME (("Passing message to object %p", msg_data->this_ptr));
  return msg_data->this_ptr->message (msg, mp1, mp2);
}


void DialogBase::dialog (HWND owner, int resource_id)
{
  ENTRY (DialogBase::dialog);
  message_data msg_data;
  msg_data.size = sizeof (msg_data);
  msg_data.this_ptr = this;
  BUGME (("creating dialog using msg_data:%p"));
  WinDlgBox (HWND_DESKTOP, owner, message_handler, 0, resource_id, &msg_data);
}



DialogShim::DialogShim (int aid)
: next (0), id (aid)
{
  ENTRY (DialogShim::DialogShim);
  Register (this);
}

MRESULT DialogShim::sendmsg (int msg, MPARAM mp1, MPARAM mp2)
{
  return sendmsg_to (id, msg, mp1, mp2);
}

EntryField::EntryField (int aid)
: DialogShim (aid)
{
  ENTRY (EntryField::EntryField);
}

void EntryField::change () { ENTRY (EntryField::change); }

MRESULT EntryField::message (int *accept, int msg, MPARAM mp1, MPARAM)
{
  ENTRY (EntryField::message);
  switch (msg)
    {
    case WM_CONTROL:
      if (SHORT1FROMMP (mp1) == id)
	{
	  switch (SHORT2FROMMP (mp1))
	    {
	    case EN_CHANGE:
	      change ();
	      *accept = 1;
	      break;
	    }
	}
      break;
    }
  return 0;
}


ComboBox::ComboBox (int aid)
: DialogShim (aid)
{
  ENTRY (ComboBox::ComboBox);
}

char *ComboBox::get_entryfield_text ()
{
  ENTRY (ComboBox::get_entryfield_text);
  WNDPARAMS wp;

  bzero (&wp, sizeof (wp));
  wp.fsStatus = WPM_CCHTEXT;
  if (! LONGFROMMR (sendmsg (WM_QUERYWINDOWPARAMS, &wp)))
    return 0;
  unsigned textlen = wp.cchText;
  BUGME(("get_entryfield_text: text length is %d", textlen));
  textlen++;  // For trailing '\0'

  bzero (&wp, sizeof (wp));
  wp.fsStatus = WPM_TEXT;
  wp.cchText = textlen;
  wp.pszText = (PSZ) alloca (textlen);
  bzero (wp.pszText, textlen);
  if (! LONGFROMMR (sendmsg (WM_QUERYWINDOWPARAMS, &wp)))
    return 0;
  BUGME(("get_entryfield_text: text is `%s'", wp.pszText));
  if (wp.pszText == 0)
    return 0;
  return strdup ((char *)(wp.pszText));
}

int ComboBox::set_entryfield_text (const char *newtext)
{
  ENTRY (ComboBox::set_entryfield_text);
  BUGME(("Attempting to set entryfield text to '%s'", newtext));
  WNDPARAMS wp;

  bzero (&wp, sizeof (wp));
  wp.fsStatus = WPM_TEXT;
  wp.cchText = strlen (newtext) + 1;
  wp.pszText = (PSZ) newtext;
  return LONGFROMMR (sendmsg (WM_SETWINDOWPARAMS, &wp));
}

void ComboBox::efchange () { ENTRY (ComboBox::efchange); }
void ComboBox::lbselect () { ENTRY (ComboBox::lbselect); }
void ComboBox::enter () { ENTRY (ComboBox::enter); }

int ComboBox::deleteall ()
{
  return LONGFROMMR (sendmsg (LM_DELETEALL));
}

short ComboBox::deleteitem (short index)
{
  return SHORT1FROMMR (sendmsg (LM_DELETEITEM, MPFROMSHORT(index)));
}

short ComboBox::insertitem (const char *item, short position)
{
  return SHORT1FROMMR (sendmsg (LM_INSERTITEM, 
			       MPFROMSHORT (position), 
			       MPFROMP (item)));
}

short ComboBox::insertitem_atend (const char *item)
{
  return insertitem (item, LIT_END);
}
short ComboBox::insertitem_sortascending (const char *item)
{
  return insertitem (item, LIT_SORTASCENDING);
}
short ComboBox::insertitem_sortdescending (const char *item)
{
  return insertitem (item, LIT_SORTDESCENDING);
}

short ComboBox::queryitemcount()
{
  return SHORT1FROMMR (sendmsg (LM_QUERYITEMCOUNT));
}

unsigned ComboBox::queryitemhandle(short index)
{
  return SHORT1FROMMR (sendmsg (LM_QUERYITEMHANDLE, MPFROMSHORT (index)));
}

short ComboBox::queryitemtext(short index, short bufsize, char *buf)
{
  return SHORT1FROMMR (sendmsg (LM_QUERYITEMTEXT, 
				MPFROM2SHORT (index, bufsize),
				MPFROMP (buf)));
}

short ComboBox::queryitemtextlength (short index)
{
  return SHORT1FROMMR (sendmsg (LM_QUERYITEMTEXTLENGTH, MPFROMSHORT (index)));
}

short ComboBox::queryselection (short start_item)
{
  return SHORT1FROMMR (sendmsg (LM_QUERYSELECTION, MPFROMSHORT (start_item)));
}

short ComboBox::querytopindex()
{
  return SHORT1FROMMR (sendmsg (LM_QUERYTOPINDEX));
}

short ComboBox::searchstring (unsigned short flags, short index, 
			      const char *search)
{
  return SHORT1FROMMR (sendmsg (LM_SEARCHSTRING, MPFROM2SHORT (flags, index),
				MPFROMP(search)));
}

int ComboBox::selectitem (int position, short select)
{
  return LONGFROMMR (sendmsg (LM_SELECTITEM, MPFROMSHORT (position), 
			      MPFROMSHORT (select)));
}

int ComboBox::setitemhandle(short index, unsigned handle)
{
  return LONGFROMMR (sendmsg (LM_SETITEMHANDLE, MPFROMSHORT (index),
			      MPFROMLONG (handle)));
}

int ComboBox::setitemheight(unsigned height)
{
  return LONGFROMMR (sendmsg (LM_SELECTITEM, MPFROMLONG (height)));
}

int ComboBox::setitemtext(short index, const char *txt)
{
  return LONGFROMMR (sendmsg (LM_SETITEMTEXT, MPFROMSHORT (index),
			      MPFROMP (txt)));
}

int ComboBox::settopindex(short index)
{
  return LONGFROMMR (sendmsg (LM_SETTOPINDEX, MPFROMSHORT(index)));
}

MRESULT ComboBox::message (int *accept, int msg, MPARAM mp1, MPARAM)
{
//  ENTRY (ComboBox::message);
  switch (msg)
    {
    case WM_CONTROL:
      BUGME (("ComboBox id #%d: WM_CONTROL is sent to #%d", id, 
	     SHORT1FROMMP (mp1)));
      if (SHORT1FROMMP (mp1) == id)
	{
	  *accept = 1;
	  switch (SHORT2FROMMP (mp1))
	    {
	    case CBN_EFCHANGE:
	      efchange ();
	      break;
	    case CBN_LBSELECT:
	      lbselect ();
	      break;
	    case CBN_ENTER:
	      enter ();
	      break;
	    default:
	      *accept = 0;
	    }
	}
      break;
    }
  return 0;
}


Button::Button (int aid)
: DialogShim (aid)
{
  ENTRY (Button::Button);
}

void Button::clicked () { ENTRY (Button::clicked); }
void Button::dblclicked () { ENTRY (Button::dblclicked); }

MRESULT Button::message (int *accept, int msg, MPARAM mp1, MPARAM)
{
//  ENTRY (Button::message);
  switch (msg)
    {
    case WM_CONTROL:
      if (SHORT1FROMMP (mp1) == id)
	{
	  *accept = 1;
	  switch (SHORT2FROMMP (mp1))
	    {
	    case BN_CLICKED:
	      clicked ();
	      break;
	    case BN_DBLCLICKED:
	      dblclicked ();
	      break;
	    default:
	      *accept = 0;
	    }
	}
      break;
    }
  return 0;
}

OK_Button::OK_Button ()
: Button (DID_OK)
{
  ENTRY (OK_Button::OK_Button);
}

void OK_Button::ok () { ENTRY (on::ok); }

void OK_Button::clicked ()
{
  ENTRY (OK_Button::clicked);
  ok ();
}


Cancel_Button::Cancel_Button ()
: Button (DID_CANCEL)
{
  ENTRY (Cancel_Button::Cancel_Button);
}

void Cancel_Button::cancel () { ENTRY (Cancel_Button::cancel); }

void Cancel_Button::clicked ()
{
  ENTRY (Cancel_Button::clicked);
  cancel ();
}

CommandMessage::CommandMessage (int id)
: DialogShim (id)
{
}

MRESULT CommandMessage::message (int *, int msg, MPARAM mp1, MPARAM)
{
  switch (msg)
    {
    case WM_COMMAND:
      if (SHORT1FROMMP(mp1) == id)
	message();
    }
  return 0;
}

void CommandMessage::message (void) 
{
}

OKMessage::OKMessage()
     : CommandMessage (DID_OK)
{
}

void OKMessage::message ()
{
  ok_message ();
}

void OKMessage::ok_message () { }

int OKMessage::send_ok_message ()
{
  return (int) WinSendMsg (window, WM_COMMAND,
			   MPFROMSHORT(DID_OK),
			   MPFROM2SHORT(CMDSRC_OTHER, FALSE));
}
