
/*
     Program PM-Info: a program for viewing GNU-style hypertext info
     documentation files.
     Copyright (C) 1992,1993,1994  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/

#ifndef include_font_h
#define include_font_h

/* 
 * Class for allocating/keeping track of which lcids are in use
 * at any given moment
 */

class LCID_Tracker
{
 protected:
  char lcid_in_use[256];
 public:
  int get ();
  void free (int lcid);
  LCID_Tracker ();
};


/*
 * Class for keeping track of what fonts we want availible to use,
 * and restoring the lcids of our fonts for use in an HPS on demand
 */

class FontList: public LCID_Tracker
{
  typedef LCID_Tracker ancestor;
  FATTRS *metrics;
  FONTMETRICS *fmetrics;
  int *pointsizes;
  int get (const FONTMETRICS *fm, int pointsize);
 public:

  /* Set up an HPS so that it contains all our expected fonts */
  void restore (HPS hps);

  /* Creating fonts within the fontlist that will be restorable */
  /* returns LCID_DEFAULT if the font is not successfully built */
  int make_font (const char *fontname, int pointsize);
  int make_italic_font (const char *fontname, int pointsize);
  int make_bold_font (const char *fontname, int pointsize);

  /* Font selection */
  void select_font (HPS hps, int lcid);

  FontList ();
  ~FontList ();
};

#endif /* include_font_h */
