
/*
     Program PM-Info: a program for viewing GNU-style hypertext info
     documentation files.
     Copyright (C) 1992,1993,1994  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/

#ifndef NDEBUG
#define DEBUG
#endif

#ifdef DEBUG
#include <stdio.h>
extern void Xshow_last_error();
extern FILE *fnote;  // Yes, this is bogus
extern void tell(const char *fmt, ...);
extern void debug_open_file();
extern void debug_open_cycle_file();
#endif

#ifdef DEBUG
#define show_last_error() Xshow_last_error()
#else
#define show_last_error() ({;})
#endif

#ifdef DEBUG
#define debug(format, args...) \
tell("%s:%d: %s: " format, __FILE__, __LINE__, __PRETTY_FUNCTION__ , ## args)
#define BUGME(exp) tell exp
#else
#define debug(format, args...) 0
#define BUGME(exp) ({;})
#endif

#define NOTE(id) BUGME((#id " is %d\n", id))

#if defined(DEBUG) && defined(SHOW_RETURNS)
#define SHOWME BUGME(("%s:%d: return", __FILE__, __LINE__))
#define return if (SHOWME,1) return
#endif

#if defined(DEBUG) && defined(SHOW_CHECKPOINTS)
#define CHECKPOINT BUGME(("%s:%d: checkpoint", __FILE__, __LINE__))
#else
#define CHECKPOINT ({;})
#endif

#define ENTRY(function) BUGME(("%s:%d: %s: entry, this=%p", __FILE__, \
			       __LINE__, #function, this))
#define C_ENTRY(function) BUGME(("%s:%d: %s: entry", __FILE__, __LINE__ \
				 , #function))
