/* extr2dir.cmd*/
echo off
parse upper arg qual drive path file ext
fqual = STRIP(qual)
ldriv = STRIP(drive)
lpath = STRIP(path)
lfile = STRIP(file)
lext  = STRIP(ext)
     
/*

	This code has been pirated from Virexx.cmd by Ronald Van Iwaarden
	1:104/338@fidonet 12 May, 1994
*/
/* ---------------------------------------------------------------------------*/
/*   - - - - - - - - - -   C O N F I G U R A T I O N - - - - - - - - - - -    */
/* -----  Set these variables for your System ------------------------------- */

/* 1) LISTS  (lists of file extensions and how to deal with them)                                                                */
/* ***** THESE MUST BE UPPER CASE OR THEY WONT WORK !!!!!    ****** */

arc_list='.ZIP .LZH .ARC .ARJ .ZOO'     /* list of defined achives */

/* 2) VARIABLES */

/* 3) PATHS (paths to various files and directories needed by VIREXX */
/* ****NOTE**** Change only UPPER CASE PARTS*/
tempdir  = 'e:\tmp\readme'      /* dir for testing lnode = 1,2 ect.*/


/* 4) COMMANDS (Command lines for various programs called by VIREXX)*/
/*    NOTE: Virexx appends the filename to the end of the archiver commands*/
/*    so the space at the end is important*/

lh_command='lh x /o /i '                /* command to extract .lzh file*/
                                        /* this ones for 32bit LH2 2.12*/
zip_command1 ='unzip -oj '              /* command to extract .ZIP files*/
                                        /* with version 1.x signature*/
                                        /* this ones for PKUNZIP2 1.02*/
zip_command2 ='unzip -oj '              /* command to extract .ZIP files*/
                                        /* with version 2.x signature*/
                                        /* this ones for InfoZip unzip 5.0*/
arj_command ='unarj e '                 /* unarj command for Robert Jungs*/
                                        /* Demo version 2.10 Unarj*/
/* arj_command ='gnunarj x '*/          /* unarj command for 32bit GNU port*/
                                        /* of R. Jungs Demo Unarj 2.30*/
arc_command ='arc2 xo '                 /* command to extract archive using*/
                                        /* SEA's ARC2 ver 6.00*/
zoo_command ='zoo e:O '                 /* command to extract archive using*/
                                        /* ZOO 2.1 (renamed to ZOO2.exe)*/
comment_command = 'zip -z -k '          /* command to add comment to .zip file*/

zipdir = ''                             /* path to arcive subdirectory */

/* 5) SWITCHES (switches for various functions. Use 1 for ON, 0 for OFF)*/

zipcomment = 1                          /* Add bbs comment to .zip files*/
dbase      = 1                          /* write entry to file database*/
/* -------------------------------------------------------------------------- */
/*    - - - - -  E N D    O F    C O N F I G U R A T I O N  - - - - - - -     */
/* ---------------------------- Main Program -------------------------------- */
/*trace all*/
call initialize                        /* initialize program */
fullname = fqual                       /* full pathname to file(s) */


/* Look for all files with the specified name*/


call SysFileTree fullname,'lfile','FSO'
/* If any exist then process them*/

say 'To where would you like to extract the file? '

pull destdir


if lfile.0 > 0 then do



/* Perform check for all of the files*/
/* This version is made for generic scans of subdirectories*/
do filecnt = 1 to lfile.0

/* Get the first/next file to process*/
fullname = TRANSLATE(lfile.filecnt)     /* full pathname to file */

filename = lfile||lext


lpath = ldrive||lpath


select
  when POS(lext,arc_list)>0 then
    call unarchive

end /* select */

'pause'

cleandest


end /* Loop for all files*/
end /* Files exist*/
cleanup:
  call RxFuncDrop 'SysFileTree'
exit

/* ------------ end -  main program ------------------ */


cleandest:

 dontask = '/N'

 if stream(destdir||'\*.*','c','query exist')  <> '' then
   'ERASE 'destdir'\*.* 'dontask   /* cleanup dest dir */

 return




/* ----- Subroutine Initialize ----------------------- */
initialize:
 if lext = '' then
   call USAGE
 dontask = '/N'
 call RxFuncAdd 'SysFileTree','RexxUtil','SysFileTree'
 call RxFuncAdd 'SysMkDir','RexxUtil','SysMkDir'
 call RxFuncAdd 'SysRmDir','RexxUtil','SysRmDir'
                                   /* make sure Rexxutils loaded */
 call SysFileTree tempdir,'dir','DO'
 if dir.0 = 0 then
   call SysMkDir tempdir

 if stream(tempdir||'\*.*','c','query exist')  <> '' then
   'ERASE 'tempdir'\*.* 'dontask   /* cleanup test dir */
 tempdir.0 = 0 /* No arcs within arcs yet*/

 archsize = 0
 nested = NO                                 /* clear nested */
 ZIPTYPE =''
 

return

/* ----- End - Initialize ---------------------------- */

/* ----- Subroutine Unarchive ------------------------ */

unarchive:
 ffname = fullname
 fname = filename
 testdir = tempdir
 signature = CHARIN(ffname,1,6)
 temp = stream(ffname,'c','close')
 Select

 PARSE VALUE destdir WITH drive ':' relpath
 driveext = drive||':'
 drivext
 'CD 'destdir
 

   when (substr(signature,1,5) = 'PK') then do  /* version 2.x zip file    */
     call unzip2
   end /* do */

   when (substr(signature,1,4) = 'PK') then do  /* version 1.x zip file    */
     call unzip1
   end /* do */

   when (substr(signature,3,3) = '-lh'  ) then do      /* .lzh file          */
     call unlzh
   end /* do */

   when (substr(signature,1,2) = '`'   ) then do      /* .arj file          */
     call unarj
   end /* do */

   when (substr(signature,1,3) = 'ZOO'  ) then do      /* .zoo file          */
     call unzoo
   end /* do */

   when lext = '.ARC' then do                            /* .arc file           */
     call unarc
   end /* do */

   otherwise do
     status = 'BAD'
   end /* do */

end /* select */


return

/* ----------- End - unarchive -----------------------------*/


/* ------ Unzip - run unzip on filename ------- */
unzip1:
  'CD 'testdir
  zipdir||zip_command1' 'ffname' readme read.me readme.txt'/* unzip file */
return

/* end unzip1 */
/* ------ Unzip2 - run unzip on version 2.x filename ------- */
unzip2:
 'CD 'testdir
 zipdir||zip_command2' 'ffname' readme read.me readme.txt'/* unzip file */
return  

/* end unzip2 */


/* ------ Unzoo - run zoo on filename ------- */
unzoo:
  'CD 'testdir
  zipdir||zoo_command' 'ffname' readme read.me readme.txt'
return

/* end unzoo */


/* ---------  unarj -- run unarj on filename --------------- */
unarj:
     /* written for Robert Jung's Unarj 2.10                                */
     /* this section will copy the file to the test file dir and also copy  */
     /* unarj to the same directory, run unarj and cleanup afterwards. If   */
     /* your test dir is on a different drive be sure to fix this section   */

  'CD 'testdir
/*     unarj e fname                                     /* unarj file        */
*/
  zipdir||arj_command' 'ffname' readme read.me readme.txt'
 
return

/* end unarj */

/* ----------- unlzh -- unlzh filename ----------- */
         
unlzh:
  /* written for LH32  2.21    */
  'COPY 'ffname testdir                          /* copy file to test dir  */
  'CD 'testdir
  zipdir||lh_command' 'ffname' readme read.me readme.txt' /* unlzh file */
return

/* end unlzh */

/* ----- unarc -- unarc filename using ARC2 ---- */

unarc:
  /* written for ARC2 6.00p                                              */
  /* this section will copy the file to the test file dir and also copy  */
  /* arc2 to the same directory, run arc2 and cleanup afterwards. If     */
  /* your test dir is on a different drive be sure to fix this section   */

  'COPY 'ffname testdir                          /* copy file to test dir  */
  'CD 'testdir
  zipdir||arc_command' 'ffname' readme read.me readme.txt'  /* unarc file   */
return

/* end unarc  */




USAGE:
say ' '
say ' getreadm.cmd a .cmd file to extract and view a readme file'
say ' '
say ' USAGE: getreadm d:\path\filename.exe d: path\ filename .ext'
say ' '
say ' path\   = path to file to be checked INCLUDING trailing \'
say ' '
say ' filename   = the name of the file with no path or extension'
say ' '
say ' .ext       = the file extension including the . '
say ' '
say ' '
signal CLEANUP
return
