/*****************************************************************************
 * $Id: port.h,v 2.9 1994/11/08 20:12:10 ak Exp $
 *****************************************************************************
 * $Log: port.h,v $
 * Revision 2.9  1994/11/08  20:12:10  ak
 * Optional case-sensitive compare.
 * Moved include of port.h to tar.h.
 *
 * Revision 2.8  1994/10/17  17:52:32  edvkai
 * Bugfix --buffered.
 * Chdir support now works.
 *
 * Revision 2.7  1994/07/11 16:02:13  edvkai
 * Dump ACL to single file, if filename specified with --dump-acl.
 * Show ACL fetch errors.
 *
 * Revision 2.6  1994/07/05 14:56:34  edvkai
 * Access Control Lists.
 *
 * Added --substitute, allows redirection of UNC names. No support for links yet.
 *
 * Streamlined absolute path treatment. No skipcrud any more.
 *
 * Bugfix: If a directory existed, EAs were not attached.
 *
 * Revision 2.5  1994/05/31 23:23:55  ak
 * Reversed meaning of --old-ea to stay compatible to gtak 2.12. The
 * 32-bit API should have a longer life anyway (PowerPC?) and is faster.
 *
 * Avoid _ead_read like the plague (sorry E.M.). Crashed in diffarch if
 * the EMX libs where being used but worked when I compiled the patched
 * ead* sources into TAR. Now using ea_load in diffarch too.
 *
 * Removed EA_MODE conditionals.
 *
 * Revision 2.4  1994/05/31 21:33:41  ak
 * Still there seems to be a memory leak somewhere in EMX _ead_read.
 * Didn't find it with dbmalloc though. Added EA_MODE (former EMX_EA) of
 * 2, using my own ea_* functions to load the attributes and the EMX
 * functions to manipulate them. The leak seems to be gone now. Added
 * --old-ea to allow creating the gtak 2.12 EA records.
 *
 * Revision 2.3  1994/02/17 16:02:25  ak
 * Use EMX _ead_* extended attribute functions. Create new EAs (ifdef EMX_EA),
 * accept both old and new when reading. As the new representation reflects
 * the OS/2 1.x binary EA representation, GTAK 1.x EAs are accepted now.
 *
 * Revision 2.2  1993/08/08 19:27:56  ak
 * *** empty log message ***
 *
 * Revision 2.1  1993/08/08  19:10:14  ak
 * Merge of network TAR with 2.12.
 *
 * Revision 1.1.1.2  1993/08/08  17:51:59  ak
 * - Network tape access.
 * - Dynamically loaded modules for disk/scsi/network interfaces.
 *
 * Revision 1.4  1992/09/29  09:55:58  ak
 * K.U.R., once again :-)
 * - removed a dup() in buffer.c
 * - EMX opendir with hidden/system test in gnu.c (...dotdot)
 *
 * Revision 1.3  1992/09/12  15:57:00  ak
 * - Usenet patches for GNU TAR 1.10
 * - Bugfixes and patches of Kai Uwe Rommel:
 *         filename conversion for FAT
 *         EMX 0.8e
 *         -0..1 alias for a: b:
 *         -2..7 alias for +++TAPE$x
 *
 * Revision 1.2  1992/09/02  20:08:34  ak
 * Version AK200
 * - Tape access
 * - Quick file access
 * - OS/2 extended attributes
 * - Some OS/2 fixes
 * - Some fixes of Kai Uwe Rommel
 *
 * Revision 1.1.1.1  1992/09/02  19:22:19  ak
 * Original GNU Tar 1.10 with some filenames changed for FAT compatibility.
 *
 * Revision 1.1  1992/09/02  19:22:17  ak
 * Initial revision
 *
 *****************************************************************************/

/*
 * Modified by Andreas Kaiser July 92.
 * See CHANGES.AK for info.
 */

/* Portability declarations.
   Copyright (C) 1988 Free Software Foundation

This file is part of GNU Tar.

GNU Tar is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU Tar is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Tar; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
/*
 * Portability declarations for tar.
 *
 * @(#)port.h 1.3	87/11/11	by John Gilmore, 1986
 */

/*
 * Everybody does wait() differently.  There seem to be no definitions
 * for this in V7 (e.g. you are supposed to shift and mask things out
 * using constant shifts and masks.)  So fuck 'em all -- my own non
 * standard but portable macros.  Don't change to a "union wait"
 * based approach -- the ordering of the elements of the struct 
 * depends on the byte-sex of the machine.  Foo!
 */
#define	TERM_SIGNAL(status)	((status) & 0x7F)
#define TERM_COREDUMP(status)	(((status) & 0x80) != 0)
#define TERM_VALUE(status)	((status) >> 8)

#ifdef	MSDOS

/* missing things from sys/stat.h */
#define	S_ISUID		0
#define	S_ISGID		0
#define	S_ISVTX		0

/* device stuff */
#define	makedev(ma, mi)		((ma << 8) | mi)
#define	major(dev)		(dev)
#define	minor(dev)		(dev)

#define strIcmp  stricmp
#define strnIcmp strnicmp

#else

#define strIcmp  strcmp
#define strnIcmp strncmp

#endif	/* MSDOS */

/*------------------------------------------------------------------------*/

#ifdef OS2

#define FILENAME_MAX 260

#include <os2eattr.h>
#include <acl32.h>
#include <sys/ead.h>
pEABuf		eabuf;		/* extended attribute buffer */
long		ealen;		/* length of .. */
_ead		ead;
ACL *		acl;
#ifdef NAMSIZ
  char	eaname[NAMSIZ];		/* file name of current EA */
  char	aclname[NAMSIZ];	/* file name of current ACL */
#endif

#undef  strIcmp
#undef  strnIcmp
extern int	(*strIcmp)(const char *, const char *);
extern int	(*strnIcmp)(const char *, const char *, unsigned long);

#define chdir	_chdir2

extern char *os2error(char *, int);

#include <errno.h>

#endif

#ifdef unix
# ifndef O_BINARY
#  define O_BINARY 0
# endif
#endif
