###############################################################################
# $Id: makefile.mk,v 2.22 1994/08/09 16:20:46 ak Exp $
###############################################################################
# STATIC=0/1	0: use ACL DLL, EMXLIBC.DLL, EMX.DLL, exe=tar.exe
#		1: K.U.R.s ACL code, static, exe=rtar.exe
###############################################################################
# $Log: makefile.mk,v $
# Revision 2.22  1994/08/09  16:20:46  ak
# Bugfix QFA mit Tape-Dir von 2.12.
#
# Revision 2.21  1994/08/09 14:24:00  ak
# Added Kai Uwe Rommels ACL implementation.
#
# Revision 2.20  1994/08/06 19:17:44  ak
# New dirs.
#
# Revision 2.19  1994/07/14 20:08:37  ak
# Small version w/o ACL support and statically linked LIBC.
#
# Revision 2.18  1994/07/11 16:02:11  edvkai
# Dump ACL to single file, if filename specified with --dump-acl.
# Show ACL fetch errors.
#
# Revision 2.17  1994/07/05 18:45:04  edvkai
# 2.35: Posix support for long filenames and magic name.
#
# Lots of changes in filename handling, I hope I found all places. Added
# decode_filename() with result in var 'filename' for this. header.name
# should no longer be used. The diffarch kludge FILENAME is no longer
# necessary.
#
# Treatment of links is not up-to-date, I fear - what's defined by Posix
# about long link names?
#
# Due to NONAMES, prior versions created "oldarch" style archives without
# magic name. Now magic is "ustar\0""00" for Posix and "ustar  \0" else.
#
# Unused header space is used to support multi-volume archives in Posix -
# THIS IS SPECIFIC TO GTAK.
#
# Note that Posix conflicts with atime/ctime.
#
# Revision 2.16  1994/07/05 14:56:29  edvkai
# Access Control Lists.
#
# Added --substitute, allows redirection of UNC names. No support for links yet.
#
# Streamlined absolute path treatment. No skipcrud any more.
#
# Bugfix: If a directory existed, EAs were not attached.
#
# Revision 2.15  1994/06/14 21:59:42  ak
# rtar -> tar
#
# Revision 2.14  1994/05/31 23:23:53  ak
# Reversed meaning of --old-ea to stay compatible to gtak 2.12. The
# 32-bit API should have a longer life anyway (PowerPC?) and is faster.
#
# Avoid _ead_read like the plague (sorry E.M.). Crashed in diffarch if
# the EMX libs where being used but worked when I compiled the patched
# ead* sources into TAR. Now using ea_load in diffarch too.
#
# Removed EA_MODE conditionals.
#
# Revision 2.13  1994/05/31 21:33:30  ak
# Still there seems to be a memory leak somewhere in EMX _ead_read.
# Didn't find it with dbmalloc though. Added EA_MODE (former EMX_EA) of
# 2, using my own ea_* functions to load the attributes and the EMX
# functions to manipulate them. The leak seems to be gone now. Added
# --old-ea to allow creating the gtak 2.12 EA records.
#
# Revision 2.12  1994/02/27 21:55:47  ak
# Had to copy own version of E.M.'s ead_* functions for a bugfixed
# version of _ead_enum. His version (0.8h pl4) has a memory leak and
# fails due to an OS/2 API bug (DosEnumAttribute).
#
# Revision 2.11  1994/02/17 16:02:28  ak
# Use EMX _ead_* extended attribute functions. Create new EAs (ifdef EMX_EA),
# accept both old and new when reading. As the new representation reflects
# the OS/2 1.x binary EA representation, GTAK 1.x EAs are accepted now.
#
# Revision 2.10  1994/02/17 12:21:02  ak
# Fixed. Dynamic lib.
#
# Revision 2.9  1994/02/17 12:10:50  ak
# Simplified makefile.mk. Use ccg instead of gcc. *.o doesn't work anyway.
#
# Revision 2.8  1993/12/07 22:40:58  ak
# *** empty log message ***
#
# Revision 2.7  1993/12/07  18:39:42  ak
# Back to own dirent, EMX dirent converts network drives to lowercase.
#
# Revision 2.6  1993/12/03  15:03:29  edvkai
# *** empty log message ***
#
# Revision 2.5  1993/09/17  15:25:46  edvkai
# *** empty log message ***
#
# Revision 2.4  1993/09/17  15:12:41  edvkai
# *** empty log message ***
#
# Revision 2.3  1993/09/17  15:11:06  edvkai
# - Better support for GZip, reorganized compression options.
# - Buffered mode now available without compression.
# - Merged GNU dumps and archive bit backups into a single set of options.
#
# Revision 2.2  1993/08/08  19:27:47  ak
# *** empty log message ***
#
# Revision 2.1  1993/08/08  19:09:18  ak
# Merge of network TAR with 2.12.
#
# Revision 1.7  1993/04/26  15:18:29  AK
# - Network tape access.
# - Dynamically loaded modules for disk/scsi/network interfaces.
#
# Revision 1.6  1992/09/16  21:00:00  ak
# EMX 0.8e
#
# Revision 1.5  1992/09/13  21:16:03  ak
# Wieder getdate vom Original, 1.10 ist da wesentlich neuer und
# vollstaendiger als 1.06.
#
# Revision 1.4  1992/09/12  16:07:14  ak
# Added entry for --fat to usage
#
# Revision 1.3  1992/09/12  15:57:52  ak
# - Usenet patches for GNU TAR 1.10
# - Bugfixes and patches of Kai Uwe Rommel:
#         filename conversion for FAT
#         EMX 0.8e
#         -0..1 alias for a: b:
#         -2..7 alias for +++TAPE$x
#
# Revision 1.2  1992/09/11  21:17:55  ak
# Added -Uunix
#
# Revision 1.1  1992/09/02  20:07:38  ak
# Initial revision
#
###############################################################################
#
# getdate.y has 8 shift/reduce conflicts.

tapedir = ../tape
bindir  = $(ROOTDIR)/usr/binp
CC      = ccg

OPTIM	= -O2
# DEBUG = -DDEBUG

#
# DYNAMIC:	dynamic interface DLLs
# TAPE_IO:	own tape interface
# OWN_DIRENT:	own dirent avoids EMXs upper/lowercase bug
#
CFLAGS = -DMSDOS -DOS2=2 -DDYNAMIC -DTAPE_IO -DOWN_DIRENT -DDEFBLOCKING=20 $(INC)
LOCAL_SRC = getdate.y ak_dir.c ak_rmt.c ak_os2.c
LOCAL_OBJ = getdate.obj ak_dir.obj ak_rmt.obj ak_os2.obj

CFLAGS  += $(DEBUG) $(OPTIM) -MT $D -w3
LDFLAGS += $(DEBUG) $(OPTIM) -MT $D $(DYN)
LIBS    += -lxmt $(ACL)

.IF $(STATIC)
# CFLAGS += -Iacl
  LOCAL_SRC += acl32.c
  LOCAL_OBJ += acl32.obj
  LDFLAGS += -bs
  EXE = rtar
.ELSE
  LIBS += -lacl32
  LDFLAGS += -bd
  EXE = tar
.END

.IF $(OPTIM) == $(NULL)
  LIBS  += -ldbmalloc
  OBJDIR = objd
.ELSE
  OBJDIR = obj
.END

.SOURCE.h : . $(tapedir)
.SOURCE.c : . $(tapedir)
.SOURCE.obj : $(OBJDIR)

# Add things here like readdir that aren't in your standard libraries.
# (E.g. MSDOS needs msd_dir.c, msd_dir.obj)
.IF $(DEBUG) != $(NULL)
  SUBSRC=
  SUBOBJ=
.END

# Destination directory and installation program for make install
INSTALL = cp
RM = rm -ce

SRC1 =	tar.c create.c extract.c buffer.c getoldop.c update.c gnu.c mangle.c
SRC2 =  version.c list.c names.c diffarch.c port.c wildmat.c getopt.c getopt1.c
SRC3 =  $(LOCAL_SRC) $(SUBSRC)
SRCS =	$(SRC1) $(SRC2) $(SRC3)
OBJ1 =	tar.obj create.obj extract.obj buffer.obj getoldop.obj list.obj update.obj
OBJ2 =	version.obj names.obj diffarch.obj port.obj wildmat.obj getopt.obj getopt1.obj
OBJ3 =  gnu.obj mangle.obj $(LOCAL_OBJ) $(SUBOBJ)
OBJS =	$(OBJ1) $(OBJ2) $(OBJ3)
AUX =   README COPYING ChangeLog Makefile tar.texinfo tar.h port.h open3.h \
	rmt.h msd_dir.h msd_dir.c rtape_server.c rtape_lib.c getdate.y \
	getopt.h regex.h level-0 level-1 backup-specs testpad.c

all:	$(EXE).exe

$(EXE).exe: $(OBJS) tar.def
	$(CC) $(LDFLAGS) tar.def -o $@ $(COPTS) $< $(LIBS)

testpad.h: testpad.exe
	testpad > testpad.h

install: tar.exe
	$(RM) $(bindir)/tar.exe
	$(INSTALL) tar.exe $(bindir)/tar.exe

$(OBJS): tar.h port.h testpad.h
regex.obj tar.obj: regex.h
