/* Rexx */

/* Read from a pipe and send it out over APPC */
logfile = 'c:\rc4.log'
convtype = 'mfn'       /* mapped, full-duplex, non-blocking */

signal on syntax

Parse Arg partlu, partmode, hread, hwrite, tpid, convid

call rxsi2h hread
Do Forever
  line = linein()
  If line = '' Then
    line = ' '
  appcrc = rxappc('Send_Data',convtype,tpid,convid,'n',Cryption(line),'inf.')
  If appcrc <> 0 Then
    Do
    Say 'Send_Data failed with rc =' appcrc
    Call rxAppc 'Tp_Ended', tpid,'s'
    Exit
    End
  appcrc = rxappc('Flush',convtype,tpid,convid,)
  If appcrc <> 0 Then
    Do
    Say 'Flush failed with rc =' appcrc
    Call Appc 'Tp_Ended', tpid,'s'
    Exit
    End
End

call rxdestroypipe hread, hwrite
Call rxappc 'Deallocate', convtype, tpid, convid, 's','inf.'
Call rxAppc 'Tp_Ended', tpid,'s'

Exit

Syntax:
call lineout logfile,'Syntax error in line' sigl':',sourceline(sigl)
call lineout logfile,'Failed with syntax error ('rc')' ErrorText(rc)
exit

Cryption:
Return BitXor(Arg(1),Copies('ff'x,Length(Arg(1))))
