;; faces-os2.el
;;
;; makes bold and italic fonts work with OS/2 font specifications..
;; you don't have to use the portable character representation
;;
;; try this with hilit19.el, or hl319.el, or some other
;; code for fontifying your emacs 19.
;;
;; Version 1.0 - 1/24/94 - original public release
;; 
;; written by John-Marc Chandonia (chandoni@husc.harvard.edu)
;; please send suggestions and bug fixes!  Especially code.
;; 
;; THIS FILE IS RELEASED INTO THE PUBLIC DOMAIN
;; USE AT YOUR OWN RISK!
;;
;; To install, load "faces-os2.el" somewhere after "faces.el"
;;
;; The easiest way to do this is to put
;; (require 'faces-os2)
;; somewhere in your .emacs file
;;
;; you can also put this line in your ~emacs/lisp/term/pm-win.el,
;; right after the (require 'faces) line
;;
;; I have tested this with EM's port of Emacs 19.22; it probably
;; works with every version >= 19.19.
;; 
;; BUGS:
;;
;; * probably doesn't work right with bold-italic fonts
;; * fonts don't always look good.  i.e. for italic fonts,
;;   should have a routine to choose the next smallest bitmapped
;;   italic font.
;; * simulated fonts are too slow, but look better.  Should make
;;   it a user option which to try first.
;;   an example of a simulated font is "10.italic.Courier"
;;   the os/2 font is "10.Courier Italic"


(defun pm-make-font-bold (font)
  "Given a PM font specification (i.e 10.Courier), make a
bold version of it.  If impossible, return nil.  Uses simulated
bold fonts instead of os2's bold fonts; I think they look nicer."
  (if (string-match "bold" font) 
      font ;; make sure we aren't already in the appropriate font
;;    (let ((os2font (concat font " bold")))
      ;; look for a font in the os/2 naming style
;;      (if (pm-list-fonts os2font) 
;;	  os2font
	;; else, try to simulate the font
	(if (string-match "\\." font)
	    (let ((simfont (concat (substring font 0 (match-beginning 0))
				   ".bold."
				   (substring font (match-end 0)))))
	      (if (pm-list-fonts simfont) simfont nil)))))
;; ))


(defun pm-make-font-italic (font)
  "Given a PM font specification (i.e 10.Courier), make an
italic version of it.  If impossible, return nil."
  (if (string-match "italic" font) 
      font ;; make sure we aren't already in the appropriate font
    (let ((os2font (concat font " Italic")))
      ;; look for a font in the os/2 naming style
      (if (pm-list-fonts os2font) 
	  os2font
	;; else, try to simulate the font
	(if (string-match "\\." font)
	    (let ((simfont (concat (substring font 0 (match-beginning 0))
				   ".italic."
				   (substring font (match-end 0)))))
	      (if (pm-list-fonts simfont) simfont nil)))))))

(defun pm-make-font-unbold (font)
  "Given a bold PM font spec (i.e. 10.Courier Bold or 10.bold.Courier,
make a nonbold version of it.  If impossible, return nil."
  (if (string-match " Bold" font)
      (let ((nfont (substring font 0 (match-beginning 0))))
	(if (pm-list-fonts nfont) nfont nil))
    (if (string-match "\\.bold\\." font)
	(let ((nfont (concat (substring font 0 (match-beginning 0))
			      "."
			      (substring font (match-end 0)))))
	  (if (pm-list-fonts nfont) nfont nil))
      font)))

(defun pm-make-font-unitalic (font)
  "Given a italic PM font spec (i.e. 10.Courier Italic or
10.italic.Courier, make a nonbold version of it.
If impossible, return nil."
  (if (string-match " Italic" font)
      (let ((nfont (substring font 0 (match-beginning 0))))
	(if (pm-list-fonts nfont) nfont nil))
    (if (string-match "\\.italic\\." font)
	(let ((nfont (concat (substring font 0 (match-beginning 0))
			     "."
			     (substring font (match-end 0)))))
	  (if (pm-list-fonts nfont) nfont nil)))
    font))

(defalias 'x-make-font-bold 'pm-make-font-bold)
(defalias 'x-make-font-unbold 'pm-make-font-unbold)
(defalias 'x-make-font-italic 'pm-make-font-italic)
(defalias 'x-make-font-italic 'pm-make-font-italic)

(provide 'faces-os2)