/* REXX
Ŀ
                            EditProject Version 0.60                          
                                                                              
                          Makefile maintenance utility                        
                                                                              
                               Bernhard Bablok                                
                                                                              
                                January, 1994                                 
                                                                              
   Distributed as part of the EPMGCC-package. See the file license.txt for    
   details on the legal stuff. See the file epro.doc for details on usage.    
                                                                              

*/

PARSE ARG Project.file
CALL startup

IF Project.file = '' THEN
  CALL SelectProject
ELSE DO
  Project.file = STRIP(Project.file)
  CALL SysFileTree Project.file, 'count', 'FO'
  IF count.0 = 0 THEN DO                       /* project file doesn't exist! */
    extension = SUBSTR(Project.file,LASTPOS('.',Project.file)+1)
    IF extension = Project.file THEN
       Project.file = Project.file'.emx'
    SelectProject.template = Project.file
    CALL SelectProject
    IF RESULT > 0 THEN DO
      Project.name = '.unnamed'
      SelectProject.template = '*.emx'
      main.vstring = 1
    END
  END
  ELSE DO
     CALL ReadProject
     IF RESULT > 0 THEN DO
       Project.name = '.unnamed'
       SelectProject.template = '*.emx'
       main.vstring = 1
     END
  END
END
CALL MainMenu
CALL cleanup

/*----------------------------------------------------------------------------*/
/* startup: Initialize functions and variables                                */
/*----------------------------------------------------------------------------*/
startup:

EditProject.version  = 0.60
EditProject.compiler = 'gcc'
EditProject.make     = 'make'

main.0       = 8
main.1       = 'Select project'
main.2       = 'Add files'
main.3       = 'Delete files'
main.4       = 'Build options'
main.5       = 'Compiler options'
main.6       = 'Link options'
main.7       = 'Save project'
main.8       = 'Make'

SelectProject.title    = 'Select project'
SelectProject.template = '*.emx'

AddFiles.title    = 'Add file'
AddFiles.template = '*.c'

sources.0      = 0
sources.title  = 'Added files'
sources.back   = 'BLUE'
sources.fore   = 'WHITE'
sources.type   = 'SYSTEM'                             /* font                 */
sources.size   = 10                                   /* pitch                */
sources.left   = 1                                    /* position of window   */
sources.bottom = 5
sources.right  = 20
sources.top    = 95
sources.diff   = 25                                   /* distance betw. lines */
sources.all    = ''                                   /* all sources          */

DeleteFiles.title  = 'Delete files'
DeleteFiles.width  = 20
DeleteFiles.height = 10

BuildOption.title  = 'Build-Mode'
BuildOption.0      = 2
BuildOption.1      = 'Debug'
BuildOption.2      = 'Production'

CompilerOptions.title    = 'Compiler options'
CompilerOptions.prompt.0 = 3
CompilerOptions.prompt.1 = 'Global options:'
CompilerOptions.prompt.2 = 'Debug options:'
CompilerOptions.prompt.3 = 'Production options:'

CompilerOptions.width.0  = 3
CompilerOptions.width.1  = 60
CompilerOptions.width.2  = 60
CompilerOptions.width.3  = 60

CompilerOptions.hide.    = 0
CompilerOptions.hide.0   = 3

CompilerOptions.return.0 = 3

LinkOptions.title    = 'Link options'
LinkOptions.prompt.0 = 3
LinkOptions.prompt.1 = 'Global options:'
LinkOptions.prompt.2 = 'Debug options:'
LinkOptions.prompt.3 = 'Production options:'

LinkOptions.width.0  = 3
LinkOptions.width.1  = 60
LinkOptions.width.2  = 60
LinkOptions.width.3  = 60

LinkOptions.hide.    = 0
LinkOptions.hide.0   = 3

LinkOptions.return.0 = 3

/*----------------------------------------------------------------------------*/
/* Definitions for message boxes                                              */
/*----------------------------------------------------------------------------*/

SaveProject.title  = 'Save project'
SaveProject.0      = 2
SaveProject.1      = 'Project information has changed.'
SaveProject.2      = 'Save information?'

NotImplemented.title = 'Sorry!'
NotImplemented.0     = 1
NotImplemented.1     = 'Option not implemented'

WrongVersion.title = 'Sorry!'
WrongVersion.0     = 1
WrongVersion.1     = 'No EditProject makefile or wrong version'
WrongVersion.2     = 'wrong version'

DeleteFileProblem.title = 'Problem!'
DeleteFileProblem.0 = 2
DeleteFileProblem.1 = 'Could not delete old makefile!'
DeleteFileProblem.2 = 'Change access flags and try again.'

UnnamedProject.title = 'Problem!'
UnnamedProject.0     = 2
UnnamedProject.1     = 'No name defined for project!'
UnnamedProject.2     = 'Define a name and try again.'

/*----------------------------------------------------------------------------*/
/* Initialize REXX-function-package                                           */
/*----------------------------------------------------------------------------*/

IF RxFuncQuery('SysLoadFuncs') THEN DO
  CALL RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
  CALL SysLoadFuncs
END

/*----------------------------------------------------------------------------*/
/* Initialize VREXX-function-package                                          */
/*----------------------------------------------------------------------------*/

CALL RxFuncAdd 'VInit', 'VREXX', 'VInit'
RC = VInit()
IF RC = 'ERROR' THEN
  SIGNAL cleanup
SIGNAL ON ERROR   NAME cleanup
SIGNAL ON FAILURE NAME cleanup
SIGNAL ON HALT    NAME cleanup
SIGNAL ON SYNTAX  NAME cleanup

OK       = 1
CANCEL   = 2
OKCANCEL = 3
YES      = 4
NO       = 5
YESNO    = 6

RETURN

/*----------------------------------------------------------------------------*/
/* SetDefaults: Set project-defaults for a new project                        */
/*----------------------------------------------------------------------------*/
SetDefaults:

Project.mode                      = BuildOption.1
Project.GlobalCompilerOptions     = ''
Project.DebugCompilerOptions      = ''
Project.ProductionCompilerOptions = ''
Project.GlobalLinkOptions         = ''
Project.DebugLinkOptions          = ''
Project.ProductionLinkOptions     = ''
Project.status                    = 'SAVED'          /* no changes yet!       */
sources.all                       = ''
sources.0                         = 0

RETURN 0

/*----------------------------------------------------------------------------*/
/* ReadProject: Read makefile of existing project                             */
/*----------------------------------------------------------------------------*/
ReadProject:

line = LINEIN(Project.file)
line = LINEIN(Project.file)
IF WORD(line,5) <> 'EditProject' | WORD(line,7) < 0.6 THEN DO
  CALL VMsgBox WrongVersion.title, WrongVersion, OK
  DROP makefile.
  RETURN 16
END

DO WHILE LINES(Project.file) > 0
  line = LINEIN(Project.file)
  SELECT
    WHEN WORD(line,1) = 'MODE' THEN DO
      IF SUBSTR(line,WORDINDEX(line,3),1) = 'D' THEN
         Project.mode = BuildOption.1
      ELSE
         Project.mode = BuildOption.2
    END

    WHEN WORD(line,1) = 'G_CFLAGS' THEN DO
      IF WORD(line,3) <> '' THEN
        Project.GlobalCompilerOptions = SUBSTR(line,WORDINDEX(line,3))
      ELSE
        Project.GlobalCompilerOptions = ''
    END
    WHEN WORD(line,1) = 'D_CFLAGS' THEN DO
      IF WORD(line,3) <> '' THEN
        Project.DebugCompilerOptions = SUBSTR(line,WORDINDEX(line,3))
      ELSE
        Project.DebugCompilerOptions = ''
    END
    WHEN WORD(line,1) = 'P_CFLAGS' THEN DO
      IF WORD(line,3) <> '' THEN
        Project.ProductionCompilerOptions = SUBSTR(line,WORDINDEX(line,3))
      ELSE
        Project.ProductionCompilerOptions = ''
    END

    WHEN WORD(line,1) = 'G_LFLAGS' THEN DO
      IF WORD(line,3) <> '' THEN
        Project.GlobalLinkOptions = SUBSTR(line,WORDINDEX(line,3))
      ELSE
        Project.GlobalLinkOptions = ''
    END
    WHEN WORD(line,1) = 'D_LFLAGS' THEN DO
      IF WORD(line,3) <> '' THEN
        Project.DebugLinkOptions = SUBSTR(line,WORDINDEX(line,3))
      ELSE
        Project.DebugLinkOptions = ''
    END
    WHEN WORD(line,1) = 'P_LFLAGS' THEN DO
      IF WORD(line,3) <> '' THEN
        Project.ProductionLinkOptions = SUBSTR(line,WORDINDEX(line,3))
      ELSE
        Project.ProductionLinkOptions = ''
    END

    WHEN WORD(line,1) = 'SOURCES' THEN DO
      IF WORD(line,3) <> '' THEN
        sources.all = SUBSTR(line,WORDINDEX(line,3))
      ELSE
        sources.all = ''
      sources.0 = STRIP(WORDS(sources.all))
      DO i = 1 TO sources.0
        sources.i = STRIP(WORD(sources.all,i))
      END
    END

    WHEN WORD(line,1) = 'VPATH' THEN DO
      Project.dir = TRANSLATE(WORD(line,3)'/','\','/')
      LEAVE
    END
    OTHERWISE NOP
  END
END
CALL LINEOUT Project.file

main.vstring   = main.5
Project.status = 'SAVED'
Project.name   = FILESPEC("name",Project.file)
PARSE VALUE Project.name WITH Project.Project '.' Project.environment
Project.environment = TRANSLATE(Project.environment)
IF Project.environment <> 'GCC' THEN
  Project.environment = 'EMX'
SelectProject.template = Project.dir'*.'Project.environment

RETURN 0

/*----------------------------------------------------------------------------*/
/* cleanup: Release of VREXX-resources                                        */
/*----------------------------------------------------------------------------*/
cleanup:

CALL VExit
EXIT

/*----------------------------------------------------------------------------*/
/* MainMenu: Show a dialog-box until CANCEL                                   */
/*----------------------------------------------------------------------------*/
MainMenu:

DO FOREVER
  CALL VDialogPos 50, 50
  CALL VRadioBox  'Project 'project.name, main, OKCANCEL
  IF RESULT = 'CANCEL' THEN DO
    IF project.status = 'CHANGED' THEN DO
      CALL VMsgBox SaveProject.title, SaveProject, YESNO
      IF RESULT = 'YES' THEN DO
        CALL WriteProject
        IF RESULT = 0 THEN
          LEAVE
      END
      ELSE
        LEAVE
    END
    ELSE
      LEAVE
  END
  ELSE DO
    SELECT
      WHEN main.vstring = main.1 THEN
        CALL SelectProject
      WHEN main.vstring = main.2 THEN
        CALL AddFiles
      WHEN main.vstring = main.3 THEN
        CALL DeleteFiles
      WHEN main.vstring = main.4 THEN
        CALL DefineBuildOption
      WHEN main.vstring = main.5 THEN
        CALL DefineCompilerOptions
      WHEN main.vstring = main.6 THEN
        CALL DefineLinkOptions
      WHEN main.vstring = main.7 THEN
        CALL WriteProject
      WHEN main.vstring = main.8 THEN
        CALL ExecuteMakefile
      OTHERWISE DO
        CALL VDialogPos 75, 25
        CALL VMsgBox NotImplemented.title, NotImplemented, OK
      END    /* OTHERWISE DO */
    END    /* SELECT */
  END    /* ELSE DO */
END    /* DO FOREVER */

RETURN

/*----------------------------------------------------------------------------*/
/* SelectProject: Display a file selection box for the makefile               */
/*----------------------------------------------------------------------------*/
SelectProject:

IF project.status = 'CHANGED' THEN DO
  CALL VMsgBox SaveProject.title, SaveProject, YESNO
  IF RESULT = 'YES' THEN DO
    CALL WriteProject
    IF RESULT > 0 THEN
      RETURN
  END
END

Project.vstring = Project.file
CALL VFileBox SelectProject.title, SelectProject.template, 'Project'
IF RESULT <> 'CANCEL' THEN DO
   Project.status = 'CHANGED'
   Project.file   = Project.vstring

   Project.name   = FILESPEC("name",Project.vstring)
   PARSE VALUE Project.name WITH Project.project '.' Project.environment
   Project.environment = TRANSLATE(Project.environment)
   IF Project.environment <> 'GCC' THEN
     Project.environment = 'EMX'

   Project.dir    = FILESPEC("drive",Project.vstring) ||,
                    FILESPEC("path",Project.vstring)
   SelectProject.template = Project.dir'*.'Project.environment

   CALL SysFileTree Project.file, 'count', 'FO'
   IF count.0 = 0 THEN                         /* project file doesn't exist! */
     CALL SetDefaults
   ELSE
     CALL ReadProject
     IF RESULT > 0 THEN DO
       Project.name = '.unnamed'
       SelectProject.template = '*.emx'
       main.vstring = 1
     END
   DROP count.
   RETURN 0
END
RETURN 1

/*----------------------------------------------------------------------------*/
/* AddFiles: Add source-files to the project                                  */
/*----------------------------------------------------------------------------*/
AddFiles:

sources.id = VOpenWindow(sources.title,sources.back,sources)
CALL VSetFont sources.id, sources.type, sources.size
sources.linenr = 1000

CALL VForeColor sources.id, sources.fore
DO i = 1 TO sources.0
  sources.linenr = sources.linenr - sources.diff
  CALL VSay sources.id, 5, sources.linenr, sources.i
END

DO FOREVER
   CALL VFileBox AddFiles.title, Project.dir||AddFiles.template, 'AddFiles'
   IF RESULT = 'CANCEL' THEN
     LEAVE
   ELSE IF WORDPOS(FILESPEC("name",AddFiles.vstring),sources.all) = 0 THEN DO
     Project.status = 'CHANGED'
     sources.0      = sources.0 + 1
     i              = sources.0
     sources.i      = FILESPEC("name",AddFiles.vstring)
     sources.all    = sources.all sources.i
     sources.linenr = sources.linenr - sources.diff
     CALL VForeColor sources.id, sources.fore
     CALL VSay       sources.id, 5, sources.linenr, sources.i
   END   /* ELSE DO */
END    /* DO FOREVER */

CALL VCloseWindow sources.id
RETURN

/*----------------------------------------------------------------------------*/
/* DeleteFiles: Remove files from project list                                */
/*----------------------------------------------------------------------------*/
DeleteFiles:

CALL VDialogPos 75, 50
DO FOREVER
  IF words(sources.all) = 0 THEN
    LEAVE
  CALL VListBox DeleteFiles.title, sources, DeleteFiles.width,,
                DeleteFiles.height, OKCANCEL
  IF RESULT = 'CANCEL' THEN
    LEAVE
  ELSE DO
    Project.status = 'CHANGED'
    IF WORDS(sources.all) = 1 THEN
      sources.all = ''
    ELSE
      sources.all = DELWORD(sources.all,WORDPOS(sources.vstring,sources.all),1)
    DO i=1 TO sources.0
      IF sources.i <> sources.vstring THEN
        ITERATE
      ELSE DO
        IF sources.0 = 1 THEN DO
          sources.0 = 0
          sources.1 = ''
        END
        ELSE DO
          sources.0 = sources.0 - 1
          DO i=i TO sources.0
            nexti = i + 1
            sources.i = sources.nexti
          END
        END          /* ELSE DO (IF sources.0 = 1)               */
        LEAVE        /* DO i=1 TO sources.0                      */
      END          /* ELSE DO  (IF sources.i <> sources.vstring) */
    END          /* DO i=1 TO sources.0                          */
  END          /* ELSE DO                                        */
END          /* DO FOREVER                                       */

RETURN

/*----------------------------------------------------------------------------*/
/* DefineBuildOption: Choose between debug- and production-mode               */
/*----------------------------------------------------------------------------*/
DefineBuildOption:

BuildOption.vstring = Project.mode
CALL VRadioBox BuildOption.title, BuildOption, OKCANCEL
IF RETURN <> 'CANCEL' THEN DO
  Project.status = 'CHANGED'
  IF BuildOption.vstring = BuildOption.1 THEN
    Project.mode = 'D'
  ELSE
    Project.mode = 'P'
END
RETURN

/*----------------------------------------------------------------------------*/
/* DefineCompilerOptions: Define compiler options (global, debug, production) */
/*----------------------------------------------------------------------------*/
DefineCompilerOptions:

CompilerOptions.return.1 = Project.GlobalCompilerOptions
CompilerOptions.return.2 = Project.DebugCompilerOptions
CompilerOptions.return.3 = Project.ProductionCompilerOptions

CALL VMultBox CompilerOptions.title, CompilerOptions.prompt, CompilerOptions.width,,
              CompilerOptions.hide, CompilerOptions.return, OKCANCEL
IF RESULT <> 'CANCEL' THEN DO
  Project.status                    = 'CHANGED'
  Project.GlobalCompilerOptions     = CompilerOptions.return.1
  Project.DebugCompilerOptions      = CompilerOptions.return.2
  Project.ProductionCompilerOptions = CompilerOptions.return.3
END
RETURN

/*----------------------------------------------------------------------------*/
/* DefineLinkOptions: flags and libs for the linker                           */
/*----------------------------------------------------------------------------*/
DefineLinkOptions:

LinkOptions.return.1 = Project.GlobalLinkOptions
LinkOptions.return.2 = Project.DebugLinkOptions
LinkOptions.return.3 = Project.ProductionLinkOptions

CALL VMultBox LinkOptions.title, LinkOptions.prompt, LinkOptions.width,,
              LinkOptions.hide, LinkOptions.return, OKCANCEL
IF RESULT <> 'CANCEL' THEN DO
  Project.status                = 'CHANGED'
  Project.GlobalLinkOptions     = LinkOptions.return.1
  Project.DebugLinkOptions      = LinkOptions.return.2
  Project.ProductionLinkOptions = LinkOptions.return.3
END
RETURN

/*----------------------------------------------------------------------------*/
/* WriteProject: Generate the makefile                                        */
/*----------------------------------------------------------------------------*/
WriteProject:

IF Project.name = '.unnamed' THEN DO
  CALL VMsgBox UnnamedProject.title, UnnamedProject, OK
  RETURN 1
END

d_objects.all = ''
p_objects.all = ''
DO i = 1 TO sources.0

  PARSE VALUE sources.i WITH objects.i '.' .
  IF Project.environment = 'EMX' THEN DO
    IF POS('-Zomf',Project.GlobalCompilerOptions,
                                          Project.DebugCompilerOptions) > 0 THEN
      d_objects.all = d_objects.all objects.i || '.obj'
     ELSE
      d_objects.all = d_objects.all objects.i || '.o'
    IF POS('-Zomf',Project.GlobalCompilerOptions,
                                     Project.ProductionCompilerOptions) > 0 THEN
      p_objects.all = p_objects.all objects.i || '.obj'
     ELSE
      p_objects.all = p_objects.all objects.i || '.o'
  END
  ELSE DO
    d_objects.all = d_objects.all objects.i || '.obj'
    p_objects.all = p_objects.all objects.i || '.obj'
  END

  dependents.i = sources.i
  CALL SysFileSearch '#include', Project.dir||sources.i,'includes.'
  DO j = 1 TO includes.0
    IF SUBSTR(WORD(includes.j,2),1,1) = '"' THEN
      dependents.i = dependents.i STRIP(WORD(includes.j,2),'B','"')
  END
END

IF SysFileDelete(Project.file) > 2 THEN DO
  CALL VMsgBox DeleteFileProblem.title, DeleteFileProblem, OK
  RETURN 1
END

CALL LINEOUT Project.file, '# ============== Do not edit between these lines! ================'
CALL LINEOUT Project.file, '# Makefile generated by EditProject Version' EditProject.version
CALL LINEOUT Project.file, '# Project:' Project.project
CALL LINEOUT Project.file, '# Date:   ' DATE()
CALL LINEOUT Project.file, '# Time:   ' TIME()
CALL LINEOUT Project.file, ' '
CALL LINEOUT Project.file, 'CC =' EditProject.compiler
CALL LINEOUT Project.file, 'MODE =' Project.mode

CALL LINEOUT Project.file, 'G_CFLAGS =' Project.GlobalCompilerOptions
CALL LINEOUT Project.file, 'D_CFLAGS =' Project.DebugCompilerOptions
CALL LINEOUT Project.file, 'P_CFLAGS =' Project.ProductionCompilerOptions

CALL LINEOUT Project.file, 'G_LFLAGS =' Project.GlobalLinkOptions
CALL LINEOUT Project.file, 'D_LFLAGS =' Project.DebugLinkOptions
CALL LINEOUT Project.file, 'P_LFLAGS =' Project.ProductionLinkOptions

CALL LINEOUT Project.file, 'PROJECT =' Project.project
CALL LINEOUT Project.file, 'SOURCES =' sources.all
CALL LINEOUT Project.file, 'D_OBJECTS =' d_objects.all
CALL LINEOUT Project.file, 'P_OBJECTS =' p_objects.all
CALL LINEOUT Project.file, 'VPATH   =' STRIP(TRANSLATE(Project.dir,'/','\'),'T','/')
CALL LINEOUT Project.file, ' '
CALL LINEOUT Project.file, '# ============== Do not edit between these lines! ================'
CALL LINEOUT Project.file, ' '
CALL LINEOUT Project.file, '$(PROJECT).EXE : $($(MODE)_OBJECTS)'
CALL LINEOUT Project.file, D2C(9)'$(CC) $($(MODE)_OBJECTS) $(G_LFLAGS) $($(MODE)_LFLAGS) \'
CALL LINEOUT Project.file, '                                    -o $(PROJECT).EXE'
CALL LINEOUT Project.file, ' '
CALL LINEOUT Project.file, '%.o : %.c'
CALL LINEOUT Project.file, D2C(9)'$(CC) $(G_CFLAGS) $($(MODE)_CFLAGS) -c $< -o $@'
CALL LINEOUT Project.file, ' '
CALL LINEOUT Project.file, '%.obj : %.c'
CALL LINEOUT Project.file, D2C(9)'$(CC) $(G_CFLAGS) $($(MODE)_CFLAGS) -c $< -o $@'
CALL LINEOUT Project.file, ' '
CALL LINEOUT Project.file, '%.o : %.cc'
CALL LINEOUT Project.file, D2C(9)'$(CC) $(G_CFLAGS) $($(MODE)_CFLAGS) -c $< -o $@'
CALL LINEOUT Project.file, ' '
CALL LINEOUT Project.file, '%.obj : %.cc'
CALL LINEOUT Project.file, D2C(9)'$(CC) $(G_CFLAGS) $($(MODE)_CFLAGS) -c $< -o $@'
CALL LINEOUT Project.file, ' '

DO i=1 TO sources.0
  CALL LINEOUT Project.file, ' '
  CALL LINEOUT Project.file, WORD(d_objects.all,i) ':' dependents.i
  IF d_objects.all <> p_objects.all THEN DO
    CALL LINEOUT Project.file, ' '
    CALL LINEOUT Project.file, WORD(p_objects.all,i) ':' dependents.i
  END
END
CALL LINEOUT Project.file

Project.status = 'SAVED'
RETURN 0

/*----------------------------------------------------------------------------*/
/* ExecuteMakeFile: Run MAKE with current build option                        */
/*----------------------------------------------------------------------------*/
ExecuteMakeFile:

IF project.status = 'CHANGED' THEN DO
  CALL VMsgBox SaveProject.title, SaveProject, YESNO
  IF RESULT = 'YES' THEN DO
    CALL WriteProject
    IF RESULT > 0 THEN
      RETURN
  END
END

"START /c /win" EditProject.make,
      "-k -f" TRANSLATE(Project.file,'/','\') "MODE="Project.mode
RETURN
