/*
ͻ
 What's it called: EPMGCC  V1.00                                              
                                                                              
 What does it do:  The E source code for the GCC-Interface for EPM.           
                   This file contains the command and procedure definitions   
                   and is linked separately because of the size limitation    
                   of epm.ex (64K).                                           
                                                                              
 Who and When:     B. Bablok 12/93 - 01/94                                    
                                                                              
ͼ

Ŀ
  Definitions of external commands, if not defined in gccenv.e                

*/
TRYINCLUDE 'gccenv.e'

COMPILE IF not defined(GCC_EDIT_COMMAND)
   CONST   GCC_EDIT_COMMAND = 'start /c /win epro'
COMPILE ENDIF

COMPILE IF not defined(GCC_COMP_COMMAND)
   CONST   GCC_COMP_COMMAND = 'start /n /win gcc'
COMPILE ENDIF

COMPILE IF not defined(GCC_BUILD_COMMAND)
   CONST   GCC_BUILD_COMMAND = 'start /n /win make'
COMPILE ENDIF

COMPILE IF not defined(GCC_DEBUG_COMMAND)
   CONST   GCC_DEBUG_COMMAND = 'start /n /win gdb'
COMPILE ENDIF
/*
Ŀ
  Command definitions (menu commands)                                         

*/
DEFC open_project =
  UNIVERSAL gcc_project_file, gcc_project, gcc_error_file, gcc_error_file_id

  gcc_project_file = ENTRYBOX('Make-file name:','/Ok/Cancel/',
                                                         gcc_project_file,20,40)
  gcc_project = SUBSTR(gcc_project_file,1,LASTPOS('.',gcc_project_file)-1)
  gcc_error_file    = ''
  gcc_error_file_id = ''

DEFC edit_project =
  UNIVERSAL gcc_project_file
  GCC_EDIT_COMMAND gcc_project_file

DEFC close_project =
  UNIVERSAL gcc_project, gcc_project_file, gcc_error_file, gcc_error_file_id
  gcc_project       = ''
  gcc_project_file  = ''
  gcc_error_file    = ''
  gcc_error_file_id = ''

DEFC set_comp_options =
  UNIVERSAL gcc_d_comp_options, gcc_p_comp_options, gcc_debug

  IF gcc_debug THEN
    buf = ENTRYBOX('Compile parameters (debug):','/Ok/CANCEL/',
                                              gcc_d_comp_options,30,100,atoi(1))
  ELSE
    buf = ENTRYBOX('Compile parameters (prod):','/Ok/CANCEL/',
                                              gcc_p_comp_options,30,100,atoi(1))
  ENDIF
  button = ASC(SUBSTR(buf,1,1))
  IF button <> 1 THEN
     SAYERROR 'Cancelled'
  ELSE
     eos = POS(\0,buf,2)
     IF gcc_debug THEN
        gcc_d_comp_options = SUBSTR(buf,2,eos-2)
     ELSE
        gcc_p_comp_options = SUBSTR(buf,2,eos-2)
     ENDIF
  ENDIF

DEFC compile_file =
  UNIVERSAL gcc_error_file, gcc_error_file_id, gcc_autosave, gcc_verbose,
            gcc_debug, gcc_d_comp_options, gcc_p_comp_options

  IF .modify THEN
     IF gcc_autosave THEN
        'Save'
         SAYERROR 'Saving file before invoking gcc!'
     ELSE
         SAYERROR 'Warning: File not saved! Compiling old version!'
     ENDIF
  ENDIF

  gcc_error_file = SUBSTR(.filename,1,LASTPOS('.',.filename)) || 'err'

  IF gcc_debug THEN
     command = gcc_resolve_template(gcc_d_comp_options,'C') '> ' ||
                                                           gcc_error_file '2>&1'
  ELSE
     command = gcc_resolve_template(gcc_p_comp_options,'C') '> ' ||
                                                           gcc_error_file '2>&1'
  ENDIF

  IF gcc_verbose THEN
     SAYERROR GCC_COMP_COMMAND command
  ENDIF
  GCC_COMP_COMMAND command
  IF rc <> 0 THEN
     SAYERROR 'Error invoking GCC, RC =' rc
  ELSE
     gcc_error_file_id = ''                   -- reset error_file_id
  ENDIF

DEFC set_make_options =
  UNIVERSAL gcc_d_make_options, gcc_p_make_options, gcc_debug

  IF gcc_debug THEN
    buf = ENTRYBOX('Build parameters (debug):','/Ok/CANCEL/',
                                              gcc_d_make_options,30,100,atoi(1))
  ELSE
    buf = ENTRYBOX('Build parameters (prod):','/Ok/CANCEL/',
                                              gcc_p_make_options,30,100,atoi(1))
  ENDIF
  button = ASC(SUBSTR(buf,1,1))
  IF button <> 1 THEN
     SAYERROR 'Cancelled'
  ELSE
     eos = POS(\0,buf,2)
     IF gcc_debug THEN
        gcc_d_make_options = SUBSTR(buf,2,eos-2)
     ELSE
        gcc_p_make_options = SUBSTR(buf,2,eos-2)
     ENDIF
  ENDIF

DEFC build_project =
  UNIVERSAL gcc_error_file, gcc_project_file, gcc_project, gcc_verbose,
            gcc_debug, gcc_error_file_id, gcc_d_make_options,
            gcc_p_make_options, gcc_autosave

  IF gcc_autosave THEN
     SAYERROR 'Saving files before invoking make!'
     GETFILEID StartFileID
     LOOP
        IF .modify THEN
           'Save'
        ENDIF
        NEXTFILE
        GETFILEID NextFileID
        IF NextFileID = StartFileID THEN
           LEAVE
        ENDIF
        ACTIVATEFILE NextFileID
     ENDLOOP
     ACTIVATEFILE StartFileID
  ENDIF

  gcc_error_file = gcc_project || '.err' -- intervening compile_file is possible
  IF gcc_debug THEN
     command = gcc_resolve_template(gcc_d_make_options,'M') '> ' ||
                                                           gcc_error_file '2>&1'
  ELSE
     command = gcc_resolve_template(gcc_p_make_options,'M') '> ' ||
                                                           gcc_error_file '2>&1'
  ENDIF

  IF gcc_verbose THEN
     SAYERROR GCC_BUILD_COMMAND command
  ENDIF
  GCC_BUILD_COMMAND command
  IF rc <> 0 THEN
     SAYERROR 'Error invoking MAKE, RC =' rc
  ELSE
     gcc_error_file_id = ''                   -- reset error_file_id
  ENDIF

DEFC view_results =
  UNIVERSAL gcc_project, gcc_error_file, gcc_error_file_id
  IF gcc_error_file <> '' THEN
     'EDIT /d' gcc_error_file
  ELSEIF EXIST(gcc_project'.err') THEN
     gcc_error_file = gcc_project'.err'
     'EDIT /d' gcc_error_file
  ELSEIF EXIST(SUBSTR(.filename,1,LASTPOS('.',.filename)) || 'err') THEN
     gcc_error_file = SUBSTR(.filename,1,LASTPOS('.',.filename)) || 'err'
     'EDIT /d' gcc_error_file
  ENDIF
  GETFILEID gcc_error_file_id

DEFC run_exe =
  UNIVERSAL gcc_project, gcc_runtime_arguments
  buf = ENTRYBOX('Programm parameters:','/Ok/CANCEL/',gcc_runtime_arguments,
                                                                  30,60,atoi(1))
  button = ASC(SUBSTR(buf,1,1))
  IF button <> 1 THEN
     SAYERROR 'Cancelled'
  ELSE
     eos = POS(\0,buf,2)
     gcc_runtime_arguments = SUBSTR(buf,2,eos-2)
     IF EXIST(gcc_project'.exe') THEN
        'start /n /win' gcc_project gcc_runtime_arguments
     ELSE
        'start /n /win' SUBSTR(.filename,1,LASTPOS('.',.filename)) || 'exe ' ||
                                                           gcc_runtime_arguments
     ENDIF
  ENDIF

DEFC debug_exe =
  UNIVERSAL gcc_project

  IF EXIST(gcc_project'.exe') THEN
     GCC_DEBUG_COMMAND gcc_project || '.exe'
  ELSE
     GCC_DEBUG_COMMAND SUBSTR(.filename,1,LASTPOS('.',.filename)) || 'exe'
  ENDIF

DEFC toggle_debug_mode =
  UNIVERSAL gcc_debug, gcc_verbose
  gcc_debug = NOT gcc_debug
  IF gcc_verbose THEN
      SAYERROR 'gcc_debug = 'gcc_debug
  ENDIF

DEFC toggle_autosave_mode =
  UNIVERSAL gcc_autosave, gcc_verbose
  gcc_autosave = NOT gcc_autosave
  IF gcc_verbose THEN
      SAYERROR 'gcc_autosave = 'gcc_autosave
  ENDIF

DEFC toggle_verbose_mode =
  UNIVERSAL gcc_verbose
  gcc_verbose = NOT gcc_verbose
  IF gcc_verbose THEN
      SAYERROR 'gcc_verbose = 'gcc_verbose
  ENDIF
/*
Ŀ
  Procedure definitions                                                       

*/

DEFPROC get_gcc_debug_mode =
  UNIVERSAL gcc_debug
  RETURN gcc_debug

DEFPROC get_gcc_autosave_mode =
  UNIVERSAL gcc_autosave
  RETURN gcc_autosave

DEFPROC get_gcc_verbose_mode =
  UNIVERSAL gcc_verbose
  RETURN gcc_verbose

DEFPROC gcc_project_open =
  UNIVERSAL gcc_project
  RETURN gcc_project <> ''

DEFPROC gcc_project_file_exists =
  UNIVERSAL gcc_project_file
  RETURN EXIST(gcc_project_file)

DEFPROC gcc_exe_exists =
  UNIVERSAL gcc_project
  RETURN EXIST(gcc_project || '.exe') OR
         EXIST(SUBSTR(.filename,1,LASTPOS('.',.filename)) || 'exe')

DEFPROC gcc_error_file_exists =
  UNIVERSAL gcc_project, gcc_error_file
  RETURN gcc_error_file <> '' OR  EXIST(gcc_project || '.err') OR
         EXIST(SUBSTR(.filename,1,LASTPOS('.',.filename)) || 'err')

DEFPROC gcc_is_cc_file =
  ext = FILETYPE()
  RETURN WORDPOS(ext,'CC C CXX CPP') > 0

DEFPROC gcc_next_error =
   UNIVERSAL gcc_error_file_id, gcc_other_file_id, gcc_error_file

   IF gcc_error_file_id = '' THEN
      IF gcc_error_file_exists() THEN
         'view_results'
      ELSE
         SAYERROR 'No compile/build-results available. Use Compile/Build first.'
      ENDIF
      RETURN
   ENDIF

   GETFILEID gcc_other_file_id
   IF gcc_other_file_id <> gcc_error_file_id THEN      -- not in error-file
     ACTIVATEFILE gcc_error_file_id                    -- switch to error-file
     IF .line = .last THEN                             -- no more errors
       ACTIVATEFILE gcc_other_file_id                  -- go back
       SAYERROR "No more errors!"
       RETURN
     ELSE
       "+1"                                            -- next line
     ENDIF
   ENDIF

   WHILE (.line <= .last) DO           -- iterate until a "true" error is found
     GETLINE  line                     -- errors look like file.c:12: message
     IF SUBSTR(line,2,1) = ":" THEN
        PARSE VALUE line WITH drive ":" filename ":" lineno ":" gcc_message
        filename = drive":"filename
     ELSE
        PARSE VALUE line WITH filename ":" lineno ":" gcc_message
     ENDIF
     IF NOT ISNUM(lineno) OR POS(":",WORD(line,1)) = 0 THEN
       IF .line = .last THEN
          SAYERROR "No more errors!"
          RETURN
       ELSE                           -- try the next line
         "+1"
       ENDIF
     ELSE                             -- found an error
       "EDIT" TRANSLATE(filename,'\','/') "'"lineno"'"
       SAYERROR gcc_message
       RETURN
     ENDIF
   ENDWHILE

DEFPROC gcc_resolve_template =
   UNIVERSAL gcc_project_file

   template = ARG(1)
   option   = ARG(2)    -- C for compile and M for make

   IF option = 'C' THEN
      file = .filename
   ELSE
      file = gcc_project_file
   ENDIF
   path = SUBSTR(file,1,LASTPOS('\',file))
   IF SUBSTR(file,2,1) = ':' THEN
       drive = SUBSTR(file,1,2)
   ELSE
       drive = ''
   ENDIF
   fname = DELSTR(file,1,LENGTH(path))
   name  = SUBSTR(fname,1,LASTPOS('.',fname)-1)
   ext   = DELSTR(fname,1,LENGTH(name)+1)

   col = POS('%**E',template)
   WHILE col > 0 DO
      template = DELSTR(template,col,4)
      template = SUBSTR(template,1,col-1) || ext || SUBSTR(template,col)
      col = POS('%**E',template)
   ENDWHILE
   col = POS('%**N',template)
   WHILE col > 0 DO
      template = DELSTR(template,col,4)
      template = SUBSTR(template,1,col-1) || name || SUBSTR(template,col)
      col = POS('%**N',template)
   ENDWHILE
   col = POS('%**F',template)
   WHILE col > 0 DO
      template = DELSTR(template,col,4)
      template = SUBSTR(template,1,col-1) || fname || SUBSTR(template,col)
      col = POS('%**F',template)
   ENDWHILE
   col = POS('%**P',template)
   WHILE col > 0 DO
      template = DELSTR(template,col,4)
      template = SUBSTR(template,1,col-1) || path || SUBSTR(template,col)
      col = POS('%**P',template)
   ENDWHILE
   col = POS('%**D',template)
   WHILE col > 0 DO
      template = DELSTR(template,col,4)
      template = SUBSTR(template,1,col-1) || drive || SUBSTR(template,col)
      col = POS('%**D',template)
   ENDWHILE
   col = POS('%*',template)
   WHILE col > 0 DO
      template = DELSTR(template,col,2)
      template = SUBSTR(template,1,col-1) || file || SUBSTR(template,col)
      col = POS('%*',template)
   ENDWHILE

   RETURN TRANSLATE(template,'/','\')
