/*
ͻ
 What's it called: EPMGCC  V1.00                                              
                                                                              
 What does it do:  The E source code for the GCC-Interface                    
                   for EPM. This file defines some shortcut keys for the      
                   GCC-menu. Just change the definitions to some other        
                   keys if this seems suitable for your needs.                
                                                                              
                   The keys will always be defined, since the definitions     
                   are included in the basic keyset. Defining an alternate    
                   keyset is not a good alternative, since EPMGCC is ty-      
                   pically used with c-syntax-assist, which defines it's      
                   own alternate keyset.                                      
                                                                              
 Who and When:     B. Bablok 12/93 - 01/94                                    
                                                                              
ͼ
*/
DEF a_Q = gcc_next_error()    -- defined in gccproc.e (no menu equivalent!)
/*
ͻ
 How does it work: After compiling/building a project, pressing a-Q takes     
                   you to the error-file. In the error-file, position the     
                   cursor on an error-message and press a-Q again. If ne-     
                   cessary, the source file is loaded into the edit-ring      
                   and the cursor is positioned on the erroneous line. If     
                   the cursor isn't positioned on an error-message (e.g.      
                   message of the linker) than the message is skipped.        
                   Pressing a-Q in a source file will take you to the next    
                   error, until all errors are processed.                     
ͼ
*/
DEF c_F11 =                      -- menu equivalent: Set compile options
  IF gcc_is_cc_file() THEN
    'set_comp_options'
  ELSE
    SAYERROR 'No c/cc-file'
  ENDIF

DEF c_F12 =                      -- menu equivalent: Compile current file
  IF gcc_is_cc_file() THEN
    'compile_file'
  ELSE
    SAYERROR 'cannot compile' .filename
  ENDIF

DEF s_F11 =                      -- menu equivalent: Set build options
  IF gcc_project_open() THEN
    'set_make_options'
  ELSE
    SAYERROR 'no project open'
  ENDIF

DEF s_F12 =                      -- menu equivalent: Build current project
  IF gcc_project_file_exists() THEN
    'build_project'
  ELSE
    SAYERROR 'project file does not exist'
  ENDIF
