#!/usr/bin/msub

# Now to something completely different.
# Suppose you want to change "strings" to 'strings'.

# Finding "-strings is not so hard.
# The ``"'' characters need to be quoted.  I use single quotes for that.
# If I needed to search for single quotes, I would enclose them in
# double quotes.  Although the \ escape is available, I wouldn't want to
# use it.  Makes expressions unreadable.

# This is the search expression for a simple "-delimited string:
#	'"'[^'"']*'"'
# There is a problem, though.  I only want to change the quotes, not the
# part between the quotes.  I need to copy the text between the quotes.
# So I'll do just that!

'"'~1[^'"']*~1'"'
"'"~1"'"

# The part of the search expression between ~1 and ~1 has been marked
# for copying.  When ~1 appears in the replacement string, it copies
# that part from the search expression.
# You can mark several parts of the search string.  There are 10 
# selection markers, ~0,~1,...,~9

