#!/usr/bin/msub

# A script for changing spaces to <Tab>s in a text file.
# Assumes tab stops every 8 columns.
#
# Should be fast enough: One iteration per tab column in file.
# Plus it uses fully deterministic regexps.

	# First, remove pre-existing tab stops; makes life easier.
	# `detab.ms' must be in path
!begin
	!include detab.ms
!end


# Sharps are used for tab stop marking, so first they must be removed
# Note: The exact length of the replace text must be 8*n+1 for some n
"#"
"<Sharp!!>"

!newpass

# Introduce sharps at tab stops, starting at left margin
^
^"#"


              # Implicit !newpass with !begin
!begin
!iterate=30
            # Works the tab stop marker rightwards, 8
            # columns at a time, changing spaces to tabs
            # in those eight columns (if there are any
	    # tabs in a column, the the tab will be the
	    # last char, as tab advances to the next column).

		# Columns without tabs:
		# If there are 8 chars or more left, and the last
		# one isn't a space, then go on to the next column.


"#"`.......[^$ ]`
`"#"

		# One space isn't worth changing:
"#"`......[^$ ]" "`
`"#"


		# If the last two or more are spaces, change them to tabs.
"#"`.....[^$ ]`"  "
`\9"#"

"#"`....[^$ ]`"   "
`\9"#"

"#"`...[^$ ]`"    "
`\9"#"

"#"`..[^$ ]`"     "
`\9"#"

"#"`.[^$ ]`"      "
`\9"#"

"#"`[^$ ]`"       "
`\9"#"

"#        "
\9"#"

!end

                # Fewer than 8 chars:
		# Done with this line, remove the sharp.

"#"`.......$`
`

"#"`......$`
`

"#"`.....$`
`

"#"`....$`
`

"#"`...$`
`

"#"`..$`
`

"#"`.$`
`

"#"`$`
`

# Finally, bring back the removed sharps:
!newpass
"<Sharp!!>"
"#"
