	page ,132
;fmtfix vers 1.0  wm thompson January 25, 1994
;
;avoids long delay when trying to format a blank disk under
;ms-dos 6.2.  this is due to doublespace's "automount" feature
;which tries to determine if the disk is doublespace formatted.
;in particular with machines having an AMI bios and running
;smartdrive, this causes a delay of over a minute before the disk
;starts formatting.  this program detects the first disk read with
;a "missing address mark" error (a blank) and fakes all subsequent
;reads within 1/2 second with an immediate failure, thereby avoiding
;the delay.

;assemble like this:
; masm fmtfix;
; link fmtfix;
; exe2bin fmtfix fmtfix.com

;interrupt vectors
bioint	equ	13h			;std bios disk call
timint	equ	08h			;timer tick interrupt

;labels for interrupt jump table
abs0	segment at 0
	org	bioint*4
biooff	label	word			;disk interrupt
	org	$+2
bioseg	label	word
	org	timint*4
timoff	label	word			;timer tick interrupt
	org	$+2
timseg	label	word
abs0	ends				;end of labels

;and now, the actual program...
code	segment				;segment for pgm
	assume cs:code,ds:abs0
	org	100h

start:	jmp	setup			;go install this tsr

;tsr replacement dos function call for trap
newdsk:	cmp	dl,1			;drive a: or b:?
	ja	nwdsk1			;no, jmp to bios

nwc1:	cmp	ah,2			;read sectors?
	jne	nwdsk1			;no, jmp to bios

nwc2:	and	byte ptr cs:lastc,-1	;count down=0?
	jnz	nwc4			;no, restart count and fail

nwc3:	pushf				;yes, pretend this is an interrupt
	call	cs:dskbio		;and do the read using bios
	jnc	nwc6			;exit saving flags if ok
	cmp	ah,2			;missing addr mark (blank disk)?
	jne	nwc5			;exit with error if not

nwc4:	mov	al,9			;else, preset count
	mov	cs:lastc,al
	mov	al,0			;no sctrs read, addr mark fail (ah=2)
nwc5:	stc				;carry set=fail
nwc6:	retf	2			;and return from int saving flags

;jump to installed far address for dos call
nwdsk1:	db	0eah			;far jmp opcode
dskbio	label	dword			;for far call to bios disk funct.
nwdsk2:	dw	0			;code addr overwritten at install
	dw	0			;seg addr overwritten at install

;timer tick interrupt add-on counts down until it reaches zero
newtim:	or	byte ptr cs:lastc,0	;timer counted down?
	jz	gotim			;yes, do nothing
	dec	byte ptr cs:lastc	;no, count down one tick
gotim:	db	0eah			;far jmp opcode
timx	dw	0			;addr written at install
	dw	0			;jmps to original timer code

;storage
lastc	db	0			;save time count
last_adr:				;for term and stay resident

;installation code used once at startup
	assume ds:abs0

setup:	push	ds			;set data segment
	xor	ax,ax			;for int vector table
	mov	ds,ax
	assume	ds:abs0

	mov	si,bioint*4		;install old interrupt addr's
	mov	ax,[si]	
	cmp	ax,offset newdsk	;already installed?
	je	noins			;yes, don't re-do

	lea	bx,nwdsk2		;in our code
	mov	cs:[bx],ax
	mov	ax,[si+2]
	mov	cs:[bx+2],ax

	mov	si,timint*4
	lea	bx,timx
	mov	ax,[si]
	mov	cs:[bx],ax
	mov	ax,[si+2]
	mov	cs:[bx+2],ax

	pop	ds			;restore data segment
	assume ds:code

	lea	dx,newdsk		;new disk bios interrupt vector offset
	mov	ah,37			;change vector function
	mov	al,bioint
	int	21h

	lea	dx,newtim		;new timer interrupt vector offset
	mov	ah,37			;change vector function
	mov	al,timint
	int	21h

	lea	dx,msg			;display signon message
	mov	ah,9
	int	21h

	lea	dx,last_adr		;for memory alloc
	int	27h			;term and stay resident

noins:	pop	ds			;no install
	assume ds:code
	lea	dx,msg2			;display no install message
	mov	ah,9
	int	21h
	int	20h			;exit to dos

msg	db	"DOS 6.2 resident format fix utility v1.0"
	db	0dh,0ah
	db	"copyright (c) 1994 William M. Thompson"
	db	0dh,0ah,"$"

msg2	db	"DOS 6.2 resident format fix utility already installed"
	db	0dh,0ah,"$"

code	ends				;end code segment
	end	start			;end of program

