#define FULLSIZE 128

// Fade mode equates.  NOFADE just sets the palette immediately.
// Fade fades the old palette out, and fades the new palette in.
#define NOFADE 0
#define FADE 1
#define FASTFADE 2
// Return codes, otherwise return code is number of frames in VDO.
#define VDONOTFOUND 0 // File not found.
#define NOVDOMEM -1  // Returns -1 if failed on memory allocation.

// Play modes.	Define's playback method.
#define MCGA1 0 // Standard playback 1:1 MCGA 320x200 256 color playback.
#define MCGA2 1 // Space pixels, put a blank pixel between each.
#define MCGA3 2 // Play back video double sized. (not implemented)
int far SetVDO(char far *fname,int fademode,int playmode);

void far CloseVDO(void);

// Return codes for PlayVDOFrame.
#define NOVDO -1	// return code of No VDO file is registered, otherwise
#define EMPTYFILE -2 // unexpected end of file, playing video data.
			// returns frame number played.
// Playback modes.
#define BLITBUFFER 0		// Playback video to blit buffer only.
#define BLITSCREEN 1		// Playback video to blit buffer, but blit to screen.
#define VIDSCREEN 2 		// Play video directly to screen ram.
#define VIDSEEK 3 			// Just seek to the next frame.
#define TRANSPARENT 4 	// Blit with see-through transparency color.
int far PlayVDOFrame(int xloc,int yloc,int size,int mode);

void far RewindVDO(void); // rewind back to frame zero.

int far SeekVDO(int FrameNo); // Seek VDO to this video frame number.

void far VDOVidOn(void); // Turn MCGA video on.
void far VDOVidOff(void); // Turn MCGA video off.

// Remap the currently set VDO file, into the CURRENT VGA color palette.
//	This feature allows you to take a video image and play it back using
//	your existing color palette.	You accomplish this task by virtue of
//	the PalMask that is passed.  PalMask is a 256 byte table that describes
//	how you have your VGA color palette chopped up.
//	Invoke BuildMaskPalette after you have Set the VDO and before you
//	begin playing it.
//		Each entry in PalMask corresponds to a VGA color.  The entries
//		mean as follows:
//			 0 -> This color is available for use, it can be replaced
//						with a necessary VDO color.
//			 1 -> This color cannot be changed, but the VDO player can
//						refer to it, and it is guarenteed not to change.
//			 2 -> This color cannot be changed, and cannot be referred to
//						it is a volatile color.
void far BuildMaskPalette(char far *PalMask);

// Report the width and height of the VDO.
//	 Return code is the playback buffer address.
char far * far ReportVDO(int far *width,int far *height);

// Sets the address of the background screen we are playing back video
// on top of.  MUST absolutly MUST be a 320x200 VGA graphics screen on a
// paragraph boundary!
void far SetBackgroundScreen(char far *screen);

int far ChangePal(char far *fname,char far *newpal);

