    DECLARE SUB PrintDoc (FileName$)

SUB PrintDoc (FileName$)

    OPEN FileName$ FOR OUTPUT AS #1

    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1, "                         DayQuote  "
    PRINT #1,
    PRINT #1, "                       (c) 1994, 1995  Freeware Unlimited"
    PRINT #1,
    PRINT #1, "                       "
    PRINT #1,
    PRINT #1,
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT "Printing documentation to file:  "; FileName$
IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1, "                                    Contents"
    PRINT #1, "                   "
    PRINT #1,
    PRINT #1, "                    Introduction . . . . . . . . . . . . . 2"
    PRINT #1,
    PRINT #1, "                    Quote File Structure . . . . . . . . . 3"
    PRINT #1,
    PRINT #1, "                    Command Line Options . . . . . . . . . 5"
    PRINT #1,
    PRINT #1, "                    Result Messages  . . . . . . . . . . . 8"
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "                   "
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1, "               ͻ"
    PRINT #1, "                               He's dead, Jim.                  "
    PRINT #1, "                                                        - Bones "

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "               ͼ"
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    IF FileName$ <> "CON" THEN PRINT #1, "                                     Page 1"
    PRINT #1, ""
    PRINT #1, "   INTRODUCTION"
    PRINT #1, ""
    PRINT #1,
    PRINT #1,
    PRINT #1, "     What DayQuote Is:"
    PRINT #1,
    PRINT #1, "        It is, to be perfectly honest, the first real program I have"
    PRINT #1, "        written, and there might exist on some plane programmers who are"
    PRINT #1, "        self-important enough to say that even this isn't a real program."
    PRINT #1,
    PRINT #1, "        Nevertheless, I think you will enjoy it, and its many options."
    PRINT #1, "        Those hypothetical programmers I mentioned earlier might even"

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "        take a second glance at its versatile command line options."
    PRINT #1,
    PRINT #1, "        All of those options are described below, in their totality."
    PRINT #1, "        The text is concise; hence, it might be 'thick' in some places."
    PRINT #1, "        Please, though, if you feel justified in your critique of my"
    PRINT #1, "        writing - either in the English language or the BASIC language -"
    PRINT #1, "        then I would welcome your comments by snail mail."
    PRINT #1,
    PRINT #1,
    PRINT #1, "     How It Works:"
    PRINT #1,
    PRINT #1, "        It takes what you have typed in following its name on the command"
    PRINT #1, "        line and then acts on the information you have given to it."
    PRINT #1, "        Several things can take place from there, depending upon what"
    PRINT #1, "        you gave to it in the form of 'switches' on the command line."

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1, "        If it encounters '/?' anywhere, it will show the Help Screen,"
    PRINT #1, "        then return you to the command line.  If it encounters the '/D'"
    PRINT #1, "        switch, it will go into an exclusive process similar to the '/?'"
    PRINT #1, "        switch, except that it is more comprehensive in every respect."
    PRINT #1, "        See the section about Command Line Options for complete details"
    PRINT #1, "        on these options, as well as the following ones."
    PRINT #1,
    PRINT #1, "        Aside from those switches, there are nine other switches that"
    PRINT #1, "        you can use to fully customize the look of your quotes.  Two of"
    PRINT #1, "        those will control the color of the text frame displayed, and two "
    PRINT #1, "        others will determine how wide the frame will be.  One of them"
    PRINT #1, "        also allows you to place the frame starting at any line on your"
    PRINT #1, "        screen, and there is another switch that will clear the screen"
    PRINT #1, "        before doing so.  Finally, there are three switches to choose"

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "        from that will control how the text of the quote is justified"
    PRINT #1, "        within the frame; left- or right- or centered."
    PRINT #1,
    PRINT #1,
    PRINT #1, "     To Get More Information:"
    PRINT #1,
    PRINT #1, "        Type 'DAYQUOTE/$' on the command line and read about how you can"
    PRINT #1, "        get free money sent to you, and a whole bunch of other free stuff."
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1,
    PRINT #1,
    IF FileName$ <> "CON" THEN PRINT #1, "                                     Page 2"
    PRINT #1, ""
    PRINT #1, "   QUOTE FILE STRUCTURE"
    PRINT #1, ""
    PRINT #1,
    PRINT #1, "     Quote file basics:"
    PRINT #1,
    PRINT #1, "        What follows between the funky lines is a representative sample"
    PRINT #1, "        of a valid quote file."
    PRINT #1,
    PRINT #1, "        /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\"
    PRINT #1, "        | Four score and seven years ago...                            |"

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "        | ~~Abraham Lincoln                                            |"
    PRINT #1, "        |                                                              |"
    PRINT #1, "        | He's dead, Jim.                                              |"
    PRINT #1, "        | ~~Bones                                                      |"
    PRINT #1, "        |                                                              |"
    PRINT #1, "        \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/"
    PRINT #1,
    PRINT #1, "        The basic philosophy behind it is to try grouping each body of"
    PRINT #1, "        text as close as possible.  Each distinct quote must be separated"
    PRINT #1, "        by a minimum of two carriage returns (Enters), including the one"
    PRINT #1, "        at the end of the previous quote's line.  The picture again:"
    PRINT #1, "               "
    PRINT #1, "        /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\"
    PRINT #1, "        | Four score and seven years ago...                            |"
    PRINT #1, "        | ~~Abraham Lincoln   < carriage return 1        |"

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "        |   < carriage return 2        |"
    PRINT #1, "        | He's dead, Jim.                                              |"
    PRINT #1, "        | ~~Bones                                                      |"
    PRINT #1, "        |                                                              |"
    PRINT #1, "        \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/"
    PRINT #1,
    PRINT #1, "        If you slip up, though, and have, say, 42 carriage returns in there"
    PRINT #1, "        by pure accident, don't sweat it.  The program is fairly lax in"
    PRINT #1, "        searching for quotes, aside from the one hard rule listed above."
    PRINT #1,
    PRINT #1, "        It will ignore multiple spaces, as well as single carriage returns."
    PRINT #1, "        The text which is separated by at least two carriage returns is"
    PRINT #1, "        considered the body of one quote, and will become one string of"
    PRINT #1, "        text, each word separated by one space, that will be displayed"
    PRINT #1, "        in accordance with any specified parameters, no matter how many"

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "        spaces are embedded within the quote.  You could have 113 spaces"
    PRINT #1, "        between just two words, and the quote will display as two words"
    PRINT #1, "        separated by a single space.  The rationale for this flexibility"
    PRINT #1, "        is that sometimes we don't realize there are a whole bunch of"
    PRINT #1, "        extra spaces at the end of a line, because we can't really SEE"
    PRINT #1, "        them, so it just makes the program more forgiving of our own"
    PRINT #1, "        imperfections."
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    IF FileName$ <> "CON" THEN PRINT #1, "                                     Page 3"
    PRINT #1, "     Creating your own quote file:"
    PRINT #1,
    PRINT #1, "        The best way to make a quote file is to use a 'text editor' or"
    PRINT #1, "        a 'word processor'.  If you use a word processor, make sure when"
    PRINT #1, "        you save the file that you are saving it in 'pure ASCII', which"
    PRINT #1, "        will mean unformatted text only, otherwise, you are apt to have"
    PRINT #1, "        some very strange-looking quotes appearing on your screen, since"
    PRINT #1, "        the word processor formatting codes that get added to the text"
    PRINT #1, "        will probably not comply very much with the two-return rule."

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1, "        It is best to just type the text in as you want it to read.  Again,"
    PRINT #1, "        how the text looks in the file will be irrelevant to how it is"
    PRINT #1, "        displayed.  All display aspects are controlled by the optional"
    PRINT #1, "        command line switches, and all of those switches have defaults,"
    PRINT #1, "        so you need not worry about the display aspects until later on,"
    PRINT #1, "        when you are more familiar with the program's operation."
    PRINT #1,
    PRINT #1, "        One worthy note here is that all quotes will be displayed in a"
    PRINT #1, "        bordered rectangle, therefore it is not necessary to include"
    PRINT #1, "        quotation characters in your quote file, unless you prefer the"
    PRINT #1, "        look of them.  (Future releases will allow custom frame borders.)"
    PRINT #1,
    PRINT #1, "        This documentation file was created originally by me using the"
    PRINT #1, "        MS-DOS Editor, an easy-to use, standard ASCII text editor, and"

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "        it looked exactly as you see it now.  If you wanted to, you could"
    PRINT #1, "        try using this documentation file as your test quote file.  Each"
    PRINT #1, "        paragraph, since they are all separated by two carriage returns,"
    PRINT #1, "        would be considered a single quote.  If you do this, though, be"
    PRINT #1, "        advised that you might get the 'Attempt to read a binary file...'"
    PRINT #1, "        message, due to the form-feed characters embedded in the text."
    PRINT #1, "        See the Result Messages section for more details on errors."
    PRINT #1,
    PRINT #1,
    PRINT #1, "     'Attributed' quotes:"
    PRINT #1,
    PRINT #1, "        Back to the drawing board:"
    PRINT #1,
    PRINT #1, "                               /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\"
    PRINT #1, "         Quote > | Four score and seven years ago...  |"

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "        'Attribution' > | ~~Abraham Lincoln                  |"
    PRINT #1, "                               |                                    |"
    PRINT #1, "                               \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/"
    PRINT #1,
    PRINT #1, "        As you can see, an attribution is the name of the person to whom"
    PRINT #1, "        the quote is attributed.  When DayQuote encounters the attribution"
    PRINT #1, "        code, '~~', it stops reading the quote, and makes whatever"
    PRINT #1, "        follows into the attribution.  Upon display, the attribution will"
    PRINT #1, "        appear to the right side of the quote frame, preceded by a dash"
    PRINT #1, "        and a single space, like this:"
    PRINT #1,
    PRINT #1, "             ͻ"
    PRINT #1, "              Four score and seven years ago...                 "
    PRINT #1, "                                              - Abraham Lincoln "
    PRINT #1, "             ͼ"

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1, "        If what follows the attribution code is too long to fit in the"
    PRINT #1, "        frame, then the remaining text will be truncated.  This shouldn't"
    PRINT #1, "        be a problem, though, if the attribution is just a name."
    PRINT #1,
    PRINT #1,
    PRINT #1,
    IF FileName$ <> "CON" THEN PRINT #1, "                                     Page 4"
    PRINT #1, ""
    PRINT #1, "   COMMAND LINE OPTIONS"
    PRINT #1, ""
    PRINT #1,
    PRINT #1, "       Ŀ"
    PRINT #1, "        DayQuote 1.0    Copyright 1994, 1995 by Freeware Unlimited. "
    PRINT #1, "       Ĵ"

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "        Usage: DAYQUOTE [switches] quotefil.ext                      "
    PRINT #1, "                                                                     "
    PRINT #1, "         Switches:                                                   "
    PRINT #1, "          /?     - Shows this help screen.                           "
    PRINT #1, "          /F:c   - Use foreground color 'c', as listed below.        "
    PRINT #1, "          /B:c   - Use background color 'c', as listed below.        "
    PRINT #1, "          /L     - Left-justify the text.                            "
    PRINT #1, "          /R     - Right-justify the text.                           "
    PRINT #1, "          /C     - Center the text.                                  "
    PRINT #1, "          /S:#   - Start at specified column # (1-30). Default = 10  "
    PRINT #1, "          /E:#   - End at specified column # (50-80).  Default = 70  "
    PRINT #1, "          /T:#   - Top line # to begin on (1-24). Default = current  "
    PRINT #1, "          /W     - Wipe (clear) the screen before displaying.        "
    PRINT #1, "          /D[:n] - Create documentation file, DAYQUOTE.DOC, or 'n'.  "
    PRINT #1, "          /$     - Get money sent to you.                            "

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "                                                                     "
    PRINT #1, "           Available foreground colors and background colors are:    "
    PRINT #1, "                                                                     "
    PRINT #1, "         BLACK, BLUE, GREEN, CYAN, RED, MAGENTA, BROWN, WHITE, GRAY  "
    PRINT #1, "         LTBLUE, LTGREEN, LTCYAN, LTRED, LTMAGENTA, YELLOW, BRWHITE  "
    PRINT #1, "       "
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1, ""
    PRINT #1, "   EXTENDED OPTION DESCRIPTIONS"
    PRINT #1, ""
    PRINT #1,
    PRINT #1, "     Color switches:"
    PRINT #1, "        "

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "      /F:color  - Sets foreground color.  Default color is white."
    PRINT #1, "      /B:color  - Sets background color.  Default color is black."
    PRINT #1, "      "
    PRINT #1, "        Use these switches to specify foreground and background colors"
    PRINT #1, "        to use when displaying a quote.  'Color' represents one of the"
    PRINT #1, "        following colors or abbreviations:"
    PRINT #1,
    PRINT #1, "            Ŀ"
    PRINT #1, "                 color  =  abbr.             color   =  abbr.  "
    PRINT #1, "            Ĵ"
    PRINT #1, "                 BLACK  =  BLK         GRAY or GREY  =  GRY    "
    PRINT #1, "                  BLUE  =  BLU               LTBLUE  =  LBL    "
    PRINT #1, "                 GREEN  =  GRN              LTGREEN  =  LGR    "
    PRINT #1, "                  CYAN  =  CYA               LTCYAN  =  LCY    "
    PRINT #1, "                   RED  =  RED                LTRED  =  LRD    "

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "               MAGENTA  =  MAG            LTMAGENTA  =  LMG    "
    PRINT #1, "                 BROWN  =  BRN               YELLOW  =  YEL    "
    PRINT #1, "                 WHITE  =  WHT              BRWHITE  =  BRW    "
    PRINT #1, "            "
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    IF FileName$ <> "CON" THEN PRINT #1, "                                     Page 5"
    PRINT #1, "     Text justification switches:"
    PRINT #1,
    PRINT #1, "      /L  - Sets displayed text as left-justified.  This is the default."
    PRINT #1, "      /R  - Sets displayed text as right-justified"
    PRINT #1, "      /C  - Sets displayed text as centered."

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1, "        Use one of these switches to have the quote text display in a way"
    PRINT #1, "        that you prefer.  One note on this switch: an 'attributed' quote"
    PRINT #1, "        (see the section about Quote File Structure) will always have"
    PRINT #1, "        it's attribution displayed on the last line, right-justified."
    PRINT #1, "        The text body of the quote, however, will display as you set it."
    PRINT #1,
    PRINT #1,
    PRINT #1, "     Starting column switch:"
    PRINT #1,
    PRINT #1, "      /S:#  - Sets the starting column as the number specified."
    PRINT #1,
    PRINT #1, "        Use this switch, along with the /E switch, to customize the"
    PRINT #1, "        displayed quote to suit your tastes.  Valid values for this"
    PRINT #1, "        switch range from 1 to 30, inclusive."

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1, "        The default starting column is column 10."
    PRINT #1,
    PRINT #1,
    PRINT #1, "     Ending column switch:"
    PRINT #1,
    PRINT #1, "      /E:#  - Sets the ending column as the number specified."
    PRINT #1,
    PRINT #1, "        Use this switch, along with the /S switch, to customize the"
    PRINT #1, "        displayed quote to suit your tastes.  Valid values for this"
    PRINT #1, "        switch range from 50 to 80, inclusive."
    PRINT #1,
    PRINT #1, "        The default ending column is column 70."
    PRINT #1,
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "     Top line switch:"
    PRINT #1,
    PRINT #1, "      /T:#  - Sets the top line as the line number specified."
    PRINT #1,
    PRINT #1, "        Use this switch to further customize the look of the displayed"
    PRINT #1, "        quote to suit your tastes.  Valid values for this switch range"
    PRINT #1, "        from 1 to 24, inclusive."
    PRINT #1,
    PRINT #1, "        The default top line is the line number before execution, plus 2."
    PRINT #1,
    PRINT #1,
    PRINT #1, "     Clear screen switch:"
    PRINT #1,
    PRINT #1, "      /W  - Wipes (clears) the screen before displaying a quote."
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "        Use this switch, along with the /T switch, to further enhance"
    PRINT #1, "        the visual quality of the displayed quote."
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    IF FileName$ <> "CON" THEN PRINT #1, "                                     Page 6"
    PRINT #1, "     Create Documentation switch:"
    PRINT #1,
    PRINT #1, "      /D[:n]  - Creates this documentation file."

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1, "        Use this switch to create this documentation file at any time."
    PRINT #1, "        You may also specify the name of the file by following the switch"
    PRINT #1, "        with a colon and then the name you want to give the file, otherwise"
    PRINT #1, "        the file created will be named, DAYQUOTE.DOC."
    PRINT #1,
    PRINT #1, "        This switch can also be used to create printed documentation by"
    PRINT #1, "        specifying a printer device as the file name, such as PRN or LPT1,"
    PRINT #1, "        or it can be used to quickly browse the documentation by using"
    PRINT #1, "        the 'CON' device, pressing the 'Pause' key to pause the scrolling."
    PRINT #1,
    PRINT #1, "        To accomplish the latter, enter:  DAYQUOTE /D:CON"
    PRINT #1,
    PRINT #1,
    PRINT #1, "     Beg switch:"

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1, "      /$  - Begs you for money."
    PRINT #1,
    PRINT #1, "        Use this switch to get the address of Freeware Unlimited from"
    PRINT #1, "        the command line so you can send me large amounts of cash, if"
    PRINT #1, "        you feel generous."
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    IF FileName$ <> "CON" THEN PRINT #1, "                                     Page 7"
    PRINT #1, ""

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "   RESULT MESSAGES"
    PRINT #1, ""
    PRINT #1,
    PRINT #1, "     Command-line errors:"
    PRINT #1,
    PRINT #1, "       Quote file not specified."
    PRINT #1,
    PRINT #1, "          You have not specified a file name to look for quotes in."
    PRINT #1, "          This is the only required parameter for the program to be"
    PRINT #1, "          able to correctly display a quote."
    PRINT #1,
    PRINT #1, "          This message, as well as with any other command line errors,"
    PRINT #1, "          will be followed by the message:  Type 'DAYQUOTE /?' for help."
    PRINT #1,
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "       Quote file can not be a reserved device name"
    PRINT #1,
    PRINT #1, "          You have specified a quote file with the name of a reserved"
    PRINT #1, "          device."
    PRINT #1,
    PRINT #1, "          Reserved devices are CON, AUX, PRN, CLOCK$, COM1, COM2, COM3,"
    PRINT #1, "          COM4, LPT1, LPT2, and LPT3."
    PRINT #1,
    PRINT #1, "          This result message will also show the device you specified."
    PRINT #1,
    PRINT #1,
    PRINT #1, "       Invalid switch"
    PRINT #1,
    PRINT #1, "          You have entered an invalid switch on the command line.  Any"
    PRINT #1, "          text on the command line that is preceded by the forward"

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "          slash character (/), up to but not including the next slash"
    PRINT #1, "          character or the next whitespace character, is considered"
    PRINT #1, "          to be a switch."
    PRINT #1,
    PRINT #1, "          This result message will also show the incorrect switch used."
    PRINT #1,
    PRINT #1,
    PRINT #1, "       Missing colon in switch"
    PRINT #1,
    PRINT #1, "          You have specified a switch which requires a second parameter"
    PRINT #1, "          in the form of (switch):(parameter), but you left out the"
    PRINT #1, "          colon character immediately following the switch."
    PRINT #1,
    PRINT #1, "          This result message will also show the incorrect switch used."
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1, "       Invalid foreground specification"
    PRINT #1,
    PRINT #1, "       Invalid background specification"
    PRINT #1,
    PRINT #1, "          You have specified an invalid display color.  See the section"
    PRINT #1, "          containing Extended Option Descriptions for the complete list"
    PRINT #1, "          of available colors and their abbreviations."
    PRINT #1,
    PRINT #1, "          These result messages will also show the color you specified."
    PRINT #1,
    PRINT #1, "          If not specified, the foreground color will be white, and the"
    PRINT #1, "          background color will be black."
    PRINT #1,
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    IF FileName$ <> "CON" THEN PRINT #1, "                                     Page 8"
    PRINT #1, "       Multiple text justifications are not allowed"
    PRINT #1,
    PRINT #1, "          You have included too many text justification switches on the"
    PRINT #1, "          command line.  Only one of the switches, /L /R or /C, may be"
    PRINT #1, "          used at a time."
    PRINT #1,
    PRINT #1, "          Using two or more on the command line generates an error to"
    PRINT #1, "          avoid having the program ignore subsequent justification"
    PRINT #1, "          switches after reading the first one - a technique which"
    PRINT #1, "          can only lead to further confusion."
    PRINT #1,
    PRINT #1, "          Text will be left-justified if one of these switches is not used."
    PRINT #1,
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "       Invalid starting column"
    PRINT #1,
    PRINT #1, "          You have specified an invalid starting column at which to"
    PRINT #1, "          begin displaying each line of the quote.  Valid values for"
    PRINT #1, "          this switch are in the range of 1 to 30, inclusive."
    PRINT #1,
    PRINT #1, "          This result message will also show the column you specified."
    PRINT #1,
    PRINT #1, "          The starting column will be 10 if this switch is not used."
    PRINT #1,
    PRINT #1,
    PRINT #1, "       Invalid ending column"
    PRINT #1,
    PRINT #1, "          You have specified an invalid ending column at which to stop"
    PRINT #1, "          displaying each line of the quote.  Valid values for this"

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "          switch are in the range of 50 to 80, inclusive."
    PRINT #1,
    PRINT #1, "          This result message will also show the column you specified."
    PRINT #1,
    PRINT #1, "          The ending column will be 70 if this switch is not used."
    PRINT #1,
    PRINT #1,
    PRINT #1, "       Invalid top line"
    PRINT #1,
    PRINT #1, "          You have specified an invalid top line at which to begin"
    PRINT #1, "          displaying the quote.  Valid values for this switch are in"
    PRINT #1, "          the range of 1 to 24, inclusive."
    PRINT #1,
    PRINT #1, "          This result message will also show the line you specified."
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "          The top line will be the line number before execution,"
    PRINT #1, "          plus 2, if this switch is not used."
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1,
    IF FileName$ <> "CON" THEN PRINT #1, "                                     Page 9"
    PRINT #1, "     File errors:"
    PRINT #1,
    PRINT #1, "       Bad file name:  (filename)"
    PRINT #1,
    PRINT #1, "          You specified an invalid file name as the quote file."
    PRINT #1,
    PRINT #1,
    PRINT #1, "       Drive not ready looking for quote file:  (filename)"
    PRINT #1,
    PRINT #1, "          You attempted to read a quote file on a drive that either had"
    PRINT #1, "          no disk present, or which had it's door open."
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1, "       Unsupported disk format encountered looking for file:  (filename)"
    PRINT #1,
    PRINT #1, "          The disk you are attempting to read from is of an unrecognized"
    PRINT #1, "          format, or may be unformatted altogether."
    PRINT #1,
    PRINT #1,
    PRINT #1, "       Path not found looking for quote file:  (filename)"
    PRINT #1,
    PRINT #1, "          You specified a path or a file name which could not be found."
    PRINT #1,
    PRINT #1,
    PRINT #1, "       Problem looking for quote file:  (filename)"
    PRINT #1,
    PRINT #1, "          The file name you specified does not exist."

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1,
    PRINT #1, "       Attempt to read an empty file:  (filename)"
    PRINT #1,
    PRINT #1, "          You specified a file which was only a file name, containing no"
    PRINT #1, "          information.  Type 'DIR (filename)' on the command line to"
    PRINT #1, "          verify that the file is of zero length."
    PRINT #1,
    PRINT #1,
    PRINT #1, "       Attempt to read a binary file or non-text characters found in:"
    PRINT #1, "        (filename)"
    PRINT #1,
    PRINT #1, "          You specified a file that contains characters not found in"
    PRINT #1, "          text files.  The file is a binary file, or other non-ASCII"
    PRINT #1, "          file, or it contains undisplayable control characters, such"

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "          as vertical tabs or form feeds."
    PRINT #1,
    PRINT #1, "          This error will also report detailed information on the invalid"
    PRINT #1, "          characters found, as well as their location in the file.  The"
    PRINT #1, "          'reference block', as it will be called, will show the text"
    PRINT #1, "          block which starts about 100 bytes before the encountered"
    PRINT #1, "          binary character and which ends about 100 characters afterward."
    PRINT #1,
    PRINT #1,
    PRINT #1, "       No quotes found in file:  (filename)"
    PRINT #1,
    PRINT #1, "          The file name which was specified contains no text."
    PRINT #1,
    PRINT #1,
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    IF FileName$ <> "CON" THEN PRINT #1, "                                     Page 10"
    PRINT #1, "       File read error - Size of object in:  (filename)"
    PRINT #1, "        (filename) is possibly not a quote file."
    PRINT #1,
    PRINT #1, "          The specified quote file contains a block of text that is larger"
    PRINT #1, "          than the limit of 1670 characters.  This message might be the"
    PRINT #1, "          result of specifying a binary file or other non-quote text file."
    PRINT #1,
    PRINT #1,
    PRINT #1, "       Overflow reading file:  (filename)"
    PRINT #1, "        (filename) is too large."

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1, "          You have likely specified a binary file or other non-quote file."
    PRINT #1,
    PRINT #1,
    PRINT #1, "     Documentation printing messages:"
    PRINT #1,
    PRINT #1, "       Printing documentation to file:  (filename)"
    PRINT #1,
    PRINT #1, "          This message will display, followed by visibly incrementing dots,"
    PRINT #1, "          until the documentation file is finished being created."
    PRINT #1,
    PRINT #1,
    PRINT #1, "       Bad file name:  (filename)"
    PRINT #1,
    PRINT #1, "          You specified an invalid file name as the output file."

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1,
    PRINT #1, "       Drive not ready printing to file:  (filename)"
    PRINT #1,
    PRINT #1, "          The drive you attempted to print the file to was a drive which"
    PRINT #1, "          had no disk present, or which had it's door open."
    PRINT #1,
    PRINT #1,
    PRINT #1, "       Unsupported disk format encountered printing to file:  (filename)"
    PRINT #1,
    PRINT #1, "          The disk you are attempting to print to is of an unrecognized"
    PRINT #1, "          format, or may be unformatted altogether.  The disk has no"
    PRINT #1, "          file structures present within which to store the file."
    PRINT #1,
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "       Path not found printing to file:  (filename)"
    PRINT #1,
    PRINT #1, "          You specified a path which could not be found in which to create"
    PRINT #1, "          the requested file."
    PRINT #1,
    PRINT #1,
    PRINT #1, "       Printer is not responding at attempt to print file."
    PRINT #1,
    PRINT #1, "       (devicename) is not responding at attempt to print file."
    PRINT #1,
    PRINT #1, "       Device fault error printing to file:  (devicename)"
    PRINT #1,
    PRINT #1, "          You have used a device name which is not responding to the"
    PRINT #1, "          data being transmitted.  If 'PRN', then check to see that"
    PRINT #1, "          it is online, and that it is connected properly."

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    IF FileName$ <> "CON" THEN PRINT #1, "                                     Page 11"
    PRINT #1, "     Miscellaneous messages:"
    PRINT #1,
    PRINT #1, "       Quote text is too long to fit in the specified frame."
    PRINT #1,
    PRINT #1, "          The text of the quote, after formatting it for the screen, will"
    PRINT #1, "          exceed the screen height boundary, hence it can not be used."
    PRINT #1,
    PRINT #1, "          You can try adjusting the starting and ending columns if you"

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "          get this message, but since the choice of quote from the file"
    PRINT #1, "          is a random choice, there is no guarantee that the program"
    PRINT #1, "          will attempt to display the same quote.  If you have very long"
    PRINT #1, "          quotes in your quote file, you should probably not specify"
    PRINT #1, "          starting and ending columns with the /S: and /E: switches unless"
    PRINT #1, "          you use them make the region width wider than the default of"
    PRINT #1, "          61 columns."
    PRINT #1,
    PRINT #1, "          You can also try narrowing down the maximum quote width by"
    PRINT #1, "          creating a file containing only the longest quote, then, using"
    PRINT #1, "          that file as the quote file, trying different starting and ending"
    PRINT #1, "          columns until you no longer get this result message."
    PRINT #1,
    PRINT #1,
    PRINT #1, "       System error number #(nn) handling quote file:  (filename)"

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1, "          - (relevant error message) -"
    PRINT #1,
    PRINT #1, "       System error number #(nn) printing to file:  (filename)"
    PRINT #1, "        - (relevant error message) -"
    PRINT #1,
    PRINT #1, "       System error number #(nn) displaying quote from file:  (filename)"
    PRINT #1, "        - (relevant error message) -"
    PRINT #1,
    PRINT #1, "          An unforeseen error has occurred in the specified routine. The"
    PRINT #1, "          number, 'nn' is the equivalent BASIC error number, and the"
    PRINT #1, "          message is the known cause of it."
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,

IF FileName$ <> "CON" THEN PRINT ".";

    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    PRINT #1,
    IF FileName$ <> "CON" THEN PRINT #1, "                                     Page 12"; CHR$(26);

IF FileName$ <> "CON" THEN PRINT " Done."

    CLOSE #1

    SYSTEM

END SUB

