'--- WINCLIP.BAS - Windows Clipboard Functions from DOS.

'Written by Harry F. Harrison

DEFINT A-Z

DECLARE FUNCTION ClearClipboard% ()
DECLARE FUNCTION GetClipboardData$ ()
DECLARE FUNCTION GetClipboardDataSize% ()
DECLARE FUNCTION OpenClipboard% ()
DECLARE FUNCTION SetClipboardData% (Text$)
DECLARE SUB CloseClipboard ()

'$INCLUDE: 'QBX.BI'

CONST True = -1, False = 0
DIM SHARED Regs AS RegTypeX

'=== BEGIN DEMONSTRATION PORTION

IF LEN(ENVIRON$("windir")) = 0 THEN
  PRINT "Windows is not loaded!"
  END
END IF

IF NOT OpenClipboard% THEN
  PRINT "Unable to open the Windows Clipboard."
  END
END IF

Msg$ = "This is being passed through the Clipboard."
IF NOT SetClipboardData%(Msg$) THEN
  PRINT "Unable to send a message to the Clipboard."
END IF

CALL CloseClipboard             'close it for a moment
Dummy = OpenClipboard           'reopen to prove this works
NewMsg$ = GetClipboardData$     'get the message
CALL CloseClipboard             'close it for real this time
PRINT NewMsg$                   'and print the message

'=== END DEMONSTRATION PORTION

FUNCTION ClearClipboard%

  'This Function returns True (-1) if the Clipboard was cleared.
  'The clipboard must be opened first.

  Regs.AX = &H1702
  CALL InterruptX(&H2F, Regs, Regs)
  IF Regs.AX <> 0 THEN ClearClipboard% = True

END FUNCTION

SUB CloseClipboard

  'This routine closes the Windows Clipboard. It is essential
  'that your application closes the clipboard, or no other
  'application can get access to it.

  Regs.AX = &H1708
  CALL InterruptX(&H2F, Regs, Regs)

END SUB

FUNCTION GetClipboardData$

  'This routine gets the Windows clipboard text, and returns it
  'in a string. The Clipboard must be opened first before it can
  'be accessed.

  'Before you can get the data, you must know how large the data
  'is, to allocate space for it in a BASIC string.

  Length = GetClipboardDataSize%
  IF Length% > 0 THEN           'There is data, get it
    Temp$ = STRING$(Length, 0)  'Allocate the space in BASIC
    Regs.AX = &H1705            'Set the function number
    Regs.DX = 1                 'Set the data selector to Text
    Regs.BX = SADD(Temp$)       'Show where to put the data
    Regs.ES = SSEG(Temp$)       'Use VARSEG with QuickBASIC
    CALL InterruptX(&H2F, Regs, Regs)
    IF Regs.AX THEN             'If present it's null-terminated
      Length = INSTR(Temp$, CHR$(0))
      IF Length THEN            'Return with the data
	GetClipboardData$ = LEFT$(Temp$, Length)
      END IF
    END IF
  END IF

END FUNCTION

FUNCTION GetClipboardDataSize%

  'The clipboard stores text and graphics, so DX stores the data
  'selector. 1 = Text, 2 = Graphics. The length of the data is
  'returned in AX.

  Regs.AX = &H1704              'Get Clipboard Data Size
  Regs.DX = 1                   'We're considering Text
  CALL InterruptX(&H2F, Regs, Regs)
  GetClipboardDataSize% = Regs.AX

END FUNCTION

FUNCTION OpenClipboard%

  'This function opens the Clipboard for your VM (Virtual
  'Machine). Once you have opened the Clipboard, no other
  'application can access it.  You must close the clipboard
  'when you are finished, to allow other applications to
  'access it.

  Regs.AX = &H1701              'Open Clipboard service
  CALL InterruptX(&H2F, Regs, Regs)
  IF Regs.AX THEN OpenClipboard% = True

END FUNCTION

FUNCTION SetClipboardData% (Text$)

  IF LEN(Text$) THEN
    IF ClearClipboard% = True THEN
      Regs.AX = &H1703          'Set Clipboard Data
      Regs.DX = 1               'Set the data selector to Text
      Regs.CX = LEN(Text$)      'Specify the data length
      Regs.BX = SADD(Text$)     'Show where the data is located
      Regs.ES = SSEG(Text$)     'Use VARSEG with QuickBASIC
      CALL InterruptX(&H2F, Regs, Regs)
      IF Regs.AX THEN SetClipboardData% = True
    END IF
  END IF

END FUNCTION

