		TITLE	DATETIME.ASM
		
;Prints string with "START" or "STOP" and actual date/time to STDOUT

;Text can be added to START string by the program if entered on command tail
;Program output can be redirected to a text file. Can be used from a batch file
;Syntax: DATETIME [ text | +] | [-]
;        DATETIME -			"STOP  mm-dd-yyyy hh:mm:ss"           1
;        DATETIME +			"START mm-dd-yyyy hh:mm:ss"           2
;        DATETIME text			"START mm-dd-yyyy hh:mm:ss text"      3

;"Text" in above command can't contain the minus or plus sign, used by 1 and 2
;Text can be inserted by the batchfile using replaceble parameters %1 etc

;DATETIME can be used in AUTOEXEC.BAT to log bootup time of computer

;Written after reading "Challenge" PC/Computing september 1993 page 324

;Eric P. van Westendorp   Reigerslaan 22   2215 NN  Voorhout   The Netherlands

CODE		SEGMENT	'CODE'
		ASSUME  CS:CODE,DS:CODE,ES:CODE,SS:CODE
		.RADIX	16
		ORG	0100H

;Get actual date, move into string, US date format
BEGIN:		MOV	AH,2A			;Get date
		INT	21			;DOS
		SUB	CX,076C			;Subtract 1900 to get year
		CMP	CX,0064			;Below 100?
		JC	CENT_OK			;Yes, is 19..
		MOV	[CENTURY],"02"		;No, is 20..
		SUB	CX,0064			;Subtract 100 to get year
CENT_OK:	MOV	AX,CX			;Years in AX
		CALL	MAKE_ASCIIDEC		;Change into 2 ASCII digits
		MOV	[YEAR],AX		;Put into variable
		MOV	AL,DH			;Get month
		CALL	MAKE_ASCIIDEC		;Change into 2 ASCII digits
		MOV	[MONTH],AX		;Put into variable
		MOV	AL,DL			;Get day
		CALL	MAKE_ASCIIDEC		;Change into 2 ASCII digits
		MOV	[DAY],AX		;Put into variable
		
;Get actual time, move into string, military time format
		MOV	AH,2C			;Get time
		INT	21			;DOS
		PUSH	CX			;Save minutes
		MOV	AL,CH			;Get hours
		CALL	MAKE_ASCIIDEC		;Change into 2 ASCII digits
		MOV	[HOURS],AX		;Put into variable
		POP	AX			;AL=minutes
		CALL	MAKE_ASCIIDEC		;Change into 2 ASCII digits
		MOV	[MINUTES],AX		;Put into variable
		MOV	AL,DH			;Get seconds
		CALL	MAKE_ASCIIDEC		;Change into 2 ASCII digits
		MOV	[SECONDS],AX		;Put into variable

;Get characters in command tail, check max., react on + and -
		MOV	SI,0081			;Start command tail
		MOV	DI,OFFSET TEXT_STR	;To place characters in string
		XOR	CL,CL			;Character counter 0
NEXT_TBYTE:	LODSB				;Get a byte from command tail
		CMP	AL,0D			;End command tail?
		JZ	END_TAIL		;Yes
		CMP	AL,"+"			;A "+" here?
		JNZ	CHK_MINUS		;No, continue
		CALL	SHRT_TERMINATE		;Yes, restore DATETIME string
		JMP	START_SEC		;Go print "START .....
CHK_MINUS:	CMP	AL,"-"			;To print "STOP ..... ?
		JNZ	STOW_BYTE		;No use byte in text string
		CALL	SHRT_TERMINATE		;Yes, restore DATETIME string
		JMP	PRT_STR			;Go print default string
STOW_BYTE:	STOSB				;Use byte for text string
		INC	CL			;Count this byte for max. len
		CMP	CL,MAX_TEXTSTR		;At maximum length now?
		JZ	TERMINATE		;Yes, stop
		JMP	NEXT_TBYTE		;No get a next byte

;Check there was any text in command tail
END_TAIL:	OR	CL,CL			;Anything?
		JZ	PRT_STR			;No, go print STOP string
TERMINATE:	CALL	TXT_TERMINATE		;Yes, end string with 0A,0D,"$"
		
;Move "START" into string in place of "STOP "
START_SEC:	MOV	SI,OFFSET START		;"START"
		MOV	DI,OFFSET DATETIME	;String to change
		MOV	CX,START_LEN		;Number of characters to change
		REP	MOVSB
		
;Print string to STDOUT
PRT_STR:	MOV	AH,09			;Print $ terminated string
		MOV	DX,OFFSET DATETIME	;Offset string to print
		INT	21			;DOS

;Exit the program
DOS_EXIT:	MOV	AX,4C00			;Terminate program
		INT	21			;DOS

;Change value below 100 in AX into 2 ASCII decimal number digits
MAKE_ASCIIDEC:	XOR	AH,AH			;0
		MOV	CL,0A			;Divider
		DIV	CL			;AH=remainder, AL=quotient
		ADD	AX,"00"			;Make ASCII digits
		RET

;Terminate string with 0D,0A,"$"
SHRT_TERMINATE:	MOV	DI,OFFSET TEXT_STR	;Terminate short string
TXT_TERMINATE:	MOV	WORD PTR[DI],0A0D	;Behind text string
		MOV	BYTE PTR[DI+2],"$"
		RET

;To be moved in DATETIME string if + or other character(s) in command tail
START		DB	"START"
START_LEN	EQU	$ - OFFSET START

;String filled out by program with current date and time
DATETIME	DB	"STOP  "		;6
DAY		DW	"00"			;2	;Xchange DAY and MONTH
		DB	"-"			;1	; here
MONTH		DW	"00"			;2	;for US format
		DB	"-"			;1
CENTURY		DW	"91"			;2
YEAR		DW	"00"			;2
		DB	" "			;1
HOURS		DW	"00"			;2
		DB	":"			;1
MINUTES		DW	"00"			;2
		DB	":"			;1
SECONDS		DW	"00"			;2
		DB	"  "			;2
		
DATETIME_LEN	EQU	$ - OFFSET DATETIME	;27
MAX_TEXTSTR	EQU	4F - DATETIME_LEN 	;79-27=52 Max len string used

TEXT_STR	DW	0D0A			;Write from here behind program
		DB	"$"			; text found in command tail

CODE		ENDS
		END	BEGIN
