		TITLE	ACTIVITY.ASM
		
;Creates .COM file

;Purpose to report program use to a logfile.
;ACTIVITY.COM reports program loading/terminating to a file "ACTIVITY.LOG" in
; rootdirectory of startup drive not being a floppy drive.
;ACTIVITY.COM catches running of DOS programs under WINDOWS too.
;
;Minimum MS-DOS 5.0 is required.
;ACTIVITY.COM will not install if less than 1 Mb space on drive is available.
;A message will be shown if not able to install.
;Logfile ACTIVITY.LOG may grow quite big in MODE 2 as each reported action
; increases the file by 30 or up to 160 bytes (Executing or termination).
;ACTIVITY.COM requires about 1300 bytes conventional or upper memory including
; the local stack of 256 bytes it uses.
;In case of an error writing to the logfile a beep is sounded.
;
;ACTIVITY.COM operates in 1 of 2 modes once loaded.
;Each mode writes as soon as certain action accurs a report to the logfile.
;This file is closed immediately after write. So even when the computer is
; rebooted while running a program the very last report is in the logfile.
;
; MODE 1. Reports "START  dd-mm-yyyy hh:mm:ss  " first time a program is
;          loaded to the logfile.
;	  Then changes to "STOP   dd-mm-yyyy hh:mm:ss  " for all further
;          reporting, either entry or exit of a program.
;         This last string is overwritten each next time. So between bootup
;          and switching off the computer only 2 reports are left in the file.
;         Each report is 30 bytes long including CR LF at end.
;
; MODE 2. Report each time a program is started or terminated this leaves many
;          report lines in the logfile. Each line is 30 or up to 160 bytes long
;          depending on length of PATH to the program file and command tail.
;         Format report "START  dd-mm-yyyy hh:mm:ss  programname commandtail"
;          when starting a program, this changes into
;                                "STOP   dd-mm-yyyy hh:mm:ss  " upon terminate
;         If INT 21 function 4B00 reports an error by setting CF then second
;          format is changed into "FAIL x dd-mm-yyyy hh:mm:ss  " where x is
;          the errornumber.
;
;Syntax: INSTALL[HIGH]=[path]ACTIVITY.COM [/M] [/H] [/Q] like
; INSTALLHIGH=C:\STARTUP\ACTIVITY.COM which reports first program and last
; program entry/exit to nonhidden ACTIVITY.LOG in root startup drive.
; Succesfull installation will be reported                            MODE 1
;ACTIVITY.COM can also be used from AUTOEXEC.BAT or DOS prompt like
; [path]ACTIVITY [/M] [/H] [/Q] 
;
;By using /M on command line, each time a program is executed or terminated
; a report is made to ACTIVITY.LOG.                                   MODE 2
;
;ACTIVITY.LOG may be made into a hidden file by using /H on command line.
;This file is a normal ASCII text file. It can be viewed by the TYPE command
; or by using an editor. Remove hidden attribute by running ACTIVITY.COM
; another time without /H.
;This works also if ACTIVITY.SYS, see below, has been installed.
;
;By using /Q in command line succesfull installation not reported, failure is.
;
;ACTIVITY.COM is a response to "Challenge" in PC/Computing september 1993.
;A reader liked to record each time the computer started up (MODE 1) and the
; magazine added the possibility to record program activity. (MODE 2)
;ACTIVITY.COM is intended to be used in the environment suggested, a
; standalone computer.
;
;The request was for a batch file or DEBUG script file solution.
;Of course it is possible to echo info from a batchfile, that is going to run
; the application, to a file before and after execution of the application.
;Supply program name from command line, date and time info from a .COM or .EXE
; program or even from the date and time commands.
;See DATETIME.COM for this
;
;ACTIVITY is a more clean solution, using memory however.
;Parallel with ACTIVITY.COM is ACTIVITY.SYS using almost the same program code
; and using the same syntax. This program installs from CONFIG.SYS only.
;
;Reason to use a .COM program instead of device driver may be more flexebility
; when to load the program.
;
;ACTIVITY.COM is assembled by using MS MASM 6.0,
;ML /AT ACTIVITY.ASM
;
;Program intentionally written in a simple style to maintain readability.
;
;Eric P. van Westendorp    Reigerslaan 22    2215 NN Voorhout    Netherlands
;
_TEXT           SEGMENT	'CODE'
                ORG     0100H
		.RADIX	10H
		ASSUME	DS:_TEXT

;During reporting of program load or terminate a seperate stack is used to
; assure no stack overflow occurs when saving all registers and using INT 21
; file functions, a 256 byte stack is used. (Resident code moved A0 bytes down)
STACKTOP	EQU	OFFSET INSTALL+0060	;Top stack during reporting

ACTIVITY	PROC	FAR
		JMP	INSTALL			;Install resident code

;------------------------------------------------------------------------------
;INT 21 is rerouted here, check INT 21 function 4B has been asked for.
;Function 4B is LOADEXEC a function with at least 5 subfunctions, these are
; used to load and execute programs and overlays or set execution state.
;Mostly subfunction 00 is used to load and execute a program.
;If NOT function 4B00 let INT 21 ISR do the job by doing a FAR JMP to it
;If it is INT 21 function 4B00 then it is the intention to load and execute
; a program. Caller either COMMAND.COM or application has checked everything is
; allright to do so before. I think it is safe to let DOS do a few jobs before
; launching the program and after termination of the program with a FAR CALL to
; the ISR in between.
;Care is taken of not changing register values and not causing stack overflow.
;A possible error condition returned by function 4B00 is returned to caller. 
RESIDENT	PROC	FAR			;Start resident code
INT21_HANDLER	PROC	FAR			;Start INT 21 handler
;Check this INT 21 is a LOADEXEC request or another function request
		MOV	CS:[JMPORCALL],0EA	;Assume not, FAR JMP needed
		PUSHF				;Save flags
		CMP	AX,4B00			;LOADEXEC subf. 00 request?
		JNZ	CONT_INT21		;No, do a FAR JMP to routine

;It is a request for LOADEXEC, do record this in ACTIVITY.LOG
		MOV	CS:[RECORD_CALL],00	;Indicate first call
		CALL	DO_RECORD

;Change instruction into FAR CALL
		MOV	CS:[JMPORCALL],9A	;Change into FAR CALL

;Set up for and execute FAR CALL
		POPF				;Get original flags
		PUSHF				;IRET gets flags
		JMP	DO_FARCALL		;Do FAR CALL to routine
		
CONT_INT21:	POPF
DO_FARCALL:
JMPORCALL	DB	0EA			;JMP FAR or CALL FAR here
INT21_OFS	DW	0000			;INT 21 offset
INT21_SEG	DW	0000			; and segment

;Returned here from FAR CALL to LOADEXEC handler with FLAGS and registers
; having valuable contents. Original caller is expecting these values
;Like to be sure original caller receives FLAGS value unchanged
;Posible error value in AX saved by program, as is "Extended error" status
BACK_FROM4B:	PUSHF				;Copy of FLAGS for DO_RECORD
		PUSH	BP			;Save register
		MOV	BP,SP			;BP points last pushed BP
		PUSHF

;On top of stack are now FLAGS,BP pushed here and IP,CS,FLAGS pushed by INT 21
;Change now flags value on STACK into new value returned from LOADEXEC handler
		POP	[BP+08]			;Change FLAGS on STACK
		POP	BP			;Restore
		POPF				;Get returned FLAGS
		MOV	CS:[RECORD_CALL],0FF	;Indicate second call
		CALL	DO_RECORD
		IRET				;Return to caller
INT21_HANDLER	ENDP
;------------------------------------------------------------------------------
;If INT 21 AH=4B LOADEXEC executed programname pointer here
PROGR_OFS	DW	0000			; ASCIIZ programname
PROGR_SEG	DW	0000

;If INT 21 AH=4B LOADEXEC executed command tail pointer here
COMTAIL_OFS	DW	0000
COMTAIL_SEG	DW	0000

;SS:SP of stack used by DOS when going to serve the INT 21 function 4B00
DOSSTACK_OFS	DW	0000
DOSSTACK_SEG	DW	0000

;Segment value used to address data by resident program
OWN_SEG		DW	0000			;Segment intercept handler

;If INT 21 AX=4B00 returns with error, values obtained by INT 21 AH=59 
; "Get extended error" saved here to be available after program actions
;Values by INT 21 AX=5D0A "Set extended error" to be available to caller
ERR_AX		DW	0000
ERR_BX		DW	0000
ERR_CX		DW	0000
ERR_DX		DW	0000
ERR_SI		DW	0000
ERR_DI		DW	0000
ERR_DS		DW	0000
ERR_ES		DW	0000
ERR_RES		DW	0000
ERR_UID		DW	0000
ERR_PID		DW	0000

;ASCIIZ name of log file, in rootdirectory of boot drive
PATH_NAME	DB	"C:\ACTIVITY.LOG",00	;Program inserts drive letter

;Status of write file operations
FILE_ERROR	DB	00			;If FF write error occurred

;First call to DO_RECORD 00 or second call FF
RECORD_CALL	DB	00

;Show default only when first time a program executed and last time a program
; executed or terminated. If /M used 00 then all execute and terminate shown
MANY_FLAG	DB	0FF		;Default show only 2 rows

;Used to do an action only once, used when ACTIVITY is in default mode 1
ONCE_COUNTER	DB	00		;Changes string into second format
ONCE_COUNTER2	DB	00		;If FF second string overwritten

;Normally pointer in file is set at end data, if default MODE 1 after writing
; second string each time the pointer is set a string length before end this
; causes overwrite of this string each next time (Updates second report line)
POINTER_OFSLO	SWORD	0000		;If overwrite this is a negative
POINTER_OFSHI	DW	0000		; number to cause pointer move forward

;Headers to be moved into string that will be written to logfile
;The used one will depend on MODE, first or second report or failure
START		DB	"START "

;At first in MODE 1 "START" is used all next times "STOP  "
;In MODE 2 each call for function 4B00 reports START each termination STOP
STOP		DB	"STOP  "

;If second call to DO_RECORD and INT 21 function 4B reports error report "FAIL"
; followed by error number 1-B hex This only in MODE 2 using /M
FAIL		DB	"FAIL 0"

;Length of START, STOP and FAIL strings
HEAD_LEN	EQU	$-OFFSET FAIL

;Change this for other country formats
;String written to logfile after filled out with info
;MODE 1 uses only a short string 30 bytes, MODE 2 uses a long string the first
; call to DO_RECORD (up to 160 bytes) when the program name is reported too, 
; the second time the short string. 
;Length of the long string depends on length ASCII pathname and of command
; tail program executed.
LOG_STR		DB	"START  "		;7
DAY		DW	"00"			;2
		DB	"-"			;1	Dutch format
MONTH		DW	"00"			;2       CHANGE
		DB	"-"			;1
CENTURY		DW	"91"			;2
YEAR		DW	"00"			;2
						;Total 17
		DB	" "			;1
HOURS		DW	"00"			;2
		DB	":"			;1
MINUTES		DW	"00"			;2
		DB	":"			;1
SECONDS		DW	"00"			;2
		DB	"  "			;2
PROGR_NAME	DB	0D,0A			;2
						;Total 13 

;Calculation of string lengths, maximum 80 bytes of which 2 for 0A,0D
COPY2_LEN	EQU	$-OFFSET LOG_STR	;Total 30 for short message

PRGRNM_LEN	EQU	50 - COPY2_LEN 		;Length buffer for programname
		DB	PRGRNM_LEN  DUP(" ")	;50
						;Total 80
						
;If 80 bytes is not enough for reporting continue in next row, this may happen
; in MODE 2 with a long PATH and/or command tail First part string stays blank
RESERVE_STR	DB	COPY2_LEN-02 DUP(" ")	;Blank
RESERVE_START	DB	PRGRNM_LEN+02 DUP(" ")	;Can be used

;Variable used to store length string to write to logfile, calculated below
;Length ASCII program pathname and command tail added to this later
COPY_LEN	DW	COPY2_LEN		;Default a short message
;-----------------------------------------------------------------------------
DO_RECORD	PROC	NEAR
;Log activity to file INT 21 function 4B subfunction 00 Load and execute
;Set up own stack to do this in order to avoid stack overflow
		CLI				;Disable external interupts
		MOV	CS:[DOSSTACK_SEG],SS	;Store DOS SS:SP
		MOV	CS:[DOSSTACK_OFS],SP
		MOV	SS,CS:[OWN_SEG]		;Get installed segment in SS
		MOV	SP,STACKTOP		; and STACKTOP in SP
		STI				;Enable external interrupts
		PUSH	AX			;Save all used registers
		PUSH	BX
		PUSH	CX
		PUSH	DX
		PUSH	SI
		PUSH	DI
		PUSH	DS
		PUSH	ES

;Setup segment registers and direction flag sometimes found backward
;DS:DX --> ASCIIZ programname, ES:BX+02 --> Command tail upon first call
;CF=1 and AX=error if INT 21 AX=4B00 error occurred second call
		CLD				;Ensure forward
		MOV	CS:[PROGR_SEG],DS	;Save segment programname
		PUSH	CS			;Set to current segment
		POP	DS			; DS
		MOV	[PROGR_OFS],DX
		LES	BX,ES:DWORD PTR[BX+02]	;Get addres command tail
		MOV	[COMTAIL_SEG],ES	; and save it
		INC	BX			;Point behind tail count byte
		MOV	[COMTAIL_OFS],BX

;Investigate INT 21 function 4B00 returns with error during second call
		JNC	UPDATE_ACT		;No error
		CMP	WORD PTR[RECORD_CALL],00FF;Second call and mode 2
		JNZ	UPDATE_ACT		;No, disregard CF

;Save extended error info, avoids being destroyed by program actions
;Will be reset later to be available to caller of INT 21 AX=4B00 LOADEXEC
		PUSH	DS			;Save DS, changed by next
		
		MOV	AH,59			;Get extended error
		XOR	BX,BX
		INT	21
		MOV	CS:[ERR_DS],DS		;Save value DS
		POP	DS			;Restore DS
		MOV	[ERR_AX],AX		;Save to set later again
		MOV	[ERR_BX],BX		; after program INT 21 actions
		MOV	[ERR_CX],CX
		MOV	[ERR_DX],DX
		MOV	[ERR_SI],SI
		MOV	[ERR_DI],DI
		MOV	[ERR_ES],ES
		
;Report error situation, change "STOP " into "FAIL x" where xx is errorcode
; max 1-BH This reporting only done if MODE 2, /M used in command line
		ADD	AL,"0"			;Make value
		CMP	AL,"9"			; in
		JBE	HDIGIT_OK		; AL into
		ADD	AL,07			; ASCII HEX character
HDIGIT_OK:	MOV	SI,OFFSET FAIL		;Report failure
		MOV	[SI+05],AL		;Insert in FAIL message
		JMP	GET_LEN			;Go move FAIL message

;Update string written to log according action taken, START, STOP (or FAIL x)
UPDATE_ACT:	MOV	SI,OFFSET START		;Point to START.
		OR	[RECORD_CALL],00	;First call to DO_RECORD?
		JZ	GET_LEN			;Yes
		MOV	SI,OFFSET STOP
GET_LEN:	PUSH	CS			;Set to current segment
		POP	ES			; ES
		MOV	CX,HEAD_LEN		;Characters to move
		
;If MODE 1, not /M used, string shouldn't be overwritten the
; first time, all next times with "STOP " (not START or FAIL x)
CHECK_RECMODE:	OR	[MANY_FLAG],00		;MODE 1?
		JZ	DO_OVERWRITE		;No MODE 2, report all

;MODE 1 reports the first time upon second call to DO_RECORD, STOP etc
; next times upon every call to DO_RECORD this will be updated. 
;Check it is the first time default mode arrives here, then don't overwrite
CHECK_BEEN:	OR	[ONCE_COUNTER],00	;First time default mode?
		JNZ	MARK_SECOND 	   	;No a next time
MARK_FIRST:	MOV	[ONCE_COUNTER],0FF	;Yes, mark been here
		JMP	INSERT_DATE
MARK_SECOND:	MOV	[ONCE_COUNTER2],0FF	;Mark second time
ENTER_STOP:	MOV	SI,OFFSET STOP

;Overwrite start of LOG_STR with function info like START, STOP or FAIL x
DO_OVERWRITE:	MOV	DI,OFFSET LOG_STR	;String to be updated
		REP	MOVSB

;Get actual date, move into LOG_STR
INSERT_DATE:	MOV	AH,2A			;Get date
		INT	21			;DOS
		MOV	[CENTURY],"91"		;Assume 19..
		SUB	CX,076C			;Subtract 1900 to get year
		CMP	CX,0064			;Below 100?
		JC	CENT_OK			;Yes, is 19..
		MOV	WORD PTR[CENTURY],"02"	;No, is 20..
		SUB	CX,0064			;Subtract 100 to get year
CENT_OK:	MOV	AX,CX			;Years in AX
		CALL	AL2ASCIIDEC		;Change into 2 ASCII digits
		MOV	[YEAR],AX		;Put into variable
		MOV	AL,DH			;Get month
		CALL	AL2ASCIIDEC		;Change into 2 ASCII digits
		MOV	[MONTH],AX		;Put into variable
		MOV	AL,DL			;Get day
		CALL	AL2ASCIIDEC		;Change into 2 ASCII digits
		MOV	[DAY],AX		;Put into variable

;Get actual time, move into LOG_STR
INSERT_TIME:	MOV	AH,2C			;Get time
		INT	21			;DOS
		PUSH	CX			;Save minutes
		MOV	AL,CH			;Get hours
		CALL	AL2ASCIIDEC		;Change into 2 ASCII digits
		MOV	[HOURS],AX		;Put into variable
		POP	AX			;AL=minutes
		CALL	AL2ASCIIDEC		;Change into 2 ASCII digits
		MOV	[MINUTES],AX		;Put into variable
		MOV	AL,DH			;Get seconds
		CALL	AL2ASCIIDEC		;Change into 2 ASCII digits
		MOV	[SECONDS],AX		;Put into variable

;Get ASCIIZ pathname in report string if MODE 2 and first call to DO_RECORD
;and command tail as well
		OR	WORD PTR[RECORD_CALL],0000;Both variables 0?
		JNZ	CREATE_FILE		;Either or both not MODE 2
						; first call
;Pointer to ASCIIZ pathname was saved at start DO_RECORD get it in DS:SI
		LDS	SI,DWORD PTR[PROGR_OFS]	;Get programname
		
;Move name into string but not a longer name than buffer allows
		MOV	CX,PRGRNM_LEN		;Max length to be used
		PUSH	CX			;Use to calc used length
		MOV	DI,OFFSET PROGR_NAME	;Buffer for name

;Move bytes of programname into string to be saved to file
MOVE_NAME:	LODSB
		OR	AL,AL			;End ASCIIZ pathname
		JZ	MOVED_NAME		;Yes
		STOSB
		LOOP	MOVE_NAME
		
;Buffer not long enough for programe name, calc bytes used and start to use
; RESERVE_STR, check however first RESERVE_STR not in use already
		CALL	CHECK_RESSTR
		JC	MOVED_TAIL
		JMP	MOVE_NAME
		
;Move command tail too into string
;Pointer to command tail was saved at start DO_RECORD get it in DS:SI
MOVED_NAME:	LDS	SI,CS:DWORD PTR[COMTAIL_OFS];Get command tail

;Move bytes of command tail into string to be saved to file
MOVE_TAIL:	LODSB
		CMP	AL,0D			;End command tail?
		JZ	MOVED_TAIL		;Yes
		STOSB
		LOOP	MOVE_TAIL

;Buffer not long enough for command tail, check reserve string already in use
		CALL	CHECK_RESSTR
		JNC	MOVE_TAIL

;Terminate string with CR LF
MOVED_TAIL:	MOV	AX,0A0D
		STOSW				;Terminate row by CR LF
		PUSH	CS			;Restore DS
		POP	DS

;Calculate length of string to write to ACTIVITY.LOG in variable COPY_LEN
		POP	AX			;Possible max length name
		SUB	AX,CX			;Subtract not used positions
		ADD	[COPY_LEN],AX		;Get length to write
		
;Check ACTIVITY.LOG already exists if not create this file, get file handle
CREATE_FILE:	MOV	AH,5B			;Create new file
		XOR	CX,CX			;Normal attribute
		MOV	DX,OFFSET PATH_NAME	;ASCIIZ filename
		INT	21
		JNC	IS_OPEN			;File created and opened
		CMP	AX,0050			;Existed already?
		JZ	OPEN_FILE		;Yes, open it
		JMP	SOUND_BELL		;Error
		
;File existed already open it, get a file handle
OPEN_FILE:	MOV	AX,3D01			;Open file with handle, W
		MOV	DX,OFFSET PATH_NAME
		INT	21
		JC	SOUND_BELL		;File not open

;Store obtained file handle, from now on BX has handle
IS_OPEN:	MOV	BX,AX			;Store file handle in BX

;Check write to ACTIVITY.LOG should is to be in overwrite mode
		OR	[ONCE_COUNTER2],00	;In overwrite mode?
		JZ	MOVE_POINTER		;No, no problems here

;If MODE 1 and next string is going to overwrite last one file pointer is
; going to be moved forward. It is quite possible the pointer will be moved
; to a position ahead of the file if the user has deleted or changed the file.
;This should be avoided by checking the file contains at least COPY2_LEN bytes
;If not enough do not move pointer forward too much
		MOV	AX,4202			;Move pointer to end file
		XOR	CX,CX			;Offset 0 from end
		XOR	DX,DX
		INT	21
		JC	ERROR_FILE		;If fail close file
		OR	DX,DX			;Anything in hi word?
		JNZ	MOVE_POINTER		;Yes no problem
		OR	AX,AX			;Empty file?Can't move -0 bytes
		JZ	WRITE_STR		;Yes, no need to move pointer
		CMP	AX,COPY2_LEN		;File long enough?
		JAE	MOVE_POINTER		;Yes, no problem
		MOV	DX,AX			;No, shorter than COPY2_LEN
		NEG	DX			;Make negative, forward
		JMP	MOVE_POINTER2		;Move fewer bytes forward

;Move file pointer to end of data in order to write new string behind it or
; move pointer forward in order to overwrite last written string (MODE 1)
MOVE_POINTER:	MOV	DX,[POINTER_OFSLO]	;Lo offset 0 or from end file
MOVE_POINTER2:	MOV	CX,[POINTER_OFSHI]	;Hi offset 0
		MOV	AX,4202			;Move file pointer end of file
		INT	21
		JNC	WRITE_STR		;No error
ERROR_FILE:	MOV	[FILE_ERROR],0FF
		JMP	CLOSE_FILE		;If fail go close file

;Write string to file
WRITE_STR:	MOV	AH,40			;Write file or device
		MOV	CX,[COPY_LEN]		;Length to write
		MOV	DX,OFFSET LOG_STR	;String to write
		INT	21
		JC	ERROR_FILE		;Error writing

CHECK_WRITTEN:	CMP	[COPY_LEN],AX		;Write ok?
		JNZ	ERROR_FILE		;No not the same

;Close opened file
CLOSE_FILE:	MOV	AH,3E			;Close file with handle
		INT	21
		JC	SOUND_BELL		;Error

;Take care attribute of logfile is as requested normal or hidden /H
SET_ATTR:	MOV	AX,4301			;Set file attributes
		MOV	CX,[LOGFILE_ATTR]	;Normal or hidden attribute
		MOV	DX,OFFSET PATH_NAME	;ASCIIZ filename logfile
		INT	21			;Disregard errors

;Check any write error occurred
CHK_FERROR:	OR	[FILE_ERROR],00		;Any write errors?
		JZ	RESET_ERROR		;No do not ring bell

;Execute beep for error, using Write TTY
SOUND_BELL:	MOV	AX,0E07			;Sound beep if error
		INT	10

;Take care caller gets extented error INT 21 AX=4B00 when caller elects to use
; INT 21 AH=59 "Get extended error".  Clear error afterwards
;Problem use DX or SI in function 5D0A?. MS-DOS 5.0 Prgr Ref and PC Interrupts
RESET_ERROR:	CMP	[ERR_AX],0000		;Any extended error?
		JZ	CLEAR_FUNC		;No, continue
		MOV	AX,5D0A			;Set extended error
		MOV	DX,OFFSET ERR_AX	;Point to error struct
		MOV	SI,DX			;Unsure DX or SI????, use both
		INT	21
		MOV	WORD PTR[ERR_AX],0000	;Clear error for further use
		
;Clear variables to be used next time
CLEAR_FUNC:	MOV	WORD PTR[PROGR_NAME],0A0D;Terminates short message
		MOV	[COPY_LEN],COPY2_LEN	;Default length short message
		MOV	[FILE_ERROR],00		;Clear write error variable

;In MODE 1, this is /M not used, after second string is
; written set variable to overwrite second string all the time
		OR	[ONCE_COUNTER2],00	;A second time or later
		JZ	DORECORD_EXIT		;No
		MOV	[POINTER_OFSHI],0FFFF	;CX:DX negative number
		MOV	[POINTER_OFSLO],- COPY2_LEN ;Len short string forward

;Return to original interrupt
DORECORD_EXIT:	POP	ES			;Restore used registers
		POP	DS
		POP	DI
		POP	SI
		POP	DX
		POP	CX
		POP	BX
		POP	AX

;Restore to by DOS used stack and return to DOS 21 intercept handler
		CLI				;Disable external interupts
		MOV	SS,CS:[DOSSTACK_SEG]	;Restore DOS SS:SP
		MOV	SP,CS:[DOSSTACK_OFS]
		STI				;Enable external interrupts
		RET				;Exit to use if no more reports
DO_RECORD	ENDP
;------------------------------------------------------------------------------
AL2ASCIIDEC	PROC	NEAR
;Change value below 100 in AL into 2 ASCII decimal number digits
		XOR	AH,AH			;Assure 0
		MOV	BL,0A			;Divider
		DIV	BL			;AH=remainder, AL=quotient
		ADD	AX,3030			;Make ASCII digits
		RET
AL2ASCIIDEC	ENDP
;------------------------------------------------------------------------------
;Sets up for use of RESERVE_STR for use programname or command tail
;Check first if not in use yet
CHECK_RESSTR	PROC	NEAR
		CMP	DI,OFFSET RESERVE_START	;Into RESERVE_STR? already
		JC	STILL_FIRST		;No
		STC				;Yes, both buffers used
		JMP	CHKRESSTR_EXIT		;Go stop

;LOG_STR is full, terminate it, update char count, go use RESERVE_STR
STILL_FIRST:	MOV	AX,0A0D			;Terminate first string
		STOSW		
		ADD	CS:[COPY_LEN],50	;Count bytes to write
		MOV	CX,PRGRNM_LEN		;Load byte counter
		MOV	DI,OFFSET RESERVE_START	;Point at start posn
		CLC
CHKRESSTR_EXIT:	RET
CHECK_RESSTR	ENDP
;------------------------------------------------------------------------------
INT2F_HANDLER	PROC	FAR
;This handler is to avoid double installation and to change file attribute
; if called with saved multitiplex function number
;Handler responds with AL=FF and BX=IDENT if somebody is searching for a free
; function, subfunction AL=00, responds by changing logfile attribute into DX
; value if called by its saved function number but subfunction AL=01
		PUSHF				;Save flags
		CMP	AX,CS:[FUNC_2F]		;Somebody trying to install?
		JZ	SIGNAL_HERE		;Yes, tell ocupied and IDENT
		CMP	AX,CS:[FUNC_ATTR]	;ACTIVITY change attr logfile?
		JNZ	GO_OLDINT2F		;No, somebody else calling
		CMP	BX,IDENT		;Check IDENT to be sure
		JNZ	GO_OLDINT2F		;No definitly not ACTIVITY
		MOV	CS:[LOGFILE_ATTR],DX	;Change logfile attribute
SIGNAL_HERE:	MOV	BX,IDENT		;Yes send back ID and current
		MOV	AL,0FF			;Signal installed to caller
		POPF				; and flags
		IRET
		
GO_OLDINT2F:	POPF				;Continue with old flags
		DB	0EA			;JMP FAR continue
INT2F_OFS	DW	0000			;INT 2F offset
INT2F_SEG	DW	0000			; and segment
INT2F_HANDLER	ENDP
;------------------------------------------------------------------------------
FUNC_2F		DW	0000			;Saves INT 2F funct to monitor
FUNC_ATTR	DW	0001			; and function for attr change
IDENT		EQU	"EP"			;ID to identify caller

;If below var. is 0002 then ACTIVITY.LOG is a hidden file, default not hidden
LOGFILE_ATTR	DW	0000		;Default normal attribute

RESIDENT	ENDP
;******************************************************************************
;Install resident code, take appropiate action if fail
;Switch /H makes ACTIVITY.LOG into a hidden file
;Switch /Q disables install message
;
;Default if /M not used report only START and STOP messages	        MODE 1
;/M make report of LOADEXEC entry/EXIT actions to logfile	        MODE 2
;
;Point DS:BX to command tail,  find /H, /M and/or /A on command line
INSTALL		PROC	FAR
		MOV	BX,0081			;Start command tail
NEXT_CONFBYTE:	CMP	ES:BYTE PTR[BX],0D	;End of line?
		JZ	CHECK_DOSVER		;Yes
		CMP	BYTE PTR[BX],"/"	;Possible parameter?
		JNZ	GO_NEXT			;No
		AND	BYTE PTR[BX+01],0DF	;Into capital
		CMP	BYTE PTR[BX+01],"H"	;/H?
		JNZ	CHECK_MANY		;No
		MOV	[LOGFILE_ATTR],0002	;Use hidden ACTIVITY.LOG
CHECK_MANY:	CMP	BYTE PTR[BX+01],"M"	;To make many reports?
		JNZ	CHECK_QUIET
		MOV	[MANY_FLAG],00		;Do many reports
CHECK_QUIET:	CMP	BYTE PTR[BX+01],"Q"	;Disable install message?
		JNZ	GO_NEXT			;No
		MOV	[MESS_FLAG],0FF		;Yes disable install message
GO_NEXT:	INC	BX
		JMP	NEXT_CONFBYTE

;Check DOS version at least 5.0
;If not DOS 5.0 at least report, do not install resident code
CHECK_DOSVER:	MOV	AX,3306			;Get MS-DOS version
		XOR	BX,BX			;Ensure 0 before calling
		INT	21
		MOV	DX,OFFSET NOTDOS5_MESS
		CMP	BL,05
		JNB	CHK_INSTALLED
		JMP	ERROR_EXIT1
;Check installed already, if not use first free INT 2F function for handler.
;Search for a free multiplex function number, save the first free function.
;If multiplex interrupt responds with AL=FF the function is occupied. If 
; function is occupied and BX=IDENT then ACTIVITY is already installed.
;If not installed use first function found free for INT 2F handler to install
;If no free function number found exit program with message
;Function numbers available to programs C0 - FF, rest reserved by Microsoft
CHK_INSTALLED:	MOV	CX,00FF-00BF		;Nbr available functions INT 2F
		MOV	AX,0BF00		;First function to check - 1
NEXT_FUNC2F:	INC	AH			;Next function
		PUSH	AX			;Save function
		PUSH	CX			;And counter available funct
		INT	2F			;Execute multiplex interrupt
		CMP	AL,0FF			;Returns occupied?
		POP	CX			;Restore counter
		POP	AX			; and used function nbr
		JZ	CHECK_ID		;Yes, function is in use
		OR	AL,AL			;Check for non standard nbr
		JNZ	KEEP_LOOKING		;Was non standard response
		CMP	[FREEFUNC_2F],0000	;Already a free function stored
		JNZ	KEEP_LOOKING		;Yes saved first one already
		MOV	[FREEFUNC_2F],AX	;First free function, store
		JMP	KEEP_LOOKING		;Keep looking for ACTIVITY
CHECK_ID:	CMP	BX,IDENT		;Returned ID allright?
		JZ	ACT_FOUND		;Yes, found ACTIVITY resident
KEEP_LOOKING:	LOOP	NEXT_FUNC2F		;Look for free funcs + ACTIVITY

;ACTIVITY not found, go install, using first found free function number if any
		CMP	[FREEFUNC_2F],0000	;Any free function found?
		JZ	NO_FREE2F		;No, no free function stored
		MOV	AX,[FREEFUNC_2F]	;Yes, get free function nbr
		MOV	[FUNC_2F],AX		;Store in 2F handler for use
		MOV	BYTE PTR[FUNC_ATTR+01],AH;Make available subfunction 01
		JMP	GET_STARTDRV		; to be used if ACTIVITY tries
						; to install again
						
;No free function INT 2F found, do not install, exit with message
NO_FREE2F:	MOV	DX,OFFSET NO_FREE
		JMP	ERROR_EXIT1

;ACTIVITY already installed, AH still has function, BX has IDENT
;Go change file attribute into attribute requested in command tail if requested
ACT_FOUND:	INC	AL			;Subfunction change file attr
		MOV	DX,[LOGFILE_ATTR]	;Now used value
		INT	2F
		MOV	DX,OFFSET ALREADY	;Report already resident
		JMP	ERROR_EXIT2

;ACTIVITY was not yet installed
;Get startup drive, insert drive letter in ASCIIZ pathname logfile
;Assure driver is not installed from flop. Free space problem might happen! 
GET_STARTDRV:	MOV	AX,3305			;Get startup drive
		INT	21
		CMP	DL,03			;Drive C:?
		JAE	NOT_FLOP
		MOV	DX,OFFSET NOTFLOP_MESS
		JMP	ERROR_EXIT1		;A floppy drive
NOT_FLOP:	PUSH	DX			;Save drive number
		ADD	DL,40			;Into letter
		MOV	[PATH_NAME],DL		;Into ASCIIZ file name

;Get free space on drive, if less than 1 MB report and don't install driver
		MOV	AH,36			;Get disk free space
		POP	DX			;DL=drive
		INT	21
		MOV	DX,OFFSET DRV_MESS
		CMP	AX,0FFFF		;Drive valid?
		JNZ	CALC_FREE
		JMP	ERROR_EXIT1		;No
CALC_FREE:	SHR	AX,01			;Kb's/cluster assuming size > 1
		MOV	CL,0A
		SHR	BX,CL			;Divide by 1024
		MUL	BX			;DX:AX contains Mb's free
		OR	DX,DX			;0?
		JNZ	RELOCATE		;Yes, must be massive drive
		CMP	AX,0001
		MOV	DX,OFFSET FREE_MESS
		JB	ERROR_EXIT1		;Less than 1 Mb free

;Relocate resident code to 0060 in PSP, this saves 160 bytes
RELOCATE:	MOV	SI,OFFSET ACTIVITY	;Start resident code
		MOV	DI,0060			;In PSP
		MOV	CX,OFFSET INSTALL - OFFSET ACTIVITY;Bytes to move
		REP	MOVSB			;Move code 160 bytes forward

;Setup DS to reflect relocation of resident code in adressing data
		PUSH	DS			;Current data segment
		POP	AX			; in AX
		SUB	AX,000A			;Sutract segments moved forward
		PUSH	AX			;New value
		POP	DS			;Into DS

;Store segment to be used for location of DATA by handlers
		MOV	[OWN_SEG],DS		;Segment of handler
		
;Revector INT 2F to new handler, using new DS
REVECTOR:	MOV	AX,352F			;Revector INT 2F
		INT	21
		MOV	[INT2F_OFS],BX		;Get addres INT 2F
		MOV	[INT2F_SEG],ES		;into variables
		MOV	AX,252F			;Set to new handler
		MOV	DX,OFFSET INT2F_HANDLER	;DS:BX new address
		INT	21

;Revector INT 21 to new handler, using new DS
		MOV	AX,3521			;Revector INT 21
		INT	21
		MOV	[INT21_OFS],BX		;Get addres INT 21
		MOV	[INT21_SEG],ES		;into variables
		MOV	AX,2521			;Set to new handler
		MOV	DX,OFFSET INT21_HANDLER	;DS:BX new address
		INT	21

;Restore DS again to current segment
		PUSH	CS
		POP	DS

;Release environment
		MOV	AX,DS:[002C]		;Get segment environment
		MOV	ES,AX
		MOV	AH,49			;Free allocated memory
		INT	21			;Disregard errors

;Print message about succesfull installation if not disabled by /Q
		OR	[MESS_FLAG],00		;Enabled?
		JNZ	CALC_MEM		;No
		MOV	DX,OFFSET INSTALL_OK	;Yes print message
		CALL	PRT_STR

;Calculate memory requirement, STACKTOP reflects already new situation
CALC_MEM:	MOV	DX,STACKTOP+0F		;Offset end driver, stack + 15
		MOV	CL,04			;Divide by 16
		SHR	DX,CL			;Get length in para's to keep

;Exit to DOS, DX paragraphs staying resident
		MOV	AX,3100			;Keep program
		INT	21

;Do not install, either already installed or configuration wrong
ERROR_EXIT1:	CALL	PRT_STR
		MOV	DX,OFFSET INSTALL_FAIL	;Not installed
ERROR_EXIT2:	CALL	PRT_STR

;Exit and give all memory back to DOS
RELEASE:	MOV	AX,4CFF			;Terminate with errorlevel 255
		INT	21

PRT_STR		PROC	NEAR
;Print $ terminated string, used to print error or installed message
		MOV	AH,09
		INT	21
		RET
PRT_STR		ENDP

;Variable to disable install message
MESS_FLAG	DB	00			;If FF no install message

;When being installed program finds first free INT 2F function
FREEFUNC_2F	DW	0000			;First free multiplex function

;Possible messages upon installation
NOTDOS5_MESS	DB	0A,0D,"Requires MS-DOS 5.0+$"
DRV_MESS	DB	0A,0D,"Drive invalid$"
NOTFLOP_MESS	DB	0A,0D,"Requires harddisk$"
FREE_MESS	DB	0A,0D,"Drive almost full$"
INSTALL_FAIL	DB	" ACTIVITY not installed",0A,0D,"$"
INSTALL_OK	DB	0A,0D,"ACTIVITY installed",0A,0D,"$"
ALREADY		DB	0A,0D,"ACTIVITY already resident",0A,0D,"$"
NO_FREE		DB	0A,0D,"No free multiplex functions",0A,0D,"$"

INSTALL		ENDP
ACTIVITY	ENDP
_TEXT           ENDS
                END     ACTIVITY