/*--------------------------------------------------------------------------+
| Module: EMSFREE                                                           |
| Project: TOOLS                                                            |
| Author: Paul A. Penrose                                                   |
|         (c) 1992, 4D Interactive Systems, Inc.  All rights reserved.      |
| Start Date: 19 Nov 92                                                     |
| Last Revised: 19 Nov 92                                                   |
| Purpose:                                                                  |
|   This module contains code to free an EMS handle by name.                |
+--------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ems.h"

char copyright[] = "(c) 1992 4D Interactive Systems, Inc.  All rights reserved.";

void main(int argc, char **argv)
{
   int handle;

   if (argc > 1) {
      printf("+---------------------------------------+\n");
      printf("| EMS-Free Program  Ver 1.0             |\n");
      printf("| (c) 1992 4D Interactive Systems, Inc. |\n");
      printf("+---------------------------------------+\n");
      if (ems_init()) {
         if (ems_version >= 0x40) {
            strupr(argv[1]);
            handle = ems_find_handle(argv[1]);
            if (handle > 0) {
               ems_restore_mapping_context(handle);
               if (ems_free(handle) == 0) {
                  printf("EMS handle with name '%s' freed.\n",argv[1]);
               }
               else {
                  printf("**Error: Unable to free handle %i, error=%X.\n",handle,ems_errnum);
               }
            }
            else {
               printf("No EMS handle found with the name '%s'\n",argv[1]);
            }
         }
         else {
            printf("**Error: Unsupported EMS version (%i.%i)\n",ems_version >> 4,ems_version & 0x0F);
         }
      }
      else {
         printf("**Error: Unable to Initialize EMS functions.\n");
      }
   }
   else {
      printf("Usage is:\n");
      printf("  EMSFREE handle_name\n");
   }
}
