/* Include file with C function prototypes for EMS.ASM */

typedef struct {
   unsigned int handle;    /* Handle number */
   unsigned int num_pages; /* Number of pages owned by this handle */
   char handle_name[9];    /* Name of handle */
} handle_directory_struct;

int ems_init(void);
unsigned int ems_num_free_pages(int true_size);
int ems_alloc(int num_pages, char *name);
int ems_free(int handle);
int ems_map_page(int handle, int logical_page, int physical_page);
int ems_unmap_page(int handle, int physical_page);
int ems_num_physical_pages(void);
int ems_num_open_handles(void);
int ems_get_handle_directory(handle_directory_struct *hdir);
int ems_find_handle(char *handle_name);
int ems_save_mapping_context(int handle);
int ems_restore_mapping_context(int handle);

extern unsigned char ems_errnum, ems_function, ems_version;
extern unsigned int ems_pageframe;
