; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; These are the assembly graphics routines I created for the GIP stuff.
;
; If anyone can improve upon them, please do and send me the changes.
;
; I do not release these routines to the public domain.  However, they are
; free without obligation or credit for applications using them to implement
; the GIP standard.
;

.286
.Model Medium, Basic
.Code

extrn   StringAddress: proc
extrn   CursorOff: proc

;
; There is order to this madness!  The order exists around the fact that we
; support 3 types of display: 640x480x16 first, 320x200x256 second, and
; everything else (via BIOS calls) last.
;
; Of all the code here, the only part that matters is the actual pixel
; drawing loops.  In all the routines, these have been pulled out into
; subroutines to maximize their speed (each display mode is quite unique).
; Every cycle saved in these loops will have noticable improvement (depending
; on how many pixels we're drawing), whereas the code outside these loops
; doesn't really affect speed at all.
;


;
; Change to a screen mode.
;
; GSetMode (BYVAL ModeToUse%, BYVAL 640x480x256Mode%,  BYVAL 800x600x256Mode%)
;
; upon entry: 0 = 80x25x16 ansi mode
;             1 = 320x200x4 CGA mode (for testing only)
;             2 = 640x480x16 VGA mode
;             3 = 320x200x256 VGA mode
;             4 = 640x480x256 SVGA mode
;             5 = 800x600x256 SVGA mode
;

            PUBLIC  GSetMode          ;Make this routine available to LINK.

GSetMode    proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     al,[bp + 0AH]     ;Get the mode to use.
            mov     GModeInUse,al
            mov     GScrMem,0A000H

        R0: cmp     al,1              ;Check to see if graphics mode 1,
            jne     RN1
            mov     al,4              ;which is 320x200x4 CGA
            mov     GScrMem,0B800H
            jmp     D1

       RN1: cmp     al,-1             ;Check to see if graphics mode 1,
            jne     R2
            mov     al,4              ;which is 320x200x4 CGA
            mov     GScrMem,0B800H
            jmp     D1

        R2: cmp     al,2              ;Check to see if graphics mode 18,
            jne     RN2               ;which is 640x480x16 VGA
            mov     al,12H
            jmp     D1

       RN2: cmp     al,-2             ;Check to see if graphics mode 18,
            jne     R3                ;which is 640x480x16 VGA
            mov     al,12H
            jmp     D1

        R3: cmp     al,3              ;Check to see if graphics mode 19,
            jne     RN3               ;which is 320x200x256 VGA
            mov     al,13H
            jmp     D1

       RN3: cmp     al,-3             ;Check to see if graphics mode 19,
            jne     R4                ;which is 320x200x256 VGA
            mov     al,13H
            jmp     D1

        R4: cmp     al,4              ;Check to see if 640x480x256
            jne     R5
            mov     al,[bp + 08]
            jmp     D1

        R5: cmp     al,5              ;Check to see if 800x600x256
            jne     D2
            mov     al,[bp + 06]
            jmp     D1


        D2: cmp     al,50
            jne     D3
            mov     GModeInUse,0
            mov     ax,3
            int     10H
            mov     ax,1112h
            xor     bl,bl
            int     10H
            jmp     Done

        D3: mov     al,3              ;Else, standard 80x25x16 ANSI mode.

                mov     ax,3
                int     10h                     ; Video display   ah=functn 00h
                                                ;  set display mode in al
                mov     ax,1104h
                xor     bl,bl                   ; Zero register
                int     10h                     ; Video display   ah=functn 11h
                                                ;  load 8x16 font, bl=block
                mov     ax,1103h
                xor     bl,bl                   ; Zero register
                int     10h                     ; Video display   ah=functn 11h
                                                ;  set active font block bl
;call CursorOff
jmp Done


        D1: xor     ah,ah
            int     10H

      Done: 

call CursorOff

pop     bp
            ret     6                 ;Pop-return past our input parameters.

GSetMode    endp                      ;End of routine.


;
; Display text in a given color at given coordinates.
;
; ColorText (BYVAL Horiz%, BYVAL Vert%, BYVAL Color%, BYVAL CharToDisp%)
;
; Temporarily using DOS 8x8 font until I can figure out the TrueType font
; file structure and implement those fonts.
;

            PUBLIC  ColorText         ;Make this routine available to LINK.

ColorText   proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     al,[bp + 06]      ;Character to display
            cmp     al,32             ;Nothing to do if a space.
            je      Done

            push    ds

            mov     es,GScrMem
            xor     ah,ah
            shl     ax,3              ;8 pixels high.
            mov     si,0FA6EH         ;Start of DOS font table.
            add     si,ax
            push    0F000H            ;Segment of the font table.
            pop     ds

            mov     dx,[bp + 0AH]     ;Vertical start.
            mov     bx,8              ;8 pixels high.
            mov     cx,[bp + 0CH]     ;Horizontal start.

            cmp     GModeInUse,2      ;640x480x16 VGA
            jne     R1
            call    ColorText1
            jmp     D1
        R1: cmp     GModeInUse,3      ;320x200x256 VGA
            jne     R2
            call    ColorText2
            jmp     D1
        R2: call    ColorText3

        D1: pop     ds
      Done: pop     bp
            ret     8                 ;Pop-return past our input parameters.

ColorText   endp                      ;End of routine.
;
ColorText1  proc    near              ;Beginning of routine.
            mov     di,dx          ;
            shl     di,2           ;
            add     di,dx          ;
            shl     di,4           ;DI = DX * 80
            mov     al,[bp + 08]      ;Color to use.
        R1: mov     dx,8           ;8 pixels wide.
            mov     ah,ds:[si]
            inc     si
        R2: shl     ah,1              ;Pixel value -> CF.
            jnc     R3
            pusha
            push    cx
            shr     cx,3
            add     di,cx
            pop     cx
            and     cx,7
            mov     ch,80H
            mov     dx,03CEH
            push    ax
            mov     ax,0205H
            out     dx,ax             ;vga graphics index
            shr     ch,cl
            mov     ah,ch
            mov     al,8
            out     dx,ax
            pop     ax
            mov     ah,es:[di]
            stosb                     ;(ES:DI) <- al
            popa
        R3: inc     cx                ;Move right one pixel.
            dec     dx
            jnz     R2
            add     di,80             ;Move down one pixel.
            sub     cx,8
            dec     bx
            jnz     R1
            ret
ColorText1  endp                      ;End of routine.
;
ColorText2  proc    near              ;Beginning of routine.
            mov     di,dx          ;duplicate starting vert to DI
            shl     di,2           ;
            add     di,dx          ;
            shl     di,6           ;DI = Line * 320
            add     di,cx          ;                + our horizontal start.
            mov     ah,[bp + 08]      ;Color to use.
        R1: mov     cx,8               ;8 pixels wide.
            lodsb                     ;AL <- (DS:SI)
        R2: shl     al,1              ;Pixel value -> CF.
            jnc     R3
            mov     es:[di],ah
        R3: inc     di                ;Move right one pixel.
            loop    R2
            add     di,312             ;Move down one pixel. (320 - 8)
            dec     bx
            jnz     R1
            ret
ColorText2  endp                      ;End of routine.
;
ColorText3  proc    near              ;Beginning of routine.
            ;
            ; Bios wants: CX = horizontal position
            ;             DX = vertical position
            ;             AL = color
            ; BH = video page zero, which we get with MOV BX,8 earlier.
            ;
            mov     al,[bp + 08]      ;Color to use.
        R1: mov     di,8              ;8 pixels wide.
            mov     ah,ds:[si]
            inc     si
        R2: shl     ah,1              ;Pixel value -> CF.
            jnc     R3
            pusha
            mov     ah,0CH            ;BIOS: draw pixel
            int     10H               ;changes ax,si,di
            popa
        R3: inc     cx                ;Move right one pixel.
            dec     di
            jnz     R2
            inc     dx                ;Move down one pixel.
            sub     cx,8
            dec     bx
            jnz     R1
            ret
ColorText3  endp                      ;End of routine.


;
; Draw-A-Multiple-Color-Solid-Horizontal-Line-Fast
;
; DAMCSHLF (BYVAL Horiz%, BYVAL Vert%, Colors$, LineWidth, BitsPerColor)
;
; BitsPerColor = 4 or 8 for color bits within the string.
;
; To draw lines for stuff like icon's and BMP's.  You should call this
; routine with Vert% pointing to the end of the image.  It is the job of
; the calling routine to update Vert%.
;
; This doesn't handle non-even line lengths with 4 bits (29, 31, 319, etc.).
; However I'm not so sure such images are possible, we'll wait and see.
;

            PUBLIC  DAMCSHLF          ;Make this routine available to LINK.

DAMCSHLF    proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            push    [bp + 0AH]
            call    StringAddress
            jcxz    Done
            push    ds
            mov     ds,dx
            xchg    si,ax              ;DS:SI holds our colors.
            ;
            mov     es,GScrMem
            cld
            mov     dx,[bp + 0CH]      ;Vert%
            mov     bx,[bp + 06]       ;Bits-per-color
            cmp     bx,8
            je      R8
            ;
            ; Display the 4 bit 16 color lines.
            ;
            cmp     GModeInUse,2      ;640x480x16 VGA
            jne     R1
            call    DAMCSHLF1
            jmp     D1
        R1: cmp     GModeInUse,3      ;320x200x256 VGA
            jne     R2
            call    DAMCSHLF2
            jmp     D1
        R2: call    DAMCSHLF3
            jmp     D1
            ;
            ; Display theh 8 bit 256 color lines.
            ;
        R8: cmp     GModeInUse,2      ;640x480x16 VGA
            jne     R3
            call    DAMCSHLF4
            jmp     D1
        R3: cmp     GModeInUse,3      ;320x200x256 VGA
            jne     R4
            call    DAMCSHLF5
            jmp     D1
        R4: call    DAMCSHLF6
            jmp     D1

        D1: pop     ds
      Done: pop     bp
            ret     0AH                 ;Pop-return past our input parameter.

DAMCSHLF    endp                      ;End of routine.
;
DAMCSHLF1   proc    near              ;Beginning of routine.
            mov     di,dx          ;Convert DI to memory coordinates.
            shl     di,2           ;
            add     di,dx          ;
            shl     di,4           ;DI = DX * 80
x0:
            mov     bx,[bp + 0EH]     ;StartH
            push cx
            mov     cx,[bp + 08]
x1:
            lodsb
            mov ah,al
            shr al,4
            pusha
            mov     cx,bx
            shr     bx,3
            add     di,bx
            mov     bl,al
            mov     dx,03CEH
            mov     ax,0205H
            out     dx,ax             ;vga graphics index
            and     cx,7
            mov     ch,128            ;10000000 rotating bank selector.
            shr     ch,cl
            mov     ah,ch
            mov     al,8
            out     dx,ax
            mov     ah,es:[di]
            mov     al,bl
            stosb                     ;(ES:DI) <- al
            popa
            inc bx
            and ah,15
            pusha
            mov     cx,bx
            shr     bx,3
            add     di,bx
            mov     bl,ah
            mov     dx,03CEH
            mov     ax,0205H
            out     dx,ax             ;vga graphics index
            and     cx,7
            mov     ch,128            ;10000000 rotating bank selector.
            shr     ch,cl
            mov     ah,ch
            mov     al,8
            out     dx,ax
            mov     ah,es:[di]
            mov     al,bl
            stosb                     ;(ES:DI) <- al
            popa
            inc bx
            loop x1
            sub     di,80
            pop cx
            sub cx,[bp + 08]
            inc cx
            loop x0
            ret
DAMCSHLF1   endp                      ;End of routine.
;
DAMCSHLF2   proc    near              ;Beginning of routine.
            mov     bx,[bp + 0EH]     ;StartH
            mov     di,dx          ;Convert screen coor to memory coor.
            shl     di,2           ;
            add     di,dx          ;
            shl     di,6           ;AX = Line * 320
            add     di,bx          ;                + our horizontal start.
x10:
            mov     bx,[bp + 0EH]     ;StartH
            push cx
            mov     cx,[bp + 08]
x11:
            lodsb
            mov ah,al
            shr al,4
            pusha
;            mov     di,dx          ;duplicate starting vert to DI
;            shl     di,2           ;
;            add     di,dx          ;
;            shl     di,6           ;AX = Line * 320
;            add     di,bx          ;                + our horizontal start.
            stosb
            popa
;            inc bx
inc di
            mov al,ah
            and al,15
            pusha
;            mov     di,dx          ;duplicate starting vert to DI
;            shl     di,2           ;
;            add     di,dx          ;
;            shl     di,6           ;AX = Line * 320
;            add     di,bx          ;                + our horizontal start.
            stosb
            popa
;            inc bx
inc di
            loop x11
;            dec dx
sub di,320
sub di,bx
            pop cx
            sub cx,[bp + 08]
            inc cx
            loop x10
            ret
DAMCSHLF2   endp                      ;End of routine.
;
DAMCSHLF3   proc    near              ;Beginning of routine.
;BIOS output
x40:
            mov     bx,[bp + 0EH]     ;StartH
            push cx
            mov     cx,[bp + 08]
x41:
            lodsb
            mov ah,al
            shr al,4
        R4: pusha
            mov     ah,0CH            ;BIOS: draw pixel
            mov     cx,bx             ;Horiz -> CX.
            xor     bh,bh             ;video page 0.
            int     10H               ;changes ax,si,di
            popa
            inc bx
            mov al,ah
            and al,15
            pusha
            mov     ah,0CH            ;BIOS: draw pixel
            mov     cx,bx             ;Horiz -> CX.
            xor     bh,bh             ;video page 0.
            int     10H               ;changes ax,si,di
            popa
            inc bx
            loop x41
            dec dx
            pop cx
            sub cx,[bp + 08]
            inc cx
            loop x40
            ret
DAMCSHLF3   endp                      ;End of routine.
;
DAMCSHLF4   proc    near              ;Beginning of routine.
d256c:
            mov     bx,[bp + 0EH]     ;StartH
            push cx
            mov     cx,[bp + 08]
   x2:
            lodsb
            pusha
            mov     di,dx          ;
            shl     di,2           ;
            add     di,dx          ;
            shl     di,4           ;DI = DX * 80
            mov     cx,bx
            shr     bx,3
            add     di,bx

            mov     bl,al
            mov     dx,03CEH
            mov     ax,0205H
            out     dx,ax             ;vga graphics index

            and     cx,7
            mov     ch,128            ;10000000 rotating bank selector.
            shr     ch,cl
            mov     ah,ch
            mov     al,8
            out     dx,ax
            mov     ah,es:[di]
            mov     al,bl
            stosb                     ;(ES:DI) <- al
            popa
            inc bx
            loop x2
            dec dx
            pop cx
            sub cx,[bp + 08]
            inc cx
            loop d256c
            ret
DAMCSHLF4   endp                      ;End of routine.
;
DAMCSHLF5   proc    near              ;Beginning of routine.
d256c:
            mov     bx,[bp + 0EH]     ;StartH
            push cx
            mov     cx,[bp + 08]
x2:
            lodsb
            pusha
            mov     di,dx          ;duplicate starting vert to DI
            shl     di,2           ;
            add     di,dx          ;
            shl     di,6           ;AX = Line * 320
            add     di,bx          ;                + our horizontal start.
            stosb
            popa
            inc bx
            loop x2
            dec dx
            pop cx
            sub cx,[bp + 08]
            inc cx
            loop d256c
            ret
DAMCSHLF5   endp                      ;End of routine.
;
DAMCSHLF6   proc    near              ;Beginning of routine.
d256c:
            mov     bx,[bp + 0EH]     ;StartH
            push cx
            mov     cx,[bp + 08]
x2:
            lodsb
            pusha
            mov     ah,0CH            ;BIOS: draw pixel
            mov     cx,bx             ;Horiz -> CX.
            xor     bh,bh             ;video page 0.
            int     10H               ;changes ax,si,di
            popa
            inc bx
            loop x2
            dec dx
            pop cx
            sub cx,[bp + 08]
            inc cx
            loop d256c
            ret
DAMCSHLF6   endp                      ;End of routine.


;
; Draw a pixel in a given color at given coordinates.
;
; GPixel (BYVAL Horiz%, BYVAL Vert%, BYVAL Color%)
;

            PUBLIC  GPixel            ;Make this routine available to LINK.

GPixel      proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     es,GScrMem
            mov     bl,[bp + 06]      ;Pixel's color.
            mov     dx,[bp + 08]      ;vertical position.
            mov     cx,[bp + 0AH]     ;horizontal position.
            call    GPixel2

            pop     bp
            ret     6                 ;Pop-return past our input parameter.

GPixel      endp                      ;End of routine.
;
; Draw a pixel.
;
; bl = pixel's color
; cx = horizontal position
; dx = vertical position
;
; changes: nothing
;
; A good general routine to use internally for other routines as well while
; experimenting.
;
GPixel2     proc    near              ;Beginning of routine.

            pusha
            mov     al,bl
            cmp     GModeInUse,2      ;640x480x16 VGA
            jne     R1
            ;
            mov     di,dx          ;
            shl     di,2           ;
            add     di,dx          ;
            shl     di,4           ;DI = DX * 80
            ;
            push    cx
            shr     cx,3
            add     di,cx
            pop     cx
            and     cx,7
            mov     ch,80H
            ;
            push    ax
            mov     dx,03CEH
            mov     ax,0205H
            out     dx,ax             ;vga graphics index
            ;
            shr     ch,cl
            mov     ah,ch
            mov     al,8
            out     dx,ax
            pop     ax
            mov     ah,es:[di]
            stosb                     ;(ES:DI) <- al
            ;
            popa
            ret

        R1: cmp     GModeInUse,3      ;320x200x256 VGA
            jne     R4
            ;
            ; Draw a 320x200x256 VGA pixel.
            ;
            mov     di,dx          ;duplicate starting vert to DI
            shl     di,2           ;
            add     di,dx          ;
            shl     di,6           ;DI = Line * 320
            add     di,cx          ;                + our horizontal start.
            stosb
            popa
            ret

        R4: mov     ah,0CH            ;BIOS: draw pixel
            xor     bh,bh             ;video page 0.
            int     10H               ;changes ax,si,di
            popa
            ret

GPixel2     endp                      ;End of routine.


;
; Draw a line.  Pretty general routine that calls a bunch of faster line
; drawing routines.  Only draws in one color.
;
; GLine (BYVAL CurrentH%, BYVAL CurrentV%, BYVAL TillH%, BYVAL TillV%, BYVAL Colr%, BYVAL GDither%)
;
;

            PUBLIC  GLine             ;Make this routine available to LINK.

GLine       proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     es,GScrMem        ;Point ES to the screen.
            cld
            ;
            mov     ax,[bp + 06]      ;Line pattern to use.
            mov     bl,[bp + 08]      ;Line color.
            mov     cx,[bp + 10H]     ;CurrentH
            mov     dx,[bp + 0EH]     ;CurrentV
            mov     di,[bp + 0CH]     ;TillH
            mov     si,[bp + 0AH]     ;TillV
            ;
            ; We can only do this less-than adjust with one of the coordinates.
            ; So we use Horizontal for faster filled box draws.
            ;
            cmp     cx,di
            jle     R1
            xchg    cx,di               ;Now CX always <= DI
xchg dx,si
            ;
        R1: cmp     dx,si
            jne     R3                  ;Not a horizontal line.
            ;
            cmp     ax,-1
            jne     R2                  ;Not a solid horizontal line.
            ;
            ; Draw the solid horizontal line.
            ;
            cmp     GModeInUse,2      ;640x480x16 VGA
            jne     H1
            call    DASCSHLF1
            jmp     Done
        H1: cmp     GModeInUse,3      ;320x200x256 VGA
            jne     H2
            call    DASCSHLF2
            jmp     Done
        H2: call    DASCSHLF3
            jmp     Done
            ;
        R2: call    DL2                 ;Draw a horizontal line with pattern.
            jmp     Done
            ;
        R3: ;cmp     ax,-1
            ;jne     R4                  ;Not a solid line.
            ;call    DASCSLF             ;Draw the solid line.
            ;jmp     Done
        R4: call    DrawLine            ;Draw a line with pattern.

      Done: pop     bp
            ret     0CH               ;Pop-return past our input parameter.

GLine       endp                      ;End of routine.
;
;Draw-A-Single-Color-Solid-Horizontal-Line-Fast
;
;Input:
;  bl  color to use
;  cx  starting horizontal coordinate (always less than or equal to di)
;  dx  starting vertical coordinate 
;  di  ending horizontal coordinate
;  assumes a RET after this call, so we don't care what we destory.
;
DASCSHLF1   proc    near              ;Beginning of routine.
            mov     si,di
            sub     si,cx
            inc     si

            mov     di,dx          ;
            shl     di,2           ;
            add     di,dx          ;
            shl     di,4           ;DI = DX * 80
            push    cx
            shr     cx,3
            add     di,cx

            pop     cx
            and     cx,7
            mov     ch,128            ;10000000 bitmask
            shr     ch,cl
            mov     dx,03CEH

            mov bh,ch
            mov cx,si
xx7:
            mov     ax,0205H
            out     dx,ax             ;vga graphics index

            mov     ah,bh
            mov     al,8
            out     dx,ax
            mov     ah,es:[di]
            mov     al,bl
            stosb                     ;(ES:DI) <- al
            ror bh,1
            cmp bh,128
            je xx8
            dec di
       xx8: loop xx7
            ret
DASCSHLF1   endp                      ;End of routine.
DASCSHLF2   proc    near              ;Beginning of routine.
            ;
            ; 320x200x256 VGA solid line.  About as fast as possible.
            ;
            sub     di,cx
            xchg    cx,di
            inc     cx
            mov     al,bl
            mov     ah,al
            mov     bx,di          ;starting horiz now in BX
            mov     di,dx          ;duplicate starting vert to DI
            shl     di,2           ;
            add     di,dx          ;
            shl     di,6           ;DI = Line * 320
            add     di,bx          ;                + our horizontal start.
            shr     cx,1
            rep     stosw
            jnc     R33
            stosb
       R33: ret
DASCSHLF2   endp                      ;End of routine.
DASCSHLF3   proc    near              ;Beginning of routine.
            ; Bios wants: CX = horizontal position
            ;             DX = vertical position
            ;             AL = color
            ;
            sub     di,cx
            xchg    cx,di
            inc     cx
            mov     ah,0CH            ;BIOS: draw pixel
            mov     al,bl
            xor     bh,bh             ;video page 0.
       RBB: pusha
            mov     cx,di
            int     10H               ;changes ax,si,di
            popa
            inc     di
            loop    RBB
            ret
DASCSHLF3   endp                      ;End of routine.






DL2    proc    near              ;Beginning of routine.
            ;
            ; This does a quicker draw for stuff for which there are no
            ; slopes, like filled rectangles.  This actually produces no
            ; noticable speed change--any speed improvement has to come from
            ; GPixel2.
            ;
            mov     DPattern2,ax
            rol     DPattern2,1
        a1: ror     DPattern2,1          ;adjust the pattern.
            jnc     a3                  ;don't draw if no need to.
            call    GPixel2
        a3: inc     cx
            cmp     cx,di
            jle     a1
            ret
DPattern2   DW   0
DL2       endp                      ;End of routine.


DrawLine    proc    near               ;Beginning of routine.

            mov     DPattern,ax
            rol     DPattern,1

            mov     SlopeV,1

            sub     si,dx
            cmp     si,0
            jge     S1
            neg     si
            mov     SlopeV,-1

        S1: sub     di,cx

        S2: cmp     di,si
            jle     S3

;
; Plot the line.
;

           mov     ax,di
           shr     ax,1
           mov     unk1,ax           ;unk1 = DI \ 2     growth rate.
           mov     Counter,di
           ror     DPattern,1
           jnc     z1
           call    GPixel2    ;no reason to expand this.
z1:         cmp     di,0
           je      Done
        R1: inc     cx
            add     unk1,si
            cmp     unk1,di
            jle     R2
            sub     unk1,di
            add     dx,SlopeV
        R2: ror     DPattern,1     ;horribly slow! use a register!
            jnc     z2
            call    GPixel2    ;expand this
z2:         dec     Counter
            jnz     R1
            jmp     Done

;
; Plot the line.
;

        S3: mov     ax,si
            shr     ax,1
            mov     unk1,ax           ;unk1 = SI \ 2
            mov     Counter,si

            ror     DPattern,1
            jnc     z3
            call    GPixel2    ;no reason to expand this.
z3:         cmp     si,0
            je      Done

        R3: add     dx,SlopeV
            add     unk1,di
            cmp     unk1,si
            jle     R4
            sub     unk1,si
            inc     cx
        R4: ror     DPattern,1
            jnc     z4
            call    GPixel2  ;expand this
z4:         dec     Counter
            jnz     R3
       done:     ret

SlopeV      DW   0
unk1        DW   0
Counter     DW   0
DPattern    DW   0

DrawLine    endp                      ;End of routine.










            PUBLIC  SetPalette        ;Make this routine available to LINK.

SetPalette  proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            push    [bp + 06]
            call    StringAddress     ;No JCXZ--it's got to be a 768 byter.
            xchg    si,ax
            push    ds
            mov     ds,dx             ;now at DS:SI

            mov     dx,03C8H
            xor     ax,ax
            cli                             ; critical section:  no ints
            out     dx,al                   ; starting register
            inc     dx                      ; set up to update colors
mov cx,3*256    ;although this should be ok from above.
            rep     outsb                   ; whap!  Zango!  They're updated!
            sti                             ; end of critical section

            pop     ds


;To set a RGB sequence we concern ourselves with two ports.  Let's say we
;want to change color #209 to the RGB values of (20h,40h,60h).  First we
;send the number of the color we want to alter out port #03C8:
;
;        Port [$03C8] := 209
;
;Next, we send the RGB values we want to change to out through port #03C9:
;
;        Port [$03C9] := $20;
;        Port [$03C9] := $40;
;        Port [$03C9] := $60;
;
;After we update each red, green, and blue value, port $3C8 advances to
;the next color number and we could do that one right away.  I can't
;begin to tell you how much faster this is than using the BIOS routines
;to do the same thing.  It was pretty painless also.
;
;There is one thing to consider.  While our palette is 6-6-6, the PCX
;format saves its palette as 8-8-8.  This means that White, for example,
;is stored as ($FF,$FF,$FF), while we need it as ($63,$63,$63).  This is
;very simple to fix.  Simply read in the palette, and as each byte comes
;in shift it two places to the right.
;
;So much for writing a palette register.  Reading the RGB values for a
;color register is just as simple.  the only difference is the first port
;we call is $3C7:

      Done: pop     bp
            ret     2                 ;Pop-return past our input parameter.

SetPalette  endp                      ;End of routine.



;pass it a string of 768 bytes.

            PUBLIC  GetPalette        ;Make this routine available to LINK.

GetPalette  proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            push    [bp + 06]
            call    StringAddress     ;No JCXZ--it's got to be a 768 byter.
            xchg    di,ax             ;at ES:DI

            mov     dx,03C7H
            xor     ax,ax
            cli                             ; critical section:  no ints
            out     dx,al
            inc     dx
            inc     dx                      ; We check port 03C9 for values.
mov cx,3*256
            rep     insb
            sti                             ; end of critical section

;So much for writing a palette register.  Reading the RGB values for a
;color register is just as simple.  the only difference is the first port
;we call is $3C7:
;
;        Port [$03C7] := 209
;        Red   := Port [$03C9];
;        Green := Port [$03C9];
;        Blue  := Port [$03C9];
;
;The rest of the routine stays the same.

      Done: pop     bp
            ret     2                 ;Pop-return past our input parameter.

GetPalette  endp                      ;End of routine.


;Draw-A-Single-Color-Solid-Line-Fast
;
;Input:
;  bl  color to use
;  cx  starting horizontal coordinate (always less than or equal to di)
;  dx  starting vertical coordinate 
;  di  ending horizontal coordinate
;  si  ending vertical coordinate
;  assumes a RET after this call, so we don't care what we destory.
;
; The goal being to use memory coordinates instead of screen coordinates
; to draw a line.
;
DASCSLF     proc    near               ;Beginning of routine.


            mov     SlopeVz,1

            sub     si,dx
            cmp     si,0
            jge     S1
            neg     si
            mov     SlopeVz,-1

        S1: sub     di,cx

        S2: cmp     di,si
            jle     S3

            mov     ax,di
            shr     ax,1
            mov     unkz,ax           ;unkz = DI \ 2     growth rate.
            mov     Counterz,di
            call    GPixel2    ;no reason to expand this.
z1:         cmp     di,0
            je      Done

        R1: inc     cx
            add     unkz,si
            cmp     unkz,di
            jle     R2
            sub     unkz,di
            add     dx,SlopeVz
r2:         call    GPixel2   ;expand this
z2:         dec     Counterz
            jnz     R1
            jmp     Done


        S3: mov     ax,si
            shr     ax,1
            mov     unkz,ax           ;unkz = SI \ 2
            mov     Counterz,si
            call    GPixel2    ;no reason to expand this.
z3:         cmp     si,0
            je      Done

        R3: add     dx,SlopeVz
            add     unkz,di
            cmp     unkz,si
            jle     R4
            sub     unkz,si
            inc     cx
r4:         call    GPixel2   ;expand this
z4:         dec     Counterz
            jnz     R3

done:            ret

slopevz     DW   0
unkz        DW   0
Counterz    DW   0

DASCSLF     endp                      ;End of routine.

GScrMem     DW   0
GModeInUse  DB   0


End 




