 NAME
      MaxiFTP - Internet file transfer program

 VERSION
      Version 2a

 SYNOPSIS
      maxiftp [options] [[user@]hostname[:pathname] [user] [passwd]]

 DESCRIPTION
      MaxiFTP is an alternative user interface to the Internet standard File
      Transfer Protocol.  The program allows a user to transfer files to and
      from a remote network site.  This program offers additional features
      that are not found in the standard interface, ftp.

 FEATURES
      +    By default, an anonymous login is attempted when you open a site.
           No need to enter ``anonymous'' and your email address every time
           you open a site.  MaxiFTP can determine your hostname, or you can
           specify an anonymous password in the NETRC file or MAXIFTP 
           environment variable.

      +    The output of the dir and ls commands can be redirected and piped. 
           The output of the new ``type'' command can also be redirected or 
           piped.  The results of the last directory command can be redisplayed
           with the redir and predir commands.

      +    You can save some keystrokes by putting commonly used sites in
           the netrc file, and then just type abbreviations when you open
           them on the command line.  For example, if you had 
           wuarchive.wustl.edu in your netrc you would only need to type
           ``open wuar'' (or any abbreviation that will separate it from the
           rest of the sites in your netrc).

      +    maxiftp has ``implicit cd'' where you can just type the name of a
           directory (when connected) instead of typing ``cd <directory>''.

      +    MaxiFTP will create a FAT compliant name on FAT partitions that
           will always try preserve the file extension (FTP does not).
           MaxiFTP will place the full filename in the .LONGNAME extended
           attribute.

      +    maxiftp has a ``touch'' mode where it will attempt to use the
           remote system's date and timestamp on the local file.  This requires
           a TOUCH command comparable to that included with the GNU File
           Utilities for OS/2.

      +    A page command lets you use your pager to read remote files.
           There is also the commands pdir which lets you read directory
           listings with your pager.

      +    You don't need to close sites; maxiftp closes an open site when you
           try to open a different one.

      +    You can save some typing by using a wildcard to specify one file.
           For example, you can type ``get R*'' to fetch a file called
           README.

      +    You can invoke maxiftp with ``colon mode'' where you can type
           ``maxiftp cse.unl.edu:/pub/foo'' and it will fetch ``foo'' for you
           then exit.  If the name you specify includes a wildcard, all files
           matching the specification will be transferred.

      +    There is a create command which is useful for creating messages
           on a remote site.

      +    The prompt can be customized to include things like the date,
           time, current remote working directory, boldface, colors, etc.

      +    The behavior of maxiftp can be customized with set, unset and
           command line options.  Command line options can be stored in an
           environment variable.  Additionally, _any_ MaxiFTP command can be
           placed as a comment at the beginning of the NETRC file and it will
           be executed each time MaxiFTP begins.

 OPTIONS
      Command line options:  The command line options are a '-' or '/' 
      followed by a single letter; case is not significant.  Specifying a 
      binary option turns that option on.  Following an option by a '-' turns
      it off. (NOTE:  there is a bug in the OS/2 command interpreter that 
      removes /q from any parameter list.  Use -q instead.)

      Examples:

         maxiftp -q
            starts maxiftp in quiet mode
         maxiftp /p-
            starts maxiftp in noprompt mode
         maxiftp /h colon-mode
            displays the on-line help for colon-mode

 -Q[-]     forces maxiftp to show all responses from the remote server, as
           well as report on data transfer statistics.

 -C[-]     sets CLOBBER mode; you will be prompted before files are
           overwritten.

 -P[-]     sets PROMPT mode; you will be prompted during MGET and MPUT.

 -T[-]     sets TOUCH mode; MaxiFTP will attempt to adjust the date of files
           received with the GET command to match the remote host.

 -U[-]     sets UNIQUE mode;

 -B        makes BINARY mode the default rather than ASCII.

 -N[-]     Instructs maxiftp from to read the netrc (see below) file in the
           ETC directory.  /N- will instruct maxiftp to ignore the netrc file.

 -D[-]     Displays a status banner on top of screen.

 -X[-]     Use/Don't use rxSock to determine the full hostname to use when 
           when creating the anonymous ftp password.

 -H[str]   prints help.  -H can be followed by any of the help topics to
           display help for that topic; i.e. -h append.

 -A[str]   sets the anonymous password.  It should be followed immeadiately
           (with no intervening blanks) by the new anonymous password.

 -L[str]   sets the local directory.


      The host with which maxiftp is to communicate may be specified on
      the command line.  If this is done, maxiftp will immediately attempt to
      establish a connection to an FTP server on that host; otherwise, maxiftp
      will enter its command interpreter and await instructions from the
      user.  maxiftp uses many of the commands provided by ftp.  All of the
      commands supported appear in the main help screen.

 COMMANDS
      Explanations of commands specific to maxiftp follow.  Please refer to
      the ftp documentation for descriptions of the standard commands.

      !    Issue an operating system command or start a secondary shell.

      append
           Recieve a remote file in ASCII mode and append it to an existing 
           file.

      create
           Use this to create an empty file on the remote site.  Sometimes
           it is necessary to leave a note if you can't get in touch with
           the remote site's administrator.  For example if a file is
           corrupted, you could type ``create Foo.tar_is_corrupt'' so the
           uploader will replace it.

      echo Use this command to display information on the console.  This 
           command is most useful from a NETRC MACRO.  See below.

      open This command has been extended to accept flags to specify its
           behavior.  By default, ``open sitename'' tries to login to a site
           with ``anonymous'' and your email address as the password. 

           You can specify the host name and user name in the ``finger''
           format username@hostname.  MaxiFTP will prompt you for a password.

      page You can read a remote file with your pager.  OS/2's ftp command
           doesn't allow ``get myfile.txt |more'', but this client does.  The
           page and more commands are shortcuts.

      pdir This command lets you view a dir command with your pager.

      predir
           This lets you view the contents of the last ls or dir command
           with your pager.  maxiftp stores the output of the previous command
           in memory, so you can quickly relist the last command without
           going over the network.  This is handy for slow connections.

      redir
           This dumps the contents of the last ls or dir command to
           standard-out.

      version
           This prints the version number of MaxiFTP.

      show This command shows the values of the various runtime options of
           MaxiFTP.


 VARIABLES
      set
           maxiftp has some variables that can be set at run time in the
           netrc or interactively in the shell.  You can also use the
           command set to undefine a variable.  Use ``set var=value'' to 
           define a value or ``set var'' to undefine it.  

           In the netrc, you must use ``#set var=value''.  OS/2's ftp 
           command will treat these commands as comments.

           anonpass (string)
                is set to your email address, and used as the password when
                you login anonymously.

           binaries (string)
                specifies extensions to always transfer in binary mode.

           ldir (string)
                is set to the local current directory.  This is mostly
                useful to set in the netrc, where you may want to always
                download into a certain directory.

           mode (ASCII or BINARY)
                is set to the default file transfer mode

           mprompt (1 or 0)
                specifies whether you want the mget, mput, etc., commands
                ask what to do with each file.

           pager (string)
                is the program used to page remote files.  If you don't set
                it, it defaults to the value of the PAGER environment
                variable, or MORE if neither is set.

           prompt (string)
                is the command line prompt, which may use several @ flags
                (see below).


 PROMPTS
      The following flags insert special values into the prompt:

      @D   Inserts the current remote directory.

      @L   Inserts the current local directory.

      @H   Inserts the name of the remote host.

      @0   Inserts the name of the calling program.

      @B   Turns on boldface mode.

      @Cfb Set color to foreground f on background b; where f and b
           are numbers between 0 and 7.  0 is black; 1 is red; 2 is green; 3 
           is yellow; 4 is blue; 5 is magenta; 6 is cyan; 7 is white.

      @I or @R
           Turns on inverse (reverse) video mode.

      @N   Inserts a newline character.

      @P   Turns off any video modes you might have set with @B, @I, or @R

      @T   Inserts the current time.

      @S   Inserts the current connection status as "Connected to user@host"
           or "Not connected to a host"

      @_   Inserts a blank (use if you want a blank at the end of your prompt)

      @@   Inserts an at sign.

      The default prompt is  set prompt=@0@S[@B@H:@D@P]@S


 NETRC
      Many users of ftp leave the power of the netrc untapped.  

      The NETRC file may begin with #command where command is any MaxiFTP
      command which maxiftp runs at startup before any connection is made,
      followed by machine entries.  

      When maxiftp runs, looks for a file named netrc in the current 
      directory, then the directory in the ETC environment variable.

      MaxiFTP will only use the MACHINE, LOGIN, and PASSWORD fields from a
      NETRC file.  You can add entries with only the MACHINE field to be
      able to use abbreviated host names.

      MaxiFTP also treats comments following a machine entry as a macro 
      for that host.  See the section NETRC MACROS below for more 
      information.

      To place a comment in the NETRC file that MaxiFTP will ignore, begin it 
      with two # symbols.

 NETRC MACROS
      MaxiFTP does not implement macros the same way as FTP does - however 
      it is possible to have a series of commands executed when you connect 
      to a host.  In your NETRC file, follow the MACHINE entry with a series 
      of comments that contain MaxiFTP commands.

      NETRC macros _are_not_ processed before colon-mode fetch operations.


 SAMPLE NETRC & COMMENTS
       ##This is a sample NETRC file for use with MaxiFTP
       ##First, set touch mode on
       #set touch=1
       ##Set the prompt to display status in blue on cyan on the first line,
       ##with the current remote directory in bold followed by a green arrow
       ##on black on the second line. (And restor video to normal)
       #set prompt=@C46@S@P@N@B@D@P@C20=>@P
       ##set the anonymous ftp password
       #set anonpass=acrosby@uafhp.uark.edu
       ##Display a message
       #echo Loaded NETRC file
       
       ##Note:  the first non-comment line ends the startup comments.
       ##       Any machine #macros must follow the machine entry.
       ##       All machine #macros will be processed until the next
       ##       machine entry.

       ##The NETRC file should be shareable by OS/2's FTP and MaxiFTP.

       ##The next entry is here just for abbreviated name searching.
       machine wuarchive.wustl.edu 

       ##This entry has a macro that will change to the /pub/msdos directory
       ##after connecting.
       machine oak.oakland.edu 
       #cd /pub/msdos
       ##Place any files transferred in the incoming/dos directory
       #set ldir=d:\incoming\dos
       
       ##Supplies the three machine fields...
       machine zurich.ai.mit.edu login anonymous password os2user@advlab05.uark.edu

       ##My entry for ftp-os2.  
       machine ftp-os2.cdrom.com
       ##Always list the new files in the incoming directory...
       #!cls
       #echo Connected to ftp-os2.cdrom.com...
       #cd /pub/os2/incoming
       #dir -altr
       ##Place any files transferred in the incoming/os2 directory
       #set ldir=d:\incoming\os2

       ##An entry with a login id and password.  Of course, this entry
       ##isn't real...
       machine your.host.dom login myself pass password
       #set prompt=Now connected to your.host.dom in the @D directory.@N[@L]


 ENVIRONMENT
      maxiftp uses the following environment variables:

      PAGER     for the default filter used by the page command;

      MAXIFTP   for the command line options to control behaviour;

      BINARIES  for a list of filetypes to always transfer in binary mode;

      HOSTNAME  for the name of the host if rxSock is unavailable;

      ETC       for the name of the TCPIP ETC directory;


 DISPLAY
      In addition to the MaxiFTP prompt, MaxiFTP can display information 
      about the current session of the screen in a status bar across the top 
      of the display.  This status bar is off by default, but can be turned 
      on with the -D command line option or TOGGLE DISPLAY.


 TOUCH
      MaxiFTP implements a new command that appears to be rather unique among 
      FTP clients, though often sought after: an interface to touch.  Using 
      this mode, you can transfer files from a remote host and keep the 
      date/time stamp intact.

      Programming this feature requires a knowledge of the format that remote 
      hosts use when returning a directory; the system currently knows about 
      Unix, OS/2, Windows NT, Netware, and VM hosts.

      Touch requires a touch command compatible with the one from the GNU 
      file utilities for OS/2.


 AUTHOR
      maxiftp was written by Albert Crosby <acrosby@uafhp.uark.edu>
      and based on code by the authors of the miniftp client from the IBM 
      rxFTP distribution.  maxiftp borrows concepts from Mike Gleason's
      NcFTP.

      The format of this manual and some of the material was borrowed from 
      the NcFTP distribution and modified to be appropriate for MaxiFTP.


 ADDITIONAL REQUIREMENTS
      MaxiFTP will work with OS/2 2.x and IBM's TCP/IP 1.2.1 or later.

      MaxiFTP requires the rxFTP package from the IBM Employee Written 
      Software (EWS) program.  The rxSock package is needed to determine the 
      actual local hostname, without it the value of the HOSTNAME environment 
      variable will be used.  Additionally, the TOUCH option requires a
      TOUCH command compatible with that provided in the GNU File Utilities 
      for OS/2.


 BUGS
      Correct execution of many commands depends upon proper behavior by the
      remote server.

      The remote server may drop the connection if you take a long time when
      you page remote files.

      Occasionally timeouts will cause MaxiFTP to not recognize when a remote
      host has closed a session until a command is issued.

      Touch requires knowledge of the format of remote directory information.
      If the format of a directory changes or the syntax of the TOUCH command
      changes, MaxiFTP may break.

      Create seems to create 1 byte files on an OS/2 host using FAT and 
      doesn't seem to create any file on a host using HPFS.

 SEE ALSO
      ftp, touch, more

